<?php

namespace App\Exports;

use Illuminate\Contracts\View\View;
use Maatwebsite\Excel\Concerns\FromView;

class BalanceExport implements FromView
{
    protected $assets;
    protected $liabilities;
    protected $capital;
    protected $revenue;
    protected $expenses;

    public function __construct($assets, $liabilities, $capital, $revenue, $expenses)
    {
        $this->assets = $assets;
        $this->liabilities = $liabilities;
        $this->capital = $capital;
        $this->revenue = $revenue;
        $this->expenses = $expenses;
    }

    public function view(): View
    {
        return view('accounts_report.exports.balance_sheet.excel', [
            'assets' => $this->assets,
            'liabilities' => $this->liabilities,
            'capital' => $this->capital,
            'revenue' => $this->revenue,
            'expenses' => $this->expenses
        ]);
    }
}
