<?php

namespace App\Exports;

use Illuminate\Contracts\View\View;
use Maatwebsite\Excel\Concerns\FromView;

class IncomeExport implements FromView
{
    protected $revenue;
    protected $expense;
    protected $report_type;
    protected $startDate;
    protected $endDate;

    public function __construct($revenue, $expense, $startDate, $endDate)
    {
        $this->revenue = $revenue;
        $this->expense = $expense;
        $this->startDate = $startDate;
        $this->endDate = $endDate;
    }

    public function view(): View
    {
        return view('accounts_report.exports.account_income.excel', [
            'revenue' => $this->revenue,
            'expense' => $this->expense,
            'startDate' => $this->startDate,
            'endDate' => $this->endDate
        ]);
    }
}
