<?php

namespace App\Exports;

use Illuminate\Contracts\View\View;
use Maatwebsite\Excel\Concerns\FromView;

class LedgerExport implements FromView
{
    protected $data;
    protected $report_type;
    protected $hide_cheque_date;
    protected $date_from;
    protected $date_to;

    public function __construct($data, $report_type, $hide_cheque_date, $date_from, $date_to)
    {
        $this->data = $data;
        $this->report_type = $report_type;
        $this->hide_cheque_date = $hide_cheque_date;
        $this->date_from = $date_from;
        $this->date_to = $date_to;
    }

    public function view(): View
    {
        return view('accounts_report.exports.account_ledger.excel', [
            'allLedgerReports' => $this->data,
            'report_type' => $this->report_type,
            'hide_cheque_date' => $this->hide_cheque_date,
            'date_from' => $this->date_from,
            'date_to' => $this->date_to
        ]);
    }
}
