<?php

namespace App\Exports;

use Illuminate\Contracts\View\View;
use Maatwebsite\Excel\Concerns\FromView;

class TrialExport implements FromView
{
    protected $data;
    protected $report_type;
    protected $date_from;
    protected $date_to;

    public function __construct($data, $report_type, $date_from, $date_to)
    {
        $this->data = $data;
        $this->report_type = $report_type;
        $this->date_from = $date_from;
        $this->date_to = $date_to;
    }

    public function view(): View
    {
        return view('accounts_report.exports.account_trial.excel', [
            'trialBalance' => $this->data,
            'report_type' => $this->report_type,
            'date_from' => $this->date_from,
            'date_to' => $this->date_to
        ]);
    }
}
