<?php

namespace App\Helpers;

class AccountingHelper
{
    public static function toRoman($num)
    {
        $map = [
            'M' => 1000,
            'CM' => 900,
            'D' => 500,
            'CD' => 400,
            'C' => 100,
            'XC' => 90,
            'L' => 50,
            'XL' => 40,
            'X' => 10,
            'IX' => 9,
            'V' => 5,
            'IV' => 4,
            'I' => 1,
        ];
        $return = '';
        foreach ($map as $roman => $int) {
            while ($num >= $int) {
                $return .= $roman;
                $num -= $int;
            }
        }
        return $return;
    }

    public static function prepareTrialBalanceRows($accounts, $grouped, $report_type = 1, &$totals = [], $depth = 1)
    {
        if ($depth > 10) return [];

        $rows = [];

        foreach ($accounts as $account) {
            $hasChildren = isset($grouped[$account->id]);

            $balance_opening = $account->opening_debit - $account->opening_credit;
            $balance_current = $account->current_debit - $account->current_credit;
            $balance = $account->balance_debit - $account->balance_credit;

            $childTotals = [
                'opening_debit' => max(0, $balance_opening),
                'opening_credit' => max(0, -$balance_opening),
                'current_debit' => max(0, $balance_current),
                'current_credit' => max(0, -$balance_current),
                'balance_debit' => max(0, $balance),
                'balance_credit' => max(0, -$balance),
            ];

            $totals['opening_debit'] += $childTotals['opening_debit'];
            $totals['opening_credit'] += $childTotals['opening_credit'];
            $totals['current_debit'] += $childTotals['current_debit'];
            $totals['current_credit'] += $childTotals['current_credit'];
            $totals['balance_debit'] += $childTotals['balance_debit'];
            $totals['balance_credit'] += $childTotals['balance_credit'];

            $label = self::toRoman($depth) . '.';

            $row = [
                'account_id' => $account->account_id,
                'account_name' => $label . ' ' . $account->account_name,
            ];

            if ($report_type == 2) {
                $row['opening_debit'] = $childTotals['opening_debit'];
                $row['opening_credit'] = $childTotals['opening_credit'];
                $row['current_debit'] = $childTotals['current_debit'];
                $row['current_credit'] = $childTotals['current_credit'];
            }

            $row['balance_debit'] = $childTotals['balance_debit'];
            $row['balance_credit'] = $childTotals['balance_credit'];

            $rows[] = $row;

            if ($hasChildren) {
                $childRows = self::prepareTrialBalanceRows(
                    $grouped[$account->id],
                    $grouped,
                    $report_type,
                    $totals,
                    $depth + 1
                );

                $rows = array_merge($rows, $childRows);
            }
        }

        return $rows;
    }
}
