<?php

namespace App\Helpers;

class NumberToWords
{
    private static $ones = [
        1 => 'one',
        2 => 'two',
        3 => 'three',
        4 => 'four',
        5 => 'five',
        6 => 'six',
        7 => 'seven',
        8 => 'eight',
        9 => 'nine',
        10 => 'ten',
        11 => 'eleven',
        12 => 'twelve',
        13 => 'thirteen',
        14 => 'fourteen',
        15 => 'fifteen',
        16 => 'sixteen',
        17 => 'seventeen',
        18 => 'eighteen',
        19 => 'nineteen'
    ];

    private static $tens = [
        2 => 'twenty',
        3 => 'thirty',
        4 => 'forty',
        5 => 'fifty',
        6 => 'sixty',
        7 => 'seventy',
        8 => 'eighty',
        9 => 'ninety'
    ];

    private static $scales = [
        '',
        'thousand',
        'million',
        'billion',
        'trillion'
    ];

    public static function convert($number)
    {
        if ($number == 0) {
            return 'zero';
        }

        if ($number < 0) {
            return 'minus ' . self::convert(abs($number));
        }

        $words = [];
        $scaleIndex = 0; // Track the scale position (thousands, millions, etc.)

        // Loop through scales (thousand, million, etc.) from largest to smallest
        while ($number > 0) {
            // Process each 3-digit group (hundreds, tens, and ones)
            $group = $number % 1000; // Get the last three digits (e.g., for 12345, get 345)
            if ($group > 0) {
                $words[] = self::convertHundreds($group) . ($scaleIndex > 0 ? ' ' . self::$scales[$scaleIndex] : '');
            }
            $number = floor($number / 1000); // Reduce number by dividing by 1000
            $scaleIndex++; // Move to the next scale (thousand, million, etc.)
        }

        // Reverse the words array as we constructed the result in reverse order
        return implode(' ', array_reverse($words));
    }

    private static function convertHundreds($number)
    {
        $words = [];

        $hundreds = floor($number / 100);
        if ((int) $hundreds > 0) {
            $words[] = self::$ones[$hundreds] . ' hundred';
            $number %= 100; // Remaining amount after subtracting hundreds
        }

        // Only process tens and ones if there's a remainder after hundreds
        if ($number > 0) {
            if ($number >= 20) {
                $words[] = self::$tens[floor($number / 10)];
                $number %= 10;
            }

            if ($number > 0) {
                $words[] = self::$ones[$number];
            }
        }

        return implode(' ', $words);
    }

    public static function ordinal($number)
    {
        $suffixes = ['th', 'st', 'nd', 'rd', 'th', 'th', 'th', 'th', 'th', 'th'];

        if (($number % 100) >= 11 && ($number % 100) <= 13) {
            // Special case for 11, 12, 13
            return $number . 'th';
        }

        return $number . $suffixes[$number % 10];
    }

    public static function ordinalWords($number)
    {
        $ordinals = [
            1 => 'first',
            2 => 'second',
            3 => 'third',
            4 => 'fourth',
            5 => 'fifth',
            6 => 'sixth',
            7 => 'seventh',
            8 => 'eighth',
            9 => 'ninth',
            10 => 'tenth',
            11 => 'eleventh',
            12 => 'twelfth',
            13 => 'thirteenth',
            14 => 'fourteenth',
            15 => 'fifteenth',
            16 => 'sixteenth',
            17 => 'seventeenth',
            18 => 'eighteenth',
            19 => 'nineteenth',
            20 => 'twentieth',
            30 => 'thirtieth',
            40 => 'fortieth',
            50 => 'fiftieth',
            60 => 'sixtieth',
            70 => 'seventieth',
            80 => 'eightieth',
            90 => 'ninetieth'
        ];

        if (isset($ordinals[$number])) {
            return strtoupper($ordinals[$number]);
        }

        if ($number < 100) {
            $tens = floor($number / 10) * 10;
            $ones = $number % 10;
            if (isset($ordinals[$ones])) {
                return strtoupper(self::$tens[$tens / 10] . '-' . $ordinals[$ones]);
            }
        }

        return strtoupper(self::convert($number) . 'th');
    }
}
