<?php

namespace App\Http\Controllers\Accounts;

use App\Http\Controllers\Controller;
use App\Models\AccountCategory;
use App\Models\AccountSubCategory;
use App\Models\ChartOfAccounts;
use App\Models\ChequeBookDetail;
use App\Models\ChequeBookMaster;
use App\Models\Employees;
use App\Models\TransactionDetail;
use App\Models\TransactionMaster;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
// use Livewire\Component;

class AccountMovementController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function showMoveEntriesForm()
    {
        $accounts = ChartOfAccounts::where('status', 1)->get();

        return view('move_entries.move_entries', compact('accounts'));
    }

    // public function moveAccountEntries(Request $request)
    // {
    //     $validated = $request->validate([
    //         'from_account_id' => 'required|exists:chart_of_accounts,id',
    //         'to_account_id' => 'required|exists:chart_of_accounts,id|different:from_account_id'
    //     ]);

    //     DB::beginTransaction();

    //     $fromAccountId = $validated['from_account_id'];
    //     $toAccountId = $validated['to_account_id'];

    //     try {
    //         $fromAccount = ChartOfAccounts::findOrFail($fromAccountId);
    //         $toAccount = ChartOfAccounts::findOrFail($toAccountId);

    //         // Move journal entries
    //         $movedCount = TransactionDetail::where('account_id', $fromAccountId)
    //             ->update(['account_id' => $toAccountId]);

    //         // Optionally, mark the old account as inactive
    //         $fromAccount->update(['status' => 0, 'generic' => 'Merged into account ID ' . $toAccountId]);

    //         DB::commit();

    //         return [
    //             'status' => 'success',
    //             'message' => "{$movedCount} entries moved from {$fromAccount->name} to {$toAccount->name}."
    //         ];
    //     } catch (\Exception $e) {
    //         DB::rollBack();

    //         return [
    //             'status' => 'error',
    //             'message' => 'Account movement failed: ' . $e->getMessage()
    //         ];
    //     }
    // }
    public function moveAccountEntries(Request $request)
    {
        $validated = $request->validate([
            'from_account_id' => 'required|exists:chart_of_accounts,id',
            'to_account_id' => 'required|exists:chart_of_accounts,id|different:from_account_id'
        ]);

        DB::beginTransaction();

        try {
            $fromAccount = ChartOfAccounts::findOrFail($validated['from_account_id']);
            $toAccount = ChartOfAccounts::findOrFail($validated['to_account_id']);
            // dd($fromAccount, $toAccount);
            $baseCode = $toAccount->account_code;

            // Get children under toAccount (by parent_account_id = toAccount->id)
            $children = ChartOfAccounts::where('parent_account_id', $toAccount->id)->pluck('account_code')->toArray();

            // Find the next available 3-digit suffix
            $nextSuffix = '001';
            if (!empty($children)) {
                $lastSuffix = collect($children)->map(function ($code) use ($baseCode) {
                    return (int)substr($code, strlen($baseCode));
                })->max();
                $nextSuffix = str_pad($lastSuffix + 1, 3, '0', STR_PAD_LEFT);
            }

            $newAccountCode = $baseCode . $nextSuffix;
            $oldCode = $fromAccount->account_code;

            // Update fromAccount
            $fromAccount->update([
                'parent_account_id' => $toAccount->id, // ✅ Correct: use ID, not code
                'account_code' => $newAccountCode,
                'generic' => 'Merged under account CODE ' . $toAccount->account_code . 'From account CODE ' . $oldCode
            ]);

            // Recursively update children
            $this->updateChildCodes($fromAccount, $oldCode, $newAccountCode);


            DB::commit();
            return redirect()->back()->with('success', "{$fromAccount->name} has been moved under {$toAccount->name}.");
        } catch (\Exception $e) {
            DB::rollBack();
            return redirect()->back()->with('error', $e->getMessage());
        }
    }

    private function updateChildCodes($parentAccount, $oldPrefix, $newPrefix)
    {
        $children = ChartOfAccounts::where('parent_account_id', $parentAccount->id)->get();

        foreach ($children as $child) {
            $oldCode = $child->account_code;
            $newCode = preg_replace('/^' . preg_quote($oldPrefix, '/') . '/', $newPrefix, $oldCode);

            $child->update([
                'account_code' => $newCode,
                'parent_account_id' => $parentAccount->id, // ✅ Keep correct hierarchy
                'generic' => 'Merged under account CODE ' . $parentAccount->account_code . 'From account CODE ' . $oldCode
            ]);


            // Recursive call for deeper levels
            $this->updateChildCodes($child, $oldCode, $newCode);
        }
    }
}
