<?php

namespace App\Http\Controllers\Accounts;

use App\Http\Controllers\Controller;
use App\Models\AccountCategory;
use App\Models\AccountSubCategory;
use App\Models\ChartOfAccounts;
use App\Models\Employees;
use App\Models\TransactionDetail;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;

// use Livewire\Component;

class ChartOfAccountController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    // public function index(Request $request)
    // {
    //     $category_id = $request->category_id;

    //     // $chart_of_accounts = ChartOfAccounts::where('status', 1)
    //     //     ->when($category_id, function ($q) use ($category_id) {
    //     //         $q->where('category_id', $category_id);
    //     //     })
    //     //     ->paginate(10);

    //     // Get filter parameters from the request
    //     $filterBy = $request->filterBy;
    //     $filterValue = null;

    //     if($request->sub_category_id){
    //         $filterValue = $request->sub_category_id;
    //     }else if ($request->parent_account_id){
    //         $filterValue = $request->parent_account_id;
    //     }else if($request->category_id){
    //         $filterValue = $request->category_id;
    //     }else{
    //         $filterValue = $request->filterValue;
    //     }


    //     // dd($filterValue);

    //     // dd($filterBy, $filterValue);

    //     if ($filterBy && $filterValue) {
    //         switch ($filterBy) {
    //             case 'account_code':
    //                 $chart_of_accounts = ChartOfAccounts::where('account_code', $filterValue)
    //                     ->when($category_id, function ($q) use ($category_id) {
    //                         $q->where('category_id', $category_id);
    //                     })
    //                     ->paginate(10);
    //                 break;
    //             case 'parent_account_id':
    //                 $chart_of_accounts = ChartOfAccounts::where('parent_account_id', $filterValue)
    //                 ->when($category_id, function ($q) use ($category_id) {
    //                     $q->where('category_id', $category_id);
    //                 })
    //                 ->paginate(10);
    //                 break;
    //             case 'name':
    //                 $chart_of_accounts = ChartOfAccounts::where('name', $filterValue)
    //                 ->when($category_id, function ($q) use ($category_id) {
    //                     $q->where('category_id', $category_id);
    //                 })
    //                 ->paginate(10);
    //                 break;
    //             case 'category_id':
    //                 $chart_of_accounts = ChartOfAccounts::where('category_id', $filterValue)
    //                 ->when($category_id, function ($q) use ($category_id) {
    //                     $q->where('category_id', $category_id);
    //                 })
    //                 ->paginate(10);
    //                 break;
    //             case 'sub_category_id':
    //                 $chart_of_accounts = ChartOfAccounts::where('sub_category_id', $filterValue)
    //                 ->when($category_id, function ($q) use ($category_id) {
    //                     $q->where('category_id', $category_id);
    //                 })
    //                 ->paginate(10);
    //                 break;
    //             case 'pl_category_id':
    //                 $chart_of_accounts = ChartOfAccounts::where('pl_category_id', $filterValue)
    //                 ->when($category_id, function ($q) use ($category_id) {
    //                     $q->where('category_id', $category_id);
    //                 })
    //                 ->paginate(10);
    //                 break;
    //             default:
    //                 return redirect()->back()->with('error', 'Invalid filter key: ' . $filterBy);
    //         }
    //     } else {
    //         $chart_of_accounts = ChartOfAccounts::where('status', 1)
    //             ->when($category_id, function ($q) use ($category_id) {
    //                 $q->where('category_id', $category_id);
    //             })
    //             ->paginate(10);
    //     }

    //     $account_categories = AccountCategory::all();
    //     $account_sub_categories = AccountSubCategory::all();
    //     $parent_accounts = ChartOfAccounts::all();
    //     return view('chart_of_accounts.index', compact('chart_of_accounts', 'account_categories', 'account_sub_categories', 'parent_accounts'));
    // }

    public function index(Request $request)
    {
        $category_id = $request->category_id;

        // Get filter parameters from the request
        $filterBy = $request->filterBy;
        $filterValue = null;

        if ($request->sub_category_id) {
            $filterValue = $request->sub_category_id;
        } elseif ($request->parent_account_id) {
            $filterValue = $request->parent_account_id;
        } elseif ($request->category_id) {
            $filterValue = $request->category_id;
        } else {
            $filterValue = $request->filterValue;
        }

        // Initialize the query
        $query = ChartOfAccounts::query();

        // Apply filters
        if ($filterBy && $filterValue) {
            switch ($filterBy) {
                case 'account_code':
                    $query->where('account_code', $filterValue);
                    break;
                case 'parent_account_id':
                    $query->where('parent_account_id', $filterValue);
                    break;
                case 'name':
                    $query->where('name', 'like', '%' . $filterValue . '%');
                    break;
                case 'category_id':
                    $query->where('category_id', $filterValue);
                    break;
                case 'sub_category_id':
                    $query->where('sub_category_id', $filterValue);
                    break;
                case 'pl_category_id':
                    $query->where('pl_category_id', $filterValue);
                    break;
                default:
                    return redirect()->back()->with('error', 'Invalid filter key: ' . $filterBy);
            }
        }

        // Apply date filter
        if ($request->filled('date_filter')) {
            $dateFilter = $request->input('date_filter');
            if ($dateFilter == 'today') {
                $query->whereDate('created_at', today());
            } elseif ($dateFilter == 'this_week') {
                $query->whereBetween('created_at', [now()->startOfWeek(), now()->endOfWeek()]);
            } elseif ($dateFilter == 'this_month') {
                $query->whereBetween('created_at', [now()->startOfMonth(), now()->endOfMonth()]);
            } elseif ($dateFilter == 'custom') {
                if ($request->filled('date_from') && $request->filled('date_to')) {
                    $query->whereBetween('created_at', [$request->input('date_from'), $request->input('date_to')]);
                }
            }
        }

        // Apply category_id filter if present
        if ($category_id) {
            $query->where('category_id', $category_id);
        }

        // Retrieve paginated results
        $chart_of_accounts = $query->paginate(10);

        // Retrieve necessary data for the view
        $account_categories = AccountCategory::all();
        $account_sub_categories = AccountSubCategory::all();
        $parent_accounts = ChartOfAccounts::all();

        $topLevelCategories = AccountCategory::all();
        $allCategories = AccountCategory::all()->keyBy('id');
        $accounts = ChartOfAccounts::all();
        $account_categories = AccountCategory::all(); // For form dropdown

        return view('chart_of_accounts.index', compact('chart_of_accounts', 'account_categories', 'account_sub_categories', 'parent_accounts', 'topLevelCategories', 'allCategories', 'accounts', 'account_categories'));
    }


    public function add()
    {
        $account_categories = AccountCategory::all();
        $account_sub_categories = AccountSubCategory::all();
        $parent_accounts = ChartOfAccounts::all();

        return view('chart_of_accounts.add', compact('parent_accounts', 'account_categories', 'account_sub_categories'));
    }

    public function store(Request $request)
    {
        // dd($request->all());
        try {
            $pl_category_id = null;
            if ($request->category_id == 3) {
                $pl_category_id = 5;
            } elseif ($request->category_id == 4) {
                $pl_category_id = 4;
            }

            ChartOfAccounts::create([
                'name' => strtoupper($request->name),
                'account_code' => $request->account_code,
                'alias' => $request->alias,
                'max_child_account' => $request->max_child_account,
                'category_id' => $request->category_id,
                'sub_category_id' => $request->sub_category_id,
                'pl_category_id' => $pl_category_id,
                'reference_number' => $request->reference_number,
                'parent_account_id' => $request->parent_account_id,
                'status' => $request->status,
                // 'level' => 4,
                'allow_voucher_entry' => $request->allow_voucher_entry
            ]);

            return redirect('accounts/chart_of_account');
        } catch (Exception $e) {
            dd($e);
        }
    }

    public function edit(ChartOfAccounts $account)
    {
        $account_categories = AccountCategory::all();
        $account_sub_categories = AccountSubCategory::all();
        $parent_accounts = ChartOfAccounts::whereNot('id', $account->id)->get();

        return view('chart_of_accounts.edit', compact('account', 'account_categories', 'account_sub_categories', 'parent_accounts'));
    }

    public function update(ChartOfAccounts $account, Request $request)
    {
        // dd($request->all());
        try {
            $pl_category_id = null;
            if ($request->category_id == 3) {
                $pl_category_id = 5;
            } elseif ($request->category_id == 4) {
                $pl_category_id = 4;
            }


            ChartOfAccounts::where('id', $account->id)->update([
                'name' => $request->name,
                'account_code' => $request->account_code,
                'alias' => $request->alias,
                'max_child_account' => $request->max_child_account,
                'category_id' => $request->category_id,
                'sub_category_id' => $request->sub_category_id,
                'pl_category_id' => $pl_category_id,
                'reference_number' => $request->reference_number,
                // 'parent_account_id' => $request->parent_account_id,
                'status' => $request->status,
                'allow_voucher_entry' => $request->allow_voucher_entry
            ]);

            return redirect('accounts/chart_of_account');
        } catch (Exception $e) {
            dd($e);
        }
    }

    public function delete(ChartOfAccounts $account)
    {
        // Check if the account has child accounts
        $hasChildren = ChartOfAccounts::where('parent_account_id', $account->id)->exists();

        if ($hasChildren) {
            return response()->json([
                'message' => 'Cannot delete account with existing child accounts.',
            ], 400);
        }

        // Check if the account is used in any transactions
        $isUsedInTransactions = TransactionDetail::where('account_id', $account->id)->exists();

        if ($isUsedInTransactions) {
            return response()->json([
                'message' => 'Cannot delete account as it is being used in transactions.',
            ], 400);
        }

        // Soft delete the account
        $account->update([
            'deleted_at' => now(),
            'deleted_by' => auth()->user()->id,
        ]);

        return response()->json([
            'message' => 'Account deleted successfully.',
        ], 200);
    }
}
