<?php

namespace App\Http\Controllers\Accounts;

use App\Http\Controllers\Controller;
use App\Models\AccountCategory;
use App\Models\AccountSubCategory;
use App\Models\ChartOfAccounts;
use App\Models\ChequeBookDetail;
use App\Models\ChequeBookMaster;
use App\Models\Employees;
use App\Models\TransactionMaster;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
// use Livewire\Component;

class ChequeBookController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function index(Request $request)
    {
        $cheque_books = ChequeBookMaster::where('status', 1)
            ->paginate(10);

        return view('cheque_book_stock.index', compact('cheque_books'));
    }

    public function add()
    {
        $account_categories = AccountCategory::all();
        $account_sub_categories = AccountSubCategory::all();
        $chart_of_accounts = ChartOfAccounts::where('status', 1)->where('sub_category_id', 2)->get();

        return view('cheque_book_stock.add', compact('chart_of_accounts', 'account_categories', 'account_sub_categories'));
    }

    public function store(Request $request)
    {
        try {

            // dd($request->all());

            $cheque_book_master = ChequeBookMaster::create([
                'account_id' => $request->account_id,
                'prefix' => $request->prefix,
                'starting_no' => $request->starting_no,
                'number_of_leafs' => $request->number_of_leafs,
                'date_of_request' => $request->date_of_request,
                'issue_date' => $request->issue_date,
                'activation_date' => $request->activation_date,
                'status' => $request->status
            ]);

            $prefix = $request->prefix;
            $starting = (int) $request->starting_no;

            for ($number_of_leafs = 0; $number_of_leafs < $request->number_of_leafs; $number_of_leafs++) {
                $cheque_number = $prefix . $starting;

                $cheque_book_detail = ChequeBookDetail::create([
                    'cheque_book_master_id' => $cheque_book_master->id,
                    'cheque_number' => $cheque_number,
                    'status' => 1
                ]);

                $starting++;
            }

            return redirect('accounts/cheque_book');
        } catch (Exception $e) {
            dd($e);
        }
    }

    public function edit(ChequeBookMaster $cheque_book_master)
    {
        $account_categories = AccountCategory::all();
        $account_sub_categories = AccountSubCategory::all();
        $chart_of_accounts = ChartOfAccounts::where('status', 1)->where('sub_category_id', 2)->get();

        $cheque_book_detail = ChequeBookDetail::first();

        // dd($cheque_book_detail->utilised);

        return view('cheque_book_stock.edit', compact('cheque_book_master', 'account_categories', 'account_sub_categories', 'chart_of_accounts'));
    }

    public function update(ChartOfAccounts $account, Request $request)
    {
        try {

            ChartOfAccounts::where('id', $account->id)->update([
                'name' => $request->name,
                'account_code' => $request->account_code,
                'alias' => $request->alias,
                'max_child_account' => $request->max_child_account,
                'category_id' => $request->category_id,
                'sub_category_id' => $request->sub_category_id,
                // 'pl_category_id' => $request->name,
                'reference_number' => $request->reference_number,
                'parent_account_id' => $request->parent_account_id,
                'status' => $request->status
            ]);

            return redirect('accounts/cheque_book');
        } catch (Exception $e) {
            dd($e);
        }
    }

    public function delete(ChartOfAccounts $account)
    {
        ChartOfAccounts::where('id', $account->id)->update([
            'deleted_at' => now(),
            'deleted_by' => 1,
        ]);

        return redirect('accounts/cheque_book');
    }
}
