<?php

namespace App\Http\Controllers\Accounts;

use App\Http\Controllers\Controller;
use App\Models\AccountCategory;
use App\Models\AccountSubCategory;
use App\Models\ChartOfAccounts;
use App\Models\CostCenter;
use App\Models\Employees;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;

class CostCenterController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    
    public function index()
    {
        $cost_center = CostCenter::where('status', 1)->paginate(10);

        return view('cost_center.index', compact('cost_center'));
    }

    public function add()
    {
        return view('cost_center.add');
    }

    public function store(Request $request)
    {
        try {

            CostCenter::create([
                'name' => $request->name,
                'short_code' => $request->short_code,
                'remarks' => $request->remarks,
                'status' => $request->status
            ]);

            return redirect('accounts/cost_center');
        } catch (Exception $e) {
            dd($e);
        }
    }

    public function edit(CostCenter $cost_center)
    {
        return view('cost_center.edit', compact('cost_center'));
    }

    public function update(CostCenter $cost_center, Request $request)
    {
        try {

            CostCenter::where('id', $cost_center->id)->update([
                'name' => $request->name,
                'short_code' => $request->short_code,
                'remarks' => $request->remarks,
                'status' => $request->status
            ]);

            return redirect('accounts/cost_center');
        } catch (Exception $e) {
            dd($e);
        }
    }

    public function delete(CostCenter $cost_center)
    {
        CostCenter::where('id', $cost_center->id)->update([
            'deleted_at' => now(),
            'deleted_by' => 1,
        ]);

        return redirect('accounts/cost_center');
    }
}
