<?php

namespace App\Http\Controllers\Accounts;

use App\Http\Controllers\Controller;
use App\Models\AccountCategory;
use App\Models\AccountSubCategory;
use App\Models\ChartOfAccounts;
use App\Models\CostCenter;
use App\Models\DepartmentMaster;
use App\Models\Employees;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;

class DepartmentController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    
    public function index()
    {
        $department_master = DepartmentMaster::where('status', 1)->paginate(10);

        return view('department_master.index', compact('department_master'));
    }

    public function add()
    {
        return view('department_master.add');
    }

    public function store(Request $request)
    {
        try {

            DepartmentMaster::create([
                'name' => $request->name,
                'short_code' => $request->short_code,
                'remarks' => $request->remarks,
                'status' => $request->status
            ]);

            return redirect('accounts/department_master');
        } catch (Exception $e) {
            dd($e);
        }
    }

    public function edit(DepartmentMaster $department_master)
    {
        return view('department_master.edit', compact('department_master'));
    }

    public function update(DepartmentMaster $department_master, Request $request)
    {
        try {

            DepartmentMaster::where('id', $department_master->id)->update([
                'name' => $request->name,
                'short_code' => $request->short_code,
                'remarks' => $request->remarks,
                'status' => $request->status
            ]);

            return redirect('accounts/department_master');
        } catch (Exception $e) {
            dd($e);
        }
    }

    public function delete(DepartmentMaster $department_master)
    {
        DepartmentMaster::where('id', $department_master->id)->update([
            'deleted_at' => now(),
            'deleted_by' => 1,
        ]);

        return redirect('accounts/department_master');
    }
}
