<?php

namespace App\Http\Controllers\Accounts;

use App\Http\Controllers\Controller;
use App\Models\AccountCategory;
use App\Models\AccountSubCategory;
use App\Models\ChartOfAccounts;
use App\Models\ChequeBookDetail;
use App\Models\CostCenter;
use App\Models\CurrencyMaster;
use App\Models\DepartmentMaster;
use App\Models\Employees;
use App\Models\LocationMaster;
use App\Models\PaymentTypeMaster;
use App\Models\TransactionDetail;
use App\Models\TransactionMaster;
use App\Models\TransactionStatusMaster;
use App\Models\TransactionTypeMaster;
use Exception;
use Illuminate\Http\Request;
use App\Http\Controllers\LogsController;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\DB;

class GeneralVoucherController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    // public function index(Request $request)
    // {
    //     // Get filter parameters from the request
    //     $filterBy = $request->filterBy;
    //     $filterValue = null;
    //     // dd($filterBy, $filterValue);
    //     if ($request->currency_id) {
    //         $filterValue = $request->currency_id;
    //     } else if ($request->account_id) {
    //         $filterValue = $request->account_id;
    //     } else if ($request->cost_center_id) {
    //         $filterValue = $request->cost_center_id;
    //     } else {
    //         $filterValue = $request->filterValue;
    //     }

    //     $transaction_master = TransactionMaster::paginate(10);
    //     // dd($transaction_master);

    //     if ($filterBy && $filterValue) {
    //         switch ($filterBy) {
    //             case 'voucher_no':
    //                 $transaction_master = TransactionMaster::where('voucher_no', $filterValue)->paginate(10);
    //                 break;
    //             case 'date':
    //                 $transaction_master = TransactionMaster::where('date', $filterValue)->paginate(10);
    //                 break;
    //             case 'currency_id':
    //                 $transaction_master = TransactionMaster::where('currency_id', $filterValue)->paginate(10);
    //                 break;
    //             case 'account_id':
    //                 $transaction_master = TransactionMaster::where('account_id', $filterValue)->paginate(10);
    //                 break;
    //             case 'cost_center_id':
    //                 $transaction_master = TransactionMaster::where('cost_center_id', $filterValue)->paginate(10);
    //                 break;
    //             case 'narration':
    //                 $transaction_master = TransactionMaster::where('narration', $filterValue)->paginate(10);
    //                 break;
    //             default:
    //                 return redirect()->back()->with('error', 'Invalid filter key: ' . $filterBy);
    //         }
    //     } else {
    //         $transaction_master = TransactionMaster::paginate(10);
    //     }

    //     $transaction_type_master = TransactionTypeMaster::all();
    //     $chart_of_accounts = ChartOfAccounts::where('status', 1)->get();
    //     $cost_centers = CostCenter::where('status', 1)->get();

    //     return view('general_voucher.index', compact('transaction_master', 'transaction_type_master', 'chart_of_accounts', 'cost_centers'));
    // }

    public function index(Request $request)
    {
        // Get pagination settings
        $perPage = $request->input('perPage', session('perPage', 100));
        session(['perPage' => $perPage]);

        // Get filter parameters from the request
        $filterBy = $request->filterBy;
        $filterValue = null;

        if ($request->currency_id) {
            $filterValue = $request->currency_id;
        } else if ($request->account_id) {
            $filterValue = $request->account_id;
        } else if ($request->cost_center_id) {
            $filterValue = $request->cost_center_id;
        } else if ($request->status_id) {
            $filterValue = $request->status_id;
        } else {
            $filterValue = $request->filterValue;
        }

        // Start building the query
        $query = TransactionMaster::query();

        // Apply filters
        if ($filterBy && $filterValue) {
            switch ($filterBy) {
                case 'voucher_no':
                    $query->where('voucher_no', $filterValue);
                    break;
                case 'currency_id':
                    $query->where('currency_id', $filterValue);
                    break;
                case 'account_id':
                    $query->where('account_id', $filterValue)->orWhere('party_id', $filterValue);
                    break;
                case 'cost_center_id':
                    $query->where('cost_center_id', $filterValue);
                    break;
                case 'narration':
                    $query->where('narration', 'like', '%' . $filterValue . '%');
                    break;
                case 'cheque_number':
                    $query->where('cheque_number', 'like', '%' . $filterValue . '%');
                    break;
                case 'status_id':
                    $query->where('status', $filterValue);
                    break;
                default:
                    return redirect()->back()->with('error', 'Invalid filter key: ' . $filterBy);
            }
        }

        // Apply date filter
        if ($request->filled('date_filter')) {
            $dateFilter = $request->input('date_filter');
            if ($dateFilter == 'today') {
                $query->whereDate('created_at', today());
            } elseif ($dateFilter == 'this_week') {
                $query->whereBetween('created_at', [now()->startOfWeek(), now()->endOfWeek()]);
            } elseif ($dateFilter == 'this_month') {
                $query->whereBetween('created_at', [now()->startOfMonth(), now()->endOfMonth()]);
            } elseif ($dateFilter == 'custom') {
                if ($request->filled('date_from') && $request->filled('date_to')) {
                    $query->whereBetween('created_at', [$request->input('date_from'), $request->input('date_to')]);
                }
            }
        }
        
        $query->whereNotIn('transaction_type_master_id', [4, 10]);

        // Apply default condition to include records where receipt_payment_id is NULL
        $query->whereNull('receipt_payment_id');

        // Retrieve filtered and paginated results
        $transaction_master = $query->orderBy('id', 'DESC')->paginate($perPage);

        // Retrieve necessary data for the view
        $transaction_type_master = TransactionTypeMaster::all();
        $chart_of_accounts = ChartOfAccounts::where('status', 1)->get();
        $cost_centers = CostCenter::where('status', 1)->get();
        $transaction_master_status = TransactionStatusMaster::all();

        return view('general_voucher.index', compact('transaction_master', 'transaction_type_master', 'chart_of_accounts', 'cost_centers', 'transaction_master_status'));
    }

    public function add()
    {
        $payment_type_master = PaymentTypeMaster::all();
        $transaction_type_master = TransactionTypeMaster::all();
        $chart_of_accounts = ChartOfAccounts::where('status', 1)->whereIn('level', [3, 4])->get();
        $cost_centers = CostCenter::where('status', 1)->get();
        $bank_accounts = ChartOfAccounts::where('sub_category_id', 2)->where('status', 1)->get();
        $cash_accounts = ChartOfAccounts::where('sub_category_id', 1)->where('status', 1)->get();
        $currencies = CurrencyMaster::where('status', 1)->get();

        return view('general_voucher.add', compact('transaction_type_master', 'chart_of_accounts', 'cost_centers', 'payment_type_master', 'bank_accounts', 'cash_accounts', 'currencies'));
    }

    public function store(Request $request)
    {
        try {
            // dd($request->all());
            $exchange_rate = number_format((float) $request->exchange_rate, 2, '.', '');

            // dd($exchange_rate);

            $transaction_type_master = TransactionTypeMaster::where('id', $request->voucher_type_id)->first();

            $last_voucher_number = TransactionMaster::where('transaction_type_master_id', $transaction_type_master->id)
                ->max('voucher_no');

            $sequence_number = ($last_voucher_number) ? intval(substr($last_voucher_number, -5)) + 1 : 1;
            $sequence_number_padded = str_pad($sequence_number, 5, '0', STR_PAD_LEFT);
            $year = date('y', strtotime($request->date));
            $new_voucher_number = $transaction_type_master->transaction_name . '-' . $sequence_number_padded . '/' . $year;
            // dd($new_voucher_number);

            $reference_number = '';
            $reference_date = '';

            foreach ($request['reference_number'] as $key => $value) {
                if ($value) {
                    $reference_number = $value;
                }
            }

            foreach ($request['reference_date'] as $key => $value) {
                if ($value) {
                    $reference_date = $value;
                }
            }

            $cheque = null;

            if ($reference_number) {
                $cheque = ChequeBookDetail::where('cheque_number', $reference_number)->first();

                // dd($cheque);

                if ($cheque) {
                    $cheque->status = 2;
                    $cheque->save();
                }
            }

            $transaction_master = TransactionMaster::create([
                'transaction_no' => $new_voucher_number,
                'date' => $request->date,
                'transaction_type_master_id' => $request->transaction_type_master_id,
                'account_id' => $request->master_account_id,
                'cost_center_id' => $request->cost_center_id,
                'party_id' => $request->party_id,
                'currency_id' => $request->currency_id,
                'exchange_rate' => $exchange_rate,
                'cheque_number' => $request->cheque_number,
                'cheque_id' => @$cheque->id,
                'cheque_date' => $request->cheque_date,
                'total_debit' => $request->total_debit,
                'total_credit' => $request->total_credit,
                // 'bank_sub_type' => $request->bank_sub_type,
                'company_id' => 1,
                'status' => 1,
                'narration' => $request->summary_narration,
                'created_by' => auth()->user()->id,
                'voucher_type_id' => $request->voucher_type_id,
                'reference_date' => $reference_date,
                'reference_number' => $reference_number,
                'nature' => $request->nature,
                'total_debit_converted' => $request->total_debit_converted,
                'total_credit_converted' => $request->total_credit_converted,
            ]);

            // dd('test');
            $debit_vc = 0;
            $crebit_vc = 0;
            foreach ($request->account_id as $key => $value) {
                $debit_vc = (int) $request->debit[$key] * (float) $request->exchange_rate;
                $crebit_vc = (int) $request->credit[$key] * (float) $request->exchange_rate;
                TransactionDetail::create([
                    'transaction_master_id' => $transaction_master->id,
                    'account_id' => $value,
                    // 'cost_center_id' => $request->cost_center_detail[$key],
                    'debit_vc' => $debit_vc,
                    'credit_vc' => $crebit_vc,
                    'debit_lc' => $request->debit[$key],
                    'credit_lc' => $request->credit[$key],
                    'narration' => $request->narration[$key],
                    'status' => 1
                ]);
            }

            if ($request->cheque_number) {
                ChequeBookDetail::where('cheque_number', $request->cheque_number)->update([
                    'status' => 2
                ]);
            }

            // dd('test');

            // return redirect('accounts/general-voucher');
            return redirect('accounts/general-voucher/edit/' . $transaction_master->id)->with('success', 'Record Created SuccessFully!');
        } catch (Exception $e) {
            dd($e);
        }
    }

    public function edit(TransactionMaster $transaction_master)
    {
        if ($transaction_master->voucher_type_id == 1) {
            // Bank Payment voucher
            $bank_accounts = ChartOfAccounts::where('sub_category_id', 2)->whereIn('level', [3, 4])->where('status', 1)->get();
            $chart_of_accounts = ChartOfAccounts::whereIn('level', [3, 4])->where('status', 1)->get();
        } else if ($transaction_master->voucher_type_id == 3) {
            // Cash Payment voucher
            $bank_accounts = ChartOfAccounts::where('sub_category_id', 1)->whereIn('level', [3, 4])->where('status', 1)->get();
            $chart_of_accounts = ChartOfAccounts::whereIn('level', [3, 4])->where('status', 1)->get();
        } else if ($transaction_master->voucher_type_id == 2) {
            // Bank Receipt voucher
            $bank_accounts = ChartOfAccounts::where('sub_category_id', 2)->whereIn('level', [3, 4])->where('status', 1)->get();
            $chart_of_accounts = ChartOfAccounts::whereIn('level', [3, 4])->where('status', 1)->get();
        } else if ($transaction_master->voucher_type_id == 5) {
            // Cash Receipt voucher
            $bank_accounts = ChartOfAccounts::where('sub_category_id', 1)->whereIn('level', [3, 4])->where('status', 1)->get();
            $chart_of_accounts = ChartOfAccounts::whereIn('level', [3, 4])->where('status', 1)->get();
        } else if ($transaction_master->voucher_type_id == 6 || $transaction_master->voucher_type_id == 8 || $transaction_master->voucher_type_id == 4 || $transaction_master->voucher_type_id == 9 || $transaction_master->voucher_type_id == 10) {
            // JV, CN, DN
            $bank_accounts = ChartOfAccounts::where('status', 1)->whereIn('level', [3, 4])->get();
            $chart_of_accounts = ChartOfAccounts::where('status', 1)->whereIn('level', [3, 4])->get();
        } else if ($transaction_master->voucher_type_id == 7) {
            // Transfer Voucher
            $bank_accounts = ChartOfAccounts::whereIn('sub_category_id', [1, 2])->whereIn('level', [3, 4])->where('status', 1)->get();
            $chart_of_accounts = ChartOfAccounts::whereIn('sub_category_id', [1, 2])->whereIn('level', [3, 4])->where('status', 1)->get();
        }

        $payment_type_master = PaymentTypeMaster::all();
        $transaction_type_master = TransactionTypeMaster::all();
        // $chart_of_accounts = ChartOfAccounts::where('status', 1)->get();
        $cost_centers = CostCenter::where('status', 1)->get();
        // $bank_accounts = ChartOfAccounts::where('sub_category_id', 2)->where('status', 1)->get();
        $cash_accounts = ChartOfAccounts::where('sub_category_id', 1)->where('status', 1)->get();
        $currencies = CurrencyMaster::where('status', 1)->get();

        // dd($bank_accounts);
        // dd($transaction_master->detail);

        return view('general_voucher.edit', compact('transaction_type_master', 'chart_of_accounts', 'cost_centers', 'payment_type_master', 'bank_accounts', 'cash_accounts', 'transaction_master', 'currencies'));
    }

    public function update(TransactionMaster $transaction_master, Request $request)
    {
        // dd($request->all());
        $exchange_rate = number_format((float) $request->exchange_rate, 2, '.', '');
        try {

            $reference_number = '';
            $reference_date = '';

            foreach ($request['reference_number'] as $key => $value) {
                if ($value) {
                    $reference_number = $request['reference_number'][0];
                }
            }

            foreach ($request['reference_date'] as $key => $value) {
                if ($value) {
                    $reference_date = $request['reference_date'][0];
                }
            }

            TransactionMaster::where('id', $transaction_master->id)->update([
                'date' => $request->date,
                'transaction_type_master_id' => $request->transaction_type_master_id,
                'account_id' => $request->master_account_id,
                'cost_center_id' => $request->cost_center_id,
                'party_id' => $request->party_id,
                'currency_id' => $request->currency_id,
                'exchange_rate' => $exchange_rate,
                'cheque_number' => $request->cheque_number,
                'cheque_date' => $request->cheque_date,
                'total_debit' => $request->total_debit,
                'total_credit' => $request->total_credit,
                // 'bank_sub_type' => $request->bank_sub_type,
                'company_id' => 1,
                // 'status' => 1,
                'narration' => $request->summary_narration,
                'created_by' => auth()->user()->id,
                'voucher_type_id' => $request->voucher_type_id,
                'reference_date' => $reference_date,
                'reference_number' => $reference_number,
                'nature' => $request->nature,
                'updated_by' => auth()->user()->id,
                'total_debit_converted' => $request->total_debit_converted,
                'total_credit_converted' => $request->total_credit_converted,
            ]);

            TransactionDetail::where('transaction_master_id', $transaction_master->id)->delete();
            $debit_vc = 0;
            $crebit_vc = 0;
            foreach ($request->account_id as $key => $value) {
                $debit_vc = (int) $request->debit[$key] * (float) $request->exchange_rate;
                $crebit_vc = (int) $request->credit[$key] * (float) $request->exchange_rate;
                TransactionDetail::create([
                    'transaction_master_id' => $transaction_master->id,
                    'account_id' => $value,
                    // 'cost_center_id' => $request->cost_center_detail[$key],
                    'debit_vc' => $debit_vc,
                    'credit_vc' => $crebit_vc,
                    'debit_lc' => $request->debit[$key],
                    'credit_lc' => $request->credit[$key],
                    'narration' => $request->narration[$key],
                    'status' => 1
                ]);
            }

            // return redirect()->back();
            return redirect('accounts/general-voucher/edit/' . $transaction_master->id)->with('success', 'Record Updated SuccessFully!');
        } catch (Exception $e) {
            dd($e);
        }
    }

    public function updateStatus(TransactionMaster $transaction_master, $status)
    {

        $transaction_type_master = TransactionTypeMaster::where('id', $transaction_master->voucher_type_id)->first();

        // $last_voucher_number = TransactionMaster::where('transaction_type_master_id', $transaction_type_master->id)
        //     ->max('voucher_no');
        $last_voucher_number = TransactionMaster::where('voucher_type_id', $transaction_type_master->id)
            ->max('voucher_no');


        // $sequence_number = ($last_voucher_number) ? intval(substr($last_voucher_number, -5)) + 1 : 1;
        if (preg_match('/-(\d{5})\//', $last_voucher_number, $matches)) {
            $sequence_number = intval($matches[1]) + 1;
        } else {
            $sequence_number = 1;
        }
        $sequence_number_padded = str_pad($sequence_number, 5, '0', STR_PAD_LEFT);
        $year = date('y', strtotime($transaction_master->date));
        $new_voucher_number = $transaction_type_master->name . '-' . $sequence_number_padded . '/' . $year;

        if ($status == 4) {
            TransactionMaster::where('id', $transaction_master->id)->update([
                'status' => $status,
                'voucher_no' => $new_voucher_number
            ]);
        } else {
            TransactionMaster::where('id', $transaction_master->id)->update([
                'status' => $status,
                'voucher_no' => null
            ]);
        }

        return redirect()->back();
    }

    public function delete(TransactionMaster $transaction_master)
    {
        TransactionMaster::where('id', $transaction_master->id)->update([
            'deleted_at' => now(),
            'deleted_by' => 1,
        ]);

        return redirect('accounts/general-voucher');
    }
    
        public function destroy($id, LogsController $logController)
    {
        DB::beginTransaction();

        try {
            // Pull master + details in one go (if you have the relation)
            $tm = TransactionMaster::with('detail')->findOrFail($id);

            // Optional guard: don't allow deletion of posted/approved vouchers
            // Adjust the status number to whatever "posted/locked" means in your app
            if ((int) $tm->status === 2) {
                return redirect()->back()->with('error', 'Posted vouchers cannot be deleted.');
            }

            // --- Revert cheque status if one was reserved/used on store() ---
            // You set cheque->status = 2 on store, so flip it back to available (e.g. 1)
            if (!empty($tm->cheque_id)) {
                if ($cheque = ChequeBookDetail::find($tm->cheque_id)) {
                    // Only mark available if no other voucher is using the same cheque
                    $stillUsed = TransactionMaster::where('cheque_id', $tm->cheque_id)
                        ->where('id', '<>', $tm->id)
                        ->exists();

                    if (!$stillUsed) {
                        $cheque->status = 1; // available
                        $cheque->save();
                    }
                }
            } elseif (!empty($tm->cheque_number)) {
                // Fallback by number
                $stillUsed = TransactionMaster::where('cheque_number', $tm->cheque_number)
                    ->where('id', '<>', $tm->id)
                    ->exists();

                if (!$stillUsed) {
                    ChequeBookDetail::where('cheque_number', $tm->cheque_number)
                        ->update(['status' => 1]); // available
                }
            }

            // --- Delete details first (FK safety) ---
            TransactionDetail::where('transaction_master_id', $tm->id)->delete();

            // --- Delete the master ---
            $tm->delete();
            $logController->createLog(__METHOD__, 'success', json_encode(['TransactionMaster' => $tm]), auth()->user(), 'deleted');

            DB::commit();

            // Send user back to listing (adjust route as needed)
            return redirect()->back()->with('success', 'Voucher deleted successfully.');
        } catch (\Throwable $e) {
            DB::rollBack();

            $logController->createLog(__METHOD__, 'error', $e->getMessage(), auth()->user(), '');
            return redirect()->back()->with('error', $e->getMessage());
        }
    }

    public function print(TransactionMaster $transaction_master)
    {
        return view('general_voucher.print', compact('transaction_master'));
    }
}
