<?php

namespace App\Http\Controllers\Accounts;

use App\Http\Controllers\Controller;
use App\Models\AccountCategory;
use App\Models\AccountSubCategory;
use App\Models\ChartOfAccounts;
use App\Models\CostCenter;
use App\Models\DepartmentMaster;
use App\Models\Employees;
use App\Models\LocationMaster;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;

class LocationController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    
    public function index()
    {
        $location_master = LocationMaster::where('status', 1)->paginate(10);

        return view('location_master.index', compact('location_master'));
    }

    public function add()
    {
        return view('location_master.add');
    }

    public function store(Request $request)
    {
        try {

            LocationMaster::create([
                'name' => $request->name,
                'short_code' => $request->short_code,
                'remarks' => $request->remarks,
                'status' => $request->status
            ]);

            return redirect('accounts/location_master');
        } catch (Exception $e) {
            dd($e);
        }
    }

    public function edit(LocationMaster $location_master)
    {
        return view('location_master.edit', compact('location_master'));
    }

    public function update(LocationMaster $location_master, Request $request)
    {
        try {

            LocationMaster::where('id', $location_master->id)->update([
                'name' => $request->name,
                'short_code' => $request->short_code,
                'remarks' => $request->remarks,
                'status' => $request->status
            ]);

            return redirect('accounts/location_master');
        } catch (Exception $e) {
            dd($e);
        }
    }

    public function delete(LocationMaster $location_master)
    {
        LocationMaster::where('id', $location_master->id)->update([
            'deleted_at' => now(),
            'deleted_by' => 1,
        ]);

        return redirect('accounts/location_master');
    }
}
