<?php

namespace App\Http\Controllers\Accounts;

use App\Http\Controllers\Controller;
use App\Models\AccountCategory;
use App\Models\AccountSubCategory;
use App\Models\ChartOfAccounts;
use App\Models\CostCenter;
use App\Models\DepartmentMaster;
use App\Models\Employees;
use App\Models\LocationMaster;
use App\Models\TransactionDetail;
use App\Models\BillsOrInvoice;
use App\Models\BillsOrInvoiceDetail;
use App\Models\ReceiptPayments;
use App\Models\TransactionMaster;
use App\Models\TransactionTypeMaster;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;

class ReceiptController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    
    public function index()
    {
        $data = ReceiptPayments::where('status', 1)->where('type', 'R')->paginate(10);

        return view('receipt.index', compact('data'));
    }

    public function add()
    {
        $transaction_type_master = TransactionTypeMaster::all();
        $chart_of_accounts = ChartOfAccounts::where('status', 1)->get();
        $cost_centers = CostCenter::where('status', 1)->get();

        return view('receipt.add', compact('transaction_type_master', 'chart_of_accounts', 'cost_centers'));
    }

    public function store(Request $request)
    {
        // dd($request->all());

        try {

            $transaction_type_master = TransactionTypeMaster::where('id', $request->transaction_type_master_id)->first();

            $last_voucher_number = TransactionMaster::where('transaction_type_master_id', $transaction_type_master->id)
                ->max('voucher_no');

            $sequence_number = ($last_voucher_number) ? intval(substr($last_voucher_number, -5)) + 1 : 1;
            $sequence_number_padded = str_pad($sequence_number, 5, '0', STR_PAD_LEFT);
            $year = date('y', strtotime($request->date));
            $new_voucher_number = $transaction_type_master->name . '-' . $sequence_number_padded . '/' . $year;

            $bills = ReceiptPayments::create([
                'type' => 'R',
                'voucher_no' => $new_voucher_number,
                'date' => $request->date,
                'bill_or_invoice_no' => $request->bill_or_invoice_no,
                'vendor_bill_date' => $request->vendor_bill_date,
                'gst_invoice_no' => $request->gst_invoice_no,
                'due_date' => $request->due_date,
                'account_id' => $request->master_account_id,
                'balance' => $request->balance,
                'cost_center_id' => $request->cost_center_id,
                'currency_id' => $request->currency_id,
                'exchange_rate' => $request->exchange_rate,
                'company_id' => 1,
                'status' => 1,
                'created_by' => auth()->user()->id
            ]);

            // foreach ($request->account_id as $key => $value) {
            //     BillsOrInvoiceDetail::create([
            //         'bills_invoice_id' => $bills->id,
            //         'account_id' => $value,
            //         'cost_center_id' => $request->cost_center_detail[$key],
            //         'type' => $request->dr_cr[$key],
            //         'amount_vc' => $request->amount_vc[$key],
            //         'amount_lc' => $request->amount_lc[$key],
            //         'narration' => $request->narration[$key],
            //         'tax_type' => $request->tax_type[$key],
            //         'status' => 1
            //     ]);
            // }

            dd($request->all());
            return redirect('accounts/bills');
        } catch (Exception $e) {
            dd($e);
        }
    }

    public function edit(ReceiptPayments $bills)
    {
        $transaction_type_master = TransactionTypeMaster::all();
        $chart_of_accounts = ChartOfAccounts::where('status', 1)->get();
        $cost_centers = CostCenter::where('status', 1)->get();

        // dd($bills->detail);

        return view('receipt.edit', compact('bills', 'transaction_type_master', 'chart_of_accounts', 'cost_centers'));
    }

    public function update(ReceiptPayments $bills, Request $request)
    {
        try {

            ReceiptPayments::where('id', $bills->id)->update([
                'date' => $request->date,
                'transaction_type_master_id' => $request->transaction_type_master_id,
                'settlement_account' => $request->settlement_account,
                'cost_center_id' => $request->cost_center_id,
                'bank_sub_type' => $request->bank_sub_type,
                'currency_id' => $request->currency_id,
                'exchange_rate' => $request->exchange_rate,
                'cheque_number' => $request->cheque_number,
                'cheque_date' => $request->cheque_date,
                'pay_to' => $request->pay_to,
                'bank_sub_type' => $request->bank_sub_type,
                'updated_by' => auth()->user()->id
            ]);

            // TransactionDetail::where('bills_id', $bills->id)->delete();

            // foreach ($request->account_id as $key => $value) {
            //     TransactionDetail::create([
            //         'bills_id' => $bills->id,
            //         'account_id' => $value,
            //         'cost_center_id' => $request->cost_center_detail[$key],
            //         // 'debit_vc' => $request->debit_vc[$key],
            //         // 'credit_vc' => $request->credit_vc[$key],
            //         'debit_lc' => $request->debit_lc[$key],
            //         'credit_lc' => $request->credit_lc[$key],
            //         'narration' => $request->narration[$key],
            //         'status' => 1
            //     ]);
            // }

            return redirect('accounts/receipt');
        } catch (Exception $e) {
            dd($e);
        }
    }

    public function delete(BillsOrInvoice $bills)
    {
        BillsOrInvoice::where('id', $bills->id)->update([
            'deleted_at' => now(),
            'deleted_by' => 1,
        ]);

        return redirect('accounts/receipt');
    }
}
