<?php

namespace App\Http\Controllers\Accounts;

use App\Http\Controllers\Controller;
use App\Models\AccountCategory;
use App\Models\AccountSubCategory;
use App\Models\ChartOfAccounts;
use App\Models\CostCenter;
use App\Models\DepartmentMaster;
use App\Models\Employees;
use App\Models\LocationMaster;
use App\Models\TransactionDetail;
use App\Models\TransactionMaster;
use App\Models\TransactionTypeMaster;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;

class VoucherController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    
    public function index()
    {
        $transaction_master = TransactionMaster::where('status', 1)->paginate(10);

        return view('voucher.index', compact('transaction_master'));
    }

    public function add()
    {
        $transaction_type_master = TransactionTypeMaster::all();
        $chart_of_accounts = ChartOfAccounts::where('status', 1)->get();
        $cost_centers = CostCenter::where('status', 1)->get();

        return view('voucher.add', compact('transaction_type_master', 'chart_of_accounts', 'cost_centers'));
    }

    public function store(Request $request)
    {
        // dd($request->all());

        try {

            $transaction_type_master = TransactionTypeMaster::where('id', $request->transaction_type_master_id)->first();

            $last_voucher_number = TransactionMaster::where('transaction_type_master_id', $transaction_type_master->id)
                ->max('voucher_no');

            $sequence_number = ($last_voucher_number) ? intval(substr($last_voucher_number, -5)) + 1 : 1;
            $sequence_number_padded = str_pad($sequence_number, 5, '0', STR_PAD_LEFT);
            $year = date('y', strtotime($request->date));
            $new_voucher_number = $transaction_type_master->name . '-' . $sequence_number_padded . '/' . $year;

            $transaction_master = TransactionMaster::create([
                'voucher_no' => $new_voucher_number,
                'date' => $request->date,
                'transaction_type_master_id' => $request->transaction_type_master_id,
                'settlement_account' => $request->settlement_account,
                'cost_center_id' => $request->cost_center_id,
                'bank_sub_type' => $request->bank_sub_type,
                'currency_id' => $request->currency_id,
                'exchange_rate' => $request->exchange_rate,
                'cheque_number' => $request->cheque_number,
                'cheque_date' => $request->cheque_date,
                'pay_to' => $request->pay_to,
                'bank_sub_type' => $request->bank_sub_type,
                'company_id' => 1,
                'status' => 1,
                'created_by' => auth()->user()->id
            ]);

            foreach ($request->account_id as $key => $value) {
                TransactionDetail::create([
                    'transaction_master_id' => $transaction_master->id,
                    'account_id' => $value,
                    'cost_center_id' => $request->cost_center_detail[$key],
                    // 'debit_vc' => $request->debit_vc[$key],
                    // 'credit_vc' => $request->credit_vc[$key],
                    'debit_lc' => $request->debit_lc[$key],
                    'credit_lc' => $request->credit_lc[$key],
                    'narration' => $request->narration[$key],
                    'status' => 1
                ]);
            }

            return redirect('accounts/voucher');
        } catch (Exception $e) {
            dd($e);
        }
    }

    public function edit(TransactionMaster $transaction_master)
    {
        $transaction_type_master = TransactionTypeMaster::all();
        $chart_of_accounts = ChartOfAccounts::where('status', 1)->get();
        $cost_centers = CostCenter::where('status', 1)->get();

        // dd($transaction_master->detail);

        return view('voucher.edit', compact('transaction_master', 'transaction_type_master', 'chart_of_accounts', 'cost_centers'));
    }

    public function update(TransactionMaster $transaction_master, Request $request)
    {
        try {

            TransactionMaster::where('id', $transaction_master->id)->update([
                'date' => $request->date,
                'transaction_type_master_id' => $request->transaction_type_master_id,
                'settlement_account' => $request->settlement_account,
                'cost_center_id' => $request->cost_center_id,
                'bank_sub_type' => $request->bank_sub_type,
                'currency_id' => $request->currency_id,
                'exchange_rate' => $request->exchange_rate,
                'cheque_number' => $request->cheque_number,
                'cheque_date' => $request->cheque_date,
                'pay_to' => $request->pay_to,
                'bank_sub_type' => $request->bank_sub_type,
                'updated_by' => auth()->user()->id
            ]);

            TransactionDetail::where('transaction_master_id', $transaction_master->id)->delete();

            foreach ($request->account_id as $key => $value) {
                TransactionDetail::create([
                    'transaction_master_id' => $transaction_master->id,
                    'account_id' => $value,
                    'cost_center_id' => $request->cost_center_detail[$key],
                    // 'debit_vc' => $request->debit_vc[$key],
                    // 'credit_vc' => $request->credit_vc[$key],
                    'debit_lc' => $request->debit_lc[$key],
                    'credit_lc' => $request->credit_lc[$key],
                    'narration' => $request->narration[$key],
                    'status' => 1
                ]);
            }

            return redirect('accounts/voucher');
        } catch (Exception $e) {
            dd($e);
        }
    }

    public function delete(TransactionMaster $transaction_master)
    {
        TransactionMaster::where('id', $transaction_master->id)->update([
            'deleted_at' => now(),
            'deleted_by' => 1,
        ]);

        return redirect('accounts/voucher');
    }
}
