<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;

use App\Models\Airport;
use App\Http\Requests\AirportRequest;
use App\Models\City;
use App\Models\Country;

class AirportsController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Contracts\View\View
     */
    public function index()
    {
        $airports = Airport::paginate(10);
        return view('airports.index', ['airports' => $airports]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Contracts\View\View
     */
    public function create()
    {
        $countries = Country::all();
        $cities = City::all();

        return view('airports.create', ['countries' => $countries, 'cities' => $cities]);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  AirportRequest  $request
     * @return \Illuminate\Http\RedirectResponse
     */
    public function store(AirportRequest $request)
    {
        $airport = new Airport;
        $airport->name = $request->input('name');
        $airport->city_id = $request->input('city_id');
        $airport->country_id = $request->input('country_id');
        $airport->status = $request->input('status');
        $airport->save();

        return to_route('airports.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Contracts\View\View
     */
    public function show($id)
    {
        $airport = Airport::findOrFail($id);
        return view('airports.show', ['airport' => $airport]);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Contracts\View\View
     */
    public function edit($id)
    {
        $airport = Airport::findOrFail($id);
        $countries = Country::all();
        $cities = City::all();

        return view('airports.edit', ['airport' => $airport, 'countries' => $countries, 'cities' => $cities]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  AirportRequest  $request
     * @param  int  $id
     * @return \Illuminate\Http\RedirectResponse
     */
    public function update(AirportRequest $request, $id)
    {
        $airport = Airport::findOrFail($id);
        $airport->name = $request->input('name');
        $airport->city_id = $request->input('city_id');
        $airport->country_id = $request->input('country_id');
        $airport->status = $request->input('status');
        $airport->save();

        return to_route('airports.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\RedirectResponse
     */
    public function destroy($id)
    {
        $airport = Airport::findOrFail($id);
        $airport->delete();

        return to_route('airports.index');
    }
}
