<?php

namespace App\Http\Controllers;

use App\Http\Requests\ChargeRequest;
use App\Http\Requests\CommodityRequest;
use App\Http\Requests\EmployeeRequest;
use App\Http\Requests\Un_locationRequest;
use App\Http\Requests\VesselRequest;
use App\Http\Requests\VoyageRequest;
use App\Models\Bills;
use App\Models\Charge;
use App\Models\ChartOfAccounts;
use App\Models\ChequeBookDetail;
use App\Models\City;
use App\Models\Commodity;
use App\Models\CurrencyMaster;
use App\Models\Employee;
use App\Models\Operations;
use App\Models\Party;
use App\Models\PartyDetailOperation;
use App\Models\PartyDetailType;
use App\Models\PaymentTypeMaster;
use App\Models\ReceiptPaymentsDetail;
use App\Models\Transactions;
use App\Models\TransactionTypeMaster;
use App\Models\Un_location;
use App\Models\Vessel;
use App\Models\TransactionMaster;
use App\Models\Voyage;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class ApiController extends Controller
{
    public function getParty(Request $request)
    {
        try {
            $party = Party::where('status', 1)->get();

            return response()->json(['data' => $party, 'status' => 200], 200);
        } catch (Exception $e) {

            return response()->json(['data' => $e, 'status' => 500], 500);
        }
    }

    public function party_store(Request $request, LogsController $logController)
    {
        try {

            $request->validate([
                'name' => 'required|unique:party',
            ]);
            $customer_coa = ChartOfAccounts::where('parent_account_id', 48)->max('account_code');
            $vendor_coa = ChartOfAccounts::where('parent_account_id', 76)->max('account_code');

            DB::beginTransaction();
            $party = Party::create([
                'name' => $request->name,
                'reg_date' => $request->reg_date,
                'contact_person' => $request->contact_person,
                'address' => $request->address,
                'city_id' => $request->city_id,
                'country_id' => $request->country_id,
                'zip_code' => $request->zip_code,
                'phone_no' => $request->phone_no,
                'mobile' => $request->mobile,
                'email' => $request->email,
                'website' => $request->website,
                'import_nomination' => $request->import_nomination,
                'export_nomination' => $request->export_nomination,
                'company_restriction' => $request->company_restriction,
                'cost_center_restriction' => $request->cost_center_restriction,
                'ntn_no' => $request->ntn_no,
                'strn_no' => $request->strn_no,
                'license_no' => $request->license_no,
                'party_is' => $request->party_is,
                'status' => 1,
            ]);

            foreach ($request->operation_id as $operation) {
                PartyDetailOperation::create([
                    'party_id' => $party->id,
                    'operation_id' => $operation,
                ]);
            }

            foreach ($request->type_id as $type) {
                PartyDetailType::create([
                    'party_id' => $party->id,
                    'type_id' => $type,
                ]);
            }

            if ($request->party_is == "customer_vendor") {
                ChartOfAccounts::create([
                    'party_id' => $party->id,
                    'name' => $request->coa_name,
                    'account_code' => $request->account_code,
                    'alias' => $request->alias,
                    'max_child_account' => $request->max_child_account,
                    'category_id' => $request->category_id,
                    'sub_category_id' => $request->sub_category_id,
                    // 'pl_category_id' => $request->name,
                    'reference_number' => $request->reference_number,
                    'parent_account_id' => $request->parent_account_id,
                    'status' => $request->status,
                    'level' => 4
                ]);
            } else if ($request->party_is == "customer") {
                ChartOfAccounts::create([
                    'party_id' => $party->id,
                    'name' => $request->name,
                    'account_code' => (int) $customer_coa + 1,
                    'alias' => $request->name,
                    'max_child_account' => '999',
                    'category_id' => 1,
                    'sub_category_id' => 3,
                    // 'pl_category_id' => $request->name,
                    'reference_number' => (int) $customer_coa + 1,
                    'parent_account_id' => 48,
                    'status' => 1
                ]);
            } else if ($request->party_is == "vendor") {
                ChartOfAccounts::create([
                    'party_id' => $party->id,
                    'name' => $request->name,
                    'account_code' => (int) $vendor_coa + 1,
                    'alias' => $request->name,
                    'max_child_account' => '999',
                    'category_id' => 5,
                    'sub_category_id' => 4,
                    // 'pl_category_id' => $request->name,
                    'reference_number' => (int) $vendor_coa + 1,
                    'parent_account_id' => 76,
                    'status' => 1
                ]);
            }
            DB::commit();
            $logController->createLog(__METHOD__, 'success', 'User Created.', auth()->user(), '');

            return response()->json(['data' => $party, 'status' => 200], 200);
        } catch (\Illuminate\Validation\ValidationException $e) {
            // Handle validation error
            return response()->json(['message' => 'The party name has already exist.', 'errors' => $e->validator->errors()], 422);
        } catch (Exception $e) {
            DB::rollBack();
            $logController->createLog(__METHOD__, 'error', $e, auth()->user(), '');

            return response()->json(['data' => $e, 'status' => 500], 500);
        }
    }

    public function getCommodity(Request $request)
    {
        try {
            $commodity = Commodity::where('status', 1)->get();

            return response()->json(['commodity' => $commodity, 'status' => 200], 200);
        } catch (Exception $e) {

            return response()->json(['commodity' => $e, 'status' => 500], 500);
        }
    }
    /**
     * Store a newly created resource in storage.
     *
     * @param  CommodityRequest  $request
     * @return \Illuminate\Http\RedirectResponse
     */
    public function commodity_store(CommodityRequest $request)
    {
        $commodity = new Commodity;
        $commodity->code = $request->input('code');
        $commodity->name = $request->input('name');
        $commodity->short_code = $request->input('short_code');
        $commodity->hs_code_id = $request->input('hs_code_id');
        $commodity->cargo_type = $request->input('cargo_type');
        $commodity->commodity_group_id = $request->input('commodity_group_id');
        $commodity->hazmat_product = $request->input('hazmat_product');
        $commodity->packing_group = $request->input('packing_group');
        $commodity->hazmat_class = $request->input('hazmat_class');
        $commodity->uno_code = $request->input('uno_code');
        $commodity->hazmat_code = $request->input('hazmat_code');
        $commodity->chemical_name = $request->input('chemical_name');
        $commodity->sro_string = $request->input('sro_string');
        $commodity->insurance = $request->input('insurance');
        $commodity->landing_ins = $request->input('landing_ins');
        $commodity->cd = $request->input('cd');
        $commodity->stax = $request->input('stax');
        $commodity->add_cd = $request->input('add_cd');
        $commodity->itax = $request->input('itax');
        $commodity->s_itax = $request->input('s_itax');
        $commodity->fed = $request->input('fed');
        $commodity->fine = $request->input('fine');
        $commodity->eto = $request->input('eto');
        $commodity->rd = $request->input('rd');
        $commodity->shipping_item = $request->input('shipping_item');
        $commodity->warehouse_item = $request->input('warehouse_item');
        $commodity->status = 1;
        $commodity->save();

        return response()->json(['data' => $commodity, 'status' => 200], 200);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  Un_locationRequest  $request
     * @return \Illuminate\Http\RedirectResponse
     */
    public function un_location_store(Un_locationRequest $request)
    {
        $un_location = new Un_location;
        $un_location->name = $request->input('location');
        $un_location->country = $request->input('country');
        $un_location->city = $request->input('city');
        $un_location->airport = $request->input('airport');
        $un_location->seaport = $request->input('seaport');
        $un_location->terminal = $request->input('terminal');
        $un_location->coordinates = $request->input('coordinates');
        $un_location->latitude = $request->input('latitude');
        $un_location->state = $request->input('state');
        $un_location->longitude = $request->input('longitude');
        $un_location->phone_prefix = $request->input('phone_prefix');
        $un_location->epass_code = $request->input('epass_code');
        $un_location->category_region = $request->input('category_region');
        $un_location->status = 1;
        $un_location->save();

        return response()->json(['data' => $un_location, 'status' => 200], 200);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  EmployeeRequest  $request
     * @return \Illuminate\Http\RedirectResponse
     */
    public function employee_store(EmployeeRequest $request)
    {
        $employee = new Employee;
        $employee->code = $request->input('code');
        $employee->employee_name = $request->input('employee_name');
        $employee->father_name = $request->input('father_name');
        $employee->cnic = $request->input('cnic');
        $employee->gender = $request->input('gender');
        $employee->phone_no = $request->input('phone_no');
        $employee->mobile = $request->input('mobile');
        $employee->dob = $request->input('dob');
        $employee->address = $request->input('address');
        $employee->nationality = $request->input('nationality');
        $employee->date = $request->input('date');
        $employee->employment_status = $request->input('employment_status');
        $employee->department = $request->input('department');
        $employee->location = $request->input('location');
        $employee->designation = $request->input('designation');
        $employee->status = 1;
        $employee->save();

        return response()->json(['data' => $employee, 'status' => 200], 200);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  VesselRequest  $request
     * @return \Illuminate\Http\RedirectResponse
     */
    public function vessel_store(VesselRequest $request)
    {
        $vessel = new Vessel;
        $vessel->name = $request->input('name');
        $vessel->owner = $request->input('owner');
        $vessel->principle_code = $request->input('principle_code');
        $vessel->call_sign = $request->input('call_sign');
        $vessel->grt = $request->input('grt');
        $vessel->nrt = $request->input('nrt');
        $vessel->imo_no = $request->input('imo_no');
        $vessel->country_id = $request->input('country_id');
        $vessel->status = 1;
        $vessel->save();

        return response()->json(['data' => $vessel, 'status' => 200], 200);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  VoyageRequest  $request
     * @return \Illuminate\Http\RedirectResponse
     */
    public function voyage_store(VoyageRequest $request)
    {
        $voyage = new Voyage;
        $voyage->vessel_id = $request->input('vessel_id');
        $voyage->voyage_no = $request->input('voyage_no');
        $voyage->point_of_discharge_id = $request->input('point_of_discharge_id');
        $voyage->point_of_loading_id = $request->input('point_of_loading_id');
        $voyage->import_sail_date_time = $request->input('import_sail_date_time');
        $voyage->import_arrival_date = $request->input('import_arrival_date');
        $voyage->export_sailing_date = $request->input('export_sailing_date');
        $voyage->export_dest_eta = $request->input('export_dest_eta');
        $voyage->export_cut_of_date = $request->input('export_cut_of_date');
        $voyage->export_cut_of_time = $request->input('export_cut_of_time');
        $voyage->type = $request->input('type');
        $voyage->status = 1;
        $voyage->save();

        return response()->json(['data' => $voyage, 'status' => 200], 200);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  ChargeRequest  $request
     * @return \Illuminate\Http\RedirectResponse
     */

    public function charge_store(ChargeRequest $request)
    {
        $charge = new Charge;
        $charge->code = $request->input('code');
        $charge->currency_id = $request->input('currency_id');
        $charge->name = $request->input('name');
        $charge->short_name = $request->input('short_name');
        $charge->charges_type = $request->input('charges_type');
        $charge->order = $request->input('order');
        $charge->type = $request->input('type');
        $charge->reporting_group = $request->input('reporting_group');
        $charge->tag = $request->input('tag');
        $charge->printing_name = $request->input('printing_name');
        $charge->calculation_type = $request->input('calculation_type');
        $charge->tax_recievable = $request->input('tax_recievable');
        $charge->tax_payable = $request->input('tax_payable');
        $charge->tax_on_principal = $request->input('tax_on_principal');
        $charge->c_category = $request->input('c_category');
        $charge->default_payable = $request->input('default_payable');
        $charge->default_recievable = $request->input('default_recievable');
        $charge->sys_gen = $request->input('sys_gen');
        $charge->sea_import = $request->input('sea_import');
        $charge->sea_export = $request->input('sea_export');
        $charge->air_import = $request->input('air_import');
        $charge->air_export = $request->input('air_export');
        $charge->logistic = $request->input('logistic');
        $charge->warehouse = $request->input('warehouse');
        $charge->other = $request->input('other');
        $charge->operation_type = $request->input('operation_type');
        $charge->carrier_id = $request->input('carrier_id');
        $charge->billing_type = $request->input('billing_type');
        $charge->customer_id = $request->input('customer_id');
        $charge->save();

        return response()->json(['data' => $charge, 'status' => 200], 200);
    }

    public function getVoucherTypes(PaymentTypeMaster $payment_type)
    {
        $voucher_types = TransactionTypeMaster::where('payment_type_master', $payment_type->id)->get();

        return response()->json(['data' => $voucher_types, 'status' => 200], 200);
    }

    public function getCheques(Request $request)
    {
        $cheque_book_details = ChequeBookDetail::whereHas('cheque_book_master', function ($query) use ($request) {
            $query->where('account_id', $request->account_id);
        })->where('status', 1)->get();
        return response()->json(['data' => $cheque_book_details, 'status' => 200], 200);
    }

    public function getAccounts(Request $request)
    {
        if ($request->voucher_type_id == 1) {
            // Bank Payment voucher
            $from_account = ChartOfAccounts::where('sub_category_id', 2)->whereIn('level', [3, 4])->where('allow_voucher_entry', 1)->where('status', 1)->get();
            $to_account = ChartOfAccounts::whereIn('level', [3, 4])->where('allow_voucher_entry', 1)->where('status', 1)->get();
        } else if ($request->voucher_type_id == 3) {
            // Cash Payment voucher
            $from_account = ChartOfAccounts::where('sub_category_id', 1)->whereIn('level', [3, 4])->where('allow_voucher_entry', 1)->where('status', 1)->get();
            $to_account = ChartOfAccounts::whereIn('level', [3, 4])->where('allow_voucher_entry', 1)->where('status', 1)->get();
        } else if ($request->voucher_type_id == 2) {
            // Bank Receipt voucher
            $from_account = ChartOfAccounts::where('sub_category_id', 2)->whereIn('level', [3, 4])->where('allow_voucher_entry', 1)->where('status', 1)->get();
            $to_account = ChartOfAccounts::whereIn('level', [3, 4])->where('allow_voucher_entry', 1)->where('status', 1)->get();
        } else if ($request->voucher_type_id == 5) {
            // Cash Receipt voucher
            $from_account = ChartOfAccounts::where('sub_category_id', 1)->whereIn('level', [3, 4])->where('allow_voucher_entry', 1)->where('status', 1)->get();
            $to_account = ChartOfAccounts::whereIn('level', [3, 4])->where('allow_voucher_entry', 1)->where('status', 1)->get();
        } else if ($request->voucher_type_id == 6 || $request->voucher_type_id == 8 || $request->voucher_type_id == 4 || $request->voucher_type_id == 9 || $request->voucher_type_id == 10) {
            // JV, CN, DN
            $from_account = ChartOfAccounts::where('status', 1)->whereIn('level', [3, 4])->get();
            $to_account = ChartOfAccounts::where('status', 1)->whereIn('level', [3, 4])->get();
        } else if ($request->voucher_type_id == 7) {
            // Transfer Voucher
            $from_account = ChartOfAccounts::whereIn('sub_category_id', [1, 2])->whereIn('level', [3, 4])->where('allow_voucher_entry', 1)->where('status', 1)->get();
            $to_account = ChartOfAccounts::whereIn('sub_category_id', [1, 2])->whereIn('level', [3, 4])->where('allow_voucher_entry', 1)->where('status', 1)->get();
        }

        return response()->json(['data' => ['from_account' => $from_account, 'to_account' => $to_account], 'status' => 200], 200);
    }

    public function getAccountsforReceipt(Request $request)
    {
        if ($request->type == 'receipt') {
            $accounts = Party::where('party_is', 'customer')->orWhere('party_is', 'customer_vendor')->get();
        } else if ($request->type == 'payment') {
            $accounts = Party::where('party_is', 'vendor')->orWhere('party_is', 'customer_vendor')->get();
        }
        ;

        return response()->json(['data' => $accounts, 'status' => 200], 200);
    }
    public function getAccountsforReceiptAccountType(Request $request)
    {
        if ($request->type == 'Cash') {
            $accounts = ChartOfAccounts::where('sub_category_id', 1)->get();
        } else if ($request->type == 'Bank') {
            $accounts = ChartOfAccounts::where('sub_category_id', 2)->get();
        } else if ($request->type == 'Adjustment') {
            $accounts = ChartOfAccounts::whereNotIn('sub_category_id', [1, 2])->get();
        }
        return response()->json(['data' => $accounts, 'status' => 200], 200);
    }

    public function getInvoicesForClient(Request $request)
    {
        $operation_id = $request->operation_id;
        if ($operation_id == 'all') {
            $operation_id = Operations::pluck('id')->toArray();
        } else {
            $operation_id = [$operation_id];
        }
        // dd($operation_id);
        if ($request->type == "payment") {
            $invoices = Bills::with('job_master', 'job_master.bl_master', 'job_master.bl_master.bl_container_info')->where('status', 1)->where('vendor_id', $request->client_id)->whereIn('operation_id', $operation_id)->get();
            foreach ($invoices as $invoice) {
                $receipt_payments_details = ReceiptPaymentsDetail::where('invoice_id', $invoice->id)->where('invoice_no', $invoice->tran_no)->get();
                if ($receipt_payments_details) {
                    foreach ($receipt_payments_details as $receipt_payments_detail) {
                        $receipt_payments_detail->invoice_amount = $receipt_payments_detail->invoice_amount - $receipt_payments_detail->rcvd_amount;
                    }
                }
            }
        } else if ($request->type == "receipt") {
            $invoices = Transactions::with('job_master', 'job_master.bl_master', 'job_master.bl_master.bl_container_info')->where('status', 1)->where('client_id', $request->client_id)->whereIn('operation_id', $operation_id)->get();
            foreach ($invoices as $invoice) {
                $grandTotal = (int) $invoice->grand_local_amount;

                $receipt_payments_details = ReceiptPaymentsDetail::where('invoice_id', $invoice->id)->where('invoice_no', $invoice->tran_no)->get();

                if ($receipt_payments_details) {
                    foreach ($receipt_payments_details as $receipt_payments_detail) {
                        $grandTotal -= (float) $receipt_payments_detail->rcvd_amount;
                    }
                }

                $invoice->grand_local_amount = (string) $grandTotal;
                // dd($invoice->grand_total_amount);
            }
        }
        // dd($invoices);

        $total_amount = $invoices->sum('grand_local_amount');

        return response()->json(['invoices' => $invoices, 'total_amount' => $total_amount, 'status' => 200], 200);
    }

    public function getTransactionMaster($id)
    {
        $transaction_master = TransactionMaster::with('chart_of_account', 'chart_of_accounts')->find($id);
        if ($transaction_master) {
            return response()->json($transaction_master);
        }

        return response()->json(['message' => 'Transaction not found'], 404);
    }

    public function getPartyDetails($id)
    {
        $party = Party::find($id);
        if ($party) {
            return response()->json([
                'name' => $party->name,
                'address' => $party->address,
            ]);
        } else {
            return response()->json(['error' => 'Party not found'], 404);
        }
    }
    public function getVoyageDetails($id)
    {
        $voyage = Voyage::where('vessel_id', $id)->get();
        if ($voyage) {
            return response()->json($voyage, 200);
        } else {
            return response()->json(['error' => 'Voyage not found'], 404);
        }
    }
    public function getVoyagesDetails($id)
    {
        $voyage = Voyage::where('id', $id)->get();
        if ($voyage) {
            return response()->json($voyage, 200);
        } else {
            return response()->json(['error' => 'Voyage not found'], 404);
        }
    }
    public function getConsigneeDetails($id)
    {
        $consignee = Party::where('id', $id)->first();
        if ($consignee) {
            return response()->json([
                'name' => $consignee->name,
                'address' => $consignee->address,
            ]);
        } else {
            return response()->json(['error' => 'Consignee not found'], 404);
        }
    }

    public function getConversionRate($id)
    {
        $conversionRate = CurrencyMaster::where('id', $id)->value('conversion_rate');

        return response()->json(['conversion_rate' => $conversionRate]);
    }

    public function getCityByCountryId($id)
    {
        $city = City::where('country_id', $id)->get();
        if ($city) {
            return response()->json([
                'data' => $city
            ], 200);
        } else {
            return response()->json(['error' => 'City not found'], 404);
        }
    }

    public function cloneCheque(Request $request)
    {
        $request->validate([
            'cheque_number' => 'required',
            'voucher_no' => 'nullable',
            'amount' => 'nullable|numeric',
        ]);

        $newCheque = ChequeBookDetail::create([
            'cheque_number' => $request->cheque_number,
            'cheque_book_master_id' => $request->cheque_master_id,
            // 'voucher_no' => $request->voucher_no,
            // 'amount' => $request->amount,
            // Add more fields as needed
        ]);

        return response()->json(['success' => true]);
    }

    public function getAccountsByLevel($level)
    {
        $accounts = ChartOfAccounts::where('level', $level)->get();

        return response()->json(['data' => $accounts, 'status' => 200], 200);
    }

    public function generateAccountCode(Request $request)
    {
        $ref_id = $request->ref_id;
        // dd($ref_id);
        if ($ref_id) {
            $maxAccountCode = ChartOfAccounts::where('id', $ref_id)->first();

            // dd($maxAccountCode);

            // if ($maxAccountCode->level == 4) {
            $max_child_account_code = ChartOfAccounts::where('id', $maxAccountCode->id)->max('account_code');
            // dd($max_child_account_code);
            $max_child_account_code2 = ChartOfAccounts::where('parent_account_id', $maxAccountCode->id)->max('account_code');

            if ($max_child_account_code2) {
                $newAccountCode = $max_child_account_code2 ? (int) $max_child_account_code2 + 1 : 1;
            } else {
                $newAccountCode = $max_child_account_code ? (int) $max_child_account_code . '0001' : 1;
            }

            // } else {
            //     $max_child_account_code = ChartOfAccounts::where('ref_id', $maxAccountCode->id)->max('account_code');
            //     $newAccountCode = $max_child_account_code ? (int) $max_child_account_code + 1 : 1;
            // }
        }
        // else {
        //     // $maxAccountCode = ChartOfAccounts::whereNull('ref_id')->first();
        //     $max_child_account_code = ChartOfAccounts::whereNull('ref_id')->max('account_code');
        //     $newAccountCode = $max_child_account_code ? (int) $max_child_account_code + 1 : 1;
        // }

        // dd($max_child_account_code);
        // dd($maxAccountCode);
        // if ($maxAccountCode->level == 1 || $maxAccountCode->level == 2 || $maxAccountCode->level == 3) {
        // } else {
        // }
        // $newAccountCode = $maxAccountCode ? $maxAccountCode->account_code . '001' : '01';
        // $maxAccountCode = ChartOfAccounts::where('id', $ref_id)->max('account_code');
        // dd($maxAccountCode);
        // if($maxAccountCode->level)
        // $newAccountCode = $maxAccountCode ? $maxAccountCode->account_code . '001' : '01';
        // $newAccountCode = $maxAccountCode ? $maxAccountCode + 1 : 1;

        return response()->json(['code' => $newAccountCode]);
    }

    public function getChartOfAccounts()
    {
        $accounts = ChartOfAccounts::all();

        $treeData = $accounts->map(function ($account) {
            return [
                'id' => $account->id,
                'parent' => $account->parent_account_id ? (string) $account->parent_account_id : '#', // Root elements have '#'
                'text' => $account->name . ' - ' . $account->account_code,
                'account_code' => $account->account_code,
                'alias' => $account->alias,
                'category' => $account->category_id,
                'sub_category' => $account->sub_category_id,
                'reference_no' => $account->reference_number,
                'allow_voucher_entry' => $account->allow_voucher_entry,
                'status' => $account->status,
            ];
        });

        return response()->json($treeData);
    }
    public function getChartOfAccountsExcel()
    {
        $accounts = ChartOfAccounts::all();

        $treeData = $accounts->map(function ($account) {
            return [
                'id' => $account->id,
                'name' => $account->name,
                'account_code' => $account->account_code,
                'category' => $account->account_category?->name,
                'sub_category' => $account->account_sub_category?->name,
            ];
        });

        return response()->json($treeData);
    }

    public function cancelCheque(Request $request)
    {
        $cheque = ChequeBookDetail::findOrFail($request->cheque_id);

        // Check if cheque is used in voucher_master
        $isUsed = TransactionMaster::where('cheque_number', $cheque->cheque_number)->exists();

        if ($isUsed) {
            return response()->json([
                'message' => 'This cheque has already been used in a voucher and cannot be cancelled.'
            ], 403); // Forbidden
        }

        $cheque->status = 0; // Ensure you have a status column
        $cheque->save();

        return response()->json(['message' => 'Cheque cancelled successfully.']);
    }

    public function deleteCheque(Request $request)
    {
        $cheque = ChequeBookDetail::findOrFail($request->cheque_id);

        // Check if cheque is used in voucher_master
        $isUsed = TransactionMaster::where('cheque_number', $cheque->cheque_number)->exists();

        if ($isUsed) {
            return response()->json([
                'message' => 'This cheque has already been used in a voucher and cannot be deleted.'
            ], 403);
        }

        $cheque->delete();

        return response()->json(['message' => 'Cheque deleted successfully.']);
    }
}
