<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;

use App\Models\BankDetailRegister;
use App\Http\Requests\BankDetailRegisterRequest;

class BankDetailRegistersController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Contracts\View\View
     */
    public function index()
    {
        $bankdetailregisters = BankDetailRegister::paginate(10);
        return view('bankdetailregisters.index', ['bankdetailregisters' => $bankdetailregisters]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Contracts\View\View
     */
    public function create()
    {
        return view('bankdetailregisters.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  BankDetailRegisterRequest  $request
     * @return \Illuminate\Http\RedirectResponse
     */
    public function store(BankDetailRegisterRequest $request)
    {
        $bankdetailregister = new BankDetailRegister;
        $bankdetailregister->code = $request->input('code');
        $bankdetailregister->name = $request->input('name');
        $bankdetailregister->status = $request->input('status');
        $bankdetailregister->save();

        return to_route('bankdetailregisters.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Contracts\View\View
     */
    public function show($id)
    {
        $bankdetailregister = BankDetailRegister::findOrFail($id);
        return view('bankdetailregisters.show', ['bankdetailregister' => $bankdetailregister]);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Contracts\View\View
     */
    public function edit($id)
    {
        $bankdetailregister = BankDetailRegister::findOrFail($id);
        return view('bankdetailregisters.edit', ['bankdetailregister' => $bankdetailregister]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  BankDetailRegisterRequest  $request
     * @param  int  $id
     * @return \Illuminate\Http\RedirectResponse
     */
    public function update(BankDetailRegisterRequest $request, $id)
    {
        $bankdetailregister = BankDetailRegister::findOrFail($id);
        $bankdetailregister->code = $request->input('code');
        $bankdetailregister->name = $request->input('name');
        $bankdetailregister->status = $request->input('status');
        $bankdetailregister->save();

        return to_route('bankdetailregisters.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\RedirectResponse
     */
    public function destroy($id)
    {
        $bankdetailregister = BankDetailRegister::findOrFail($id);
        $bankdetailregister->delete();

        return to_route('bankdetailregisters.index');
    }
}
