<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;

use App\Models\ChargesCategory;
use App\Http\Requests\ChargesCategoryRequest;

class ChargesCategoriesController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Contracts\View\View
     */
    public function index()
    {
        $chargescategories = ChargesCategory::paginate(10);
        return view('chargescategories.index', ['chargescategories' => $chargescategories]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Contracts\View\View
     */
    public function create()
    {
        return view('chargescategories.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  ChargesCategoryRequest  $request
     * @return \Illuminate\Http\RedirectResponse
     */
    public function store(ChargesCategoryRequest $request)
    {
        $chargescategory = new ChargesCategory;
        $chargescategory->name = $request->input('name');
        $chargescategory->status = $request->input('status');
        $chargescategory->save();

        return to_route('chargescategories.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Contracts\View\View
     */
    public function show($id)
    {
        $chargescategory = ChargesCategory::findOrFail($id);
        return view('chargescategories.show', ['chargescategory' => $chargescategory]);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Contracts\View\View
     */
    public function edit($id)
    {
        $chargescategory = ChargesCategory::findOrFail($id);
        return view('chargescategories.edit', ['chargescategory' => $chargescategory]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  ChargesCategoryRequest  $request
     * @param  int  $id
     * @return \Illuminate\Http\RedirectResponse
     */
    public function update(ChargesCategoryRequest $request, $id)
    {
        $chargescategory = ChargesCategory::findOrFail($id);
        $chargescategory->name = $request->input('name');
        $chargescategory->status = $request->input('status');
        $chargescategory->save();

        return to_route('chargescategories.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\RedirectResponse
     */
    public function destroy($id)
    {
        $chargescategory = ChargesCategory::findOrFail($id);
        $chargescategory->delete();

        return to_route('chargescategories.index');
    }
}
