<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Charge;
use App\Http\Requests\ChargeRequest;

class ChargesController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Contracts\View\View
     */
    public function index(Request $request)
    {
        $query = Charge::query();

        // Filters
        if ($request->filled('currency_id')) {
            $query->where('currency_id', $request->currency_id);
        }
        if ($request->filled('code')) {
            $query->where('code', 'like', '%' . $request->code . '%');
        }
        if ($request->filled('name')) {
            $query->where('name', 'like', '%' . $request->name . '%');
        }
        if ($request->filled('charges_type')) {
            $query->where('charges_type', $request->charges_type);
        }

        // Operations filters (checkboxes)
        $operations = [
            'sea_import', 'sea_export', 'air_import', 'air_export', 'logistic', 'warehouse', 'other'
        ];
        foreach ($operations as $op) {
            if ($request->filled($op)) {
                $query->where($op, 1);
            }
        }

        $charges = $query->paginate(10)->appends($request->query());
        $names = Charge::select('name')->distinct()->orderBy('name')->pluck('name');
        $codes = Charge::select('code')->distinct()->orderBy('code')->pluck('code');

        return view('charges.index', compact('charges', 'names', 'codes'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Contracts\View\View
     */
    public function create()
    {
        return view('charges.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  ChargeRequest  $request
     * @return \Illuminate\Http\RedirectResponse
     */
    public function store(ChargeRequest $request)
    {
        $charge = new Charge;
        $charge->code = $request->input('code');
        $charge->currency_id = $request->input('currency_id');
        $charge->name = $request->input('name');
        $charge->short_name = $request->input('short_name');
        $charge->charges_type = $request->input('charges_type');
        $charge->order = $request->input('order');
        $charge->type = $request->input('type');
        $charge->reporting_group = $request->input('reporting_group');
        $charge->tag = $request->input('tag');
        $charge->printing_name = $request->input('printing_name');
        $charge->calculation_type = $request->input('calculation_type');
        $charge->tax_recievable = $request->input('tax_recievable');
        $charge->tax_payable = $request->input('tax_payable');
        $charge->tax_on_principal = $request->input('tax_on_principal');
        $charge->c_category = $request->input('c_category');
        $charge->default_payable = $request->input('default_payable');
        $charge->default_recievable = $request->input('default_recievable');
        $charge->sys_gen = $request->input('sys_gen');
        $charge->sea_import = $request->input('sea_import');
        $charge->sea_export = $request->input('sea_export');
        $charge->air_import = $request->input('air_import');
        $charge->air_export = $request->input('air_export');
        $charge->logistic = $request->input('logistic');
        $charge->warehouse = $request->input('warehouse');
        $charge->other = $request->input('other');
        $charge->operation_type = $request->input('operation_type');
        $charge->carrier_id = $request->input('carrier_id');
        $charge->billing_type = $request->input('billing_type');
        $charge->customer_id = $request->input('customer_id');
        $charge->save();

        return to_route('charges.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Contracts\View\View
     */
    public function show($id)
    {
        $charge = Charge::findOrFail($id);
        return view('charges.show', ['charge' => $charge]);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Contracts\View\View
     */
    public function edit($id)
    {
        $charge = Charge::findOrFail($id);
        return view('charges.edit', ['charge' => $charge]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  ChargeRequest  $request
     * @param  int  $id
     * @return \Illuminate\Http\RedirectResponse
     */
    public function update(ChargeRequest $request, $id)
    {
        $charge = Charge::findOrFail($id);
        $charge->code = $request->input('code');
        $charge->currency_id = $request->input('currency_id');
        $charge->name = $request->input('name');
        $charge->short_name = $request->input('short_name');
        $charge->charges_type = $request->input('charges_type');
        $charge->order = $request->input('order');
        $charge->type = $request->input('type');
        $charge->reporting_group = $request->input('reporting_group');
        $charge->tag = $request->input('tag');
        $charge->printing_name = $request->input('printing_name');
        $charge->calculation_type = $request->input('calculation_type');
        $charge->tax_recievable = $request->input('tax_recievable');
        $charge->tax_payable = $request->input('tax_payable');
        $charge->tax_on_principal = $request->input('tax_on_principal');
        $charge->c_category = $request->input('c_category');
        $charge->default_payable = $request->input('default_payable');
        $charge->default_recievable = $request->input('default_recievable');
        $charge->sys_gen = $request->input('sys_gen');
        $charge->sea_import = $request->input('sea_import');
        $charge->sea_export = $request->input('sea_export');
        $charge->air_import = $request->input('air_import');
        $charge->air_export = $request->input('air_export');
        $charge->logistic = $request->input('logistic');
        $charge->warehouse = $request->input('warehouse');
        $charge->other = $request->input('other');
        $charge->operation_type = $request->input('operation_type');
        $charge->carrier_id = $request->input('carrier_id');
        $charge->billing_type = $request->input('billing_type');
        $charge->customer_id = $request->input('customer_id');
        $charge->save();

        return to_route('charges.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\RedirectResponse
     */
    public function destroy($id)
    {
        $charge = Charge::findOrFail($id);
        $charge->delete();

        return to_route('charges.index');
    }
}
