<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;

use App\Models\Commodity;
use App\Http\Requests\CommodityRequest;
use App\Models\Commodity_group;
use App\Models\HsCode;

class CommoditiesController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Contracts\View\View
     */
    public function index()
    {
        $commodities = Commodity::paginate(10);
        return view('commodities.index', ['commodities' => $commodities]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Contracts\View\View
     */
    public function create()
    {
        $hsCodes = HsCode::where('status', 1)->get();
        $commodity_groups = Commodity_group::where('status', 1)->get();

        return view('commodities.create', compact('hsCodes', 'commodity_groups'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  CommodityRequest  $request
     * @return \Illuminate\Http\RedirectResponse
     */
    public function store(CommodityRequest $request)
    {
        $commodity = new Commodity;
        $commodity->code = $request->input('code');
        $commodity->name = $request->input('name');
        $commodity->short_code = $request->input('short_code');
        $commodity->hs_code_id = $request->input('hs_code_id');
        $commodity->cargo_type = $request->input('cargo_type');
        $commodity->commodity_group_id = $request->input('commodity_group_id');
        $commodity->hazmat_product = $request->input('hazmat_product');
        $commodity->packing_group = $request->input('packing_group');
        $commodity->hazmat_class = $request->input('hazmat_class');
        $commodity->uno_code = $request->input('uno_code');
        $commodity->hazmat_code = $request->input('hazmat_code');
        $commodity->chemical_name = $request->input('chemical_name');
        $commodity->sro_string = $request->input('sro_string');
        $commodity->insurance = $request->input('insurance');
        $commodity->landing_ins = $request->input('landing_ins');
        $commodity->cd = $request->input('cd');
        $commodity->stax = $request->input('stax');
        $commodity->add_cd = $request->input('add_cd');
        $commodity->itax = $request->input('itax');
        $commodity->s_itax = $request->input('s_itax');
        $commodity->fed = $request->input('fed');
        $commodity->fine = $request->input('fine');
        $commodity->eto = $request->input('eto');
        $commodity->rd = $request->input('rd');
        $commodity->shipping_item = $request->input('shipping_item');
        $commodity->warehouse_item = $request->input('warehouse_item');
        $commodity->status = $request->input('status');
        $commodity->save();

        return to_route('commodities.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Contracts\View\View
     */
    public function show($id)
    {
        $commodity = Commodity::findOrFail($id);
        $hsCodes = HsCode::where('status', 1)->get();
        $commodity_groups = Commodity_group::where('status', 1)->get();

        return view('commodities.show', ['commodity' => $commodity, 'hsCodes' => $hsCodes, 'commodity_groups' => $commodity_groups]);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Contracts\View\View
     */
    public function edit($id)
    {
        $commodity = Commodity::findOrFail($id);
        $hsCodes = HsCode::where('status', 1)->get();
        $commodity_groups = Commodity_group::where('status', 1)->get();
        return view('commodities.edit', ['commodity' => $commodity, 'hsCodes' => $hsCodes, 'commodity_groups' => $commodity_groups]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  CommodityRequest  $request
     * @param  int  $id
     * @return \Illuminate\Http\RedirectResponse
     */
    public function update(CommodityRequest $request, $id)
    {
        $commodity = Commodity::findOrFail($id);
        $commodity->code = $request->input('code');
        $commodity->name = $request->input('name');
        $commodity->short_code = $request->input('short_code');
        $commodity->hs_code_id = $request->input('hs_code_id');
        $commodity->cargo_type = $request->input('cargo_type');
        $commodity->commodity_group_id = $request->input('commodity_group_id');
        $commodity->hazmat_product = $request->input('hazmat_product');
        $commodity->packing_group = $request->input('packing_group');
        $commodity->hazmat_class = $request->input('hazmat_class');
        $commodity->uno_code = $request->input('uno_code');
        $commodity->hazmat_code = $request->input('hazmat_code');
        $commodity->chemical_name = $request->input('chemical_name');
        $commodity->sro_string = $request->input('sro_string');
        $commodity->insurance = $request->input('insurance');
        $commodity->landing_ins = $request->input('landing_ins');
        $commodity->cd = $request->input('cd');
        $commodity->stax = $request->input('stax');
        $commodity->add_cd = $request->input('add_cd');
        $commodity->itax = $request->input('itax');
        $commodity->s_itax = $request->input('s_itax');
        $commodity->fed = $request->input('fed');
        $commodity->fine = $request->input('fine');
        $commodity->eto = $request->input('eto');
        $commodity->rd = $request->input('rd');
        $commodity->shipping_item = $request->input('shipping_item');
        $commodity->warehouse_item = $request->input('warehouse_item');
        $commodity->status = $request->input('status');
        $commodity->save();

        return to_route('commodities.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\RedirectResponse
     */
    public function destroy($id)
    {
        $commodity = Commodity::findOrFail($id);
        $commodity->delete();

        return to_route('commodities.index');
    }
}
