<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;

use App\Models\Commodity_group;
use App\Http\Requests\Commodity_groupRequest;

class Commodity_groupsController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Contracts\View\View
     */
    public function index()
    {
        $commodity_groups = Commodity_group::paginate(10);
        return view('commodity_groups.index', ['commodity_groups' => $commodity_groups]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Contracts\View\View
     */
    public function create()
    {
        return view('commodity_groups.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  Commodity_groupRequest  $request
     * @return \Illuminate\Http\RedirectResponse
     */
    public function store(Commodity_groupRequest $request)
    {
        $commodity_group = new Commodity_group;
        $commodity_group->name = $request->input('name');
        $commodity_group->status = $request->input('status');
        $commodity_group->save();

        return to_route('commodity_groups.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Contracts\View\View
     */
    public function show($id)
    {
        $commodity_group = Commodity_group::findOrFail($id);
        return view('commodity_groups.show', ['commodity_group' => $commodity_group]);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Contracts\View\View
     */
    public function edit($id)
    {
        $commodity_group = Commodity_group::findOrFail($id);
        return view('commodity_groups.edit', ['commodity_group' => $commodity_group]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  Commodity_groupRequest  $request
     * @param  int  $id
     * @return \Illuminate\Http\RedirectResponse
     */
    public function update(Commodity_groupRequest $request, $id)
    {
        $commodity_group = Commodity_group::findOrFail($id);
        $commodity_group->name = $request->input('name');
        $commodity_group->status = $request->input('status');
        $commodity_group->save();

        return to_route('commodity_groups.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\RedirectResponse
     */
    public function destroy($id)
    {
        $commodity_group = Commodity_group::findOrFail($id);
        $commodity_group->delete();

        return to_route('commodity_groups.index');
    }
}
