<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;

use App\Models\Commoditymapping;
use App\Http\Requests\CommoditymappingRequest;

class CommoditymappingsController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Contracts\View\View
     */
    public function index()
    {
        $commoditymappings= Commoditymapping::paginate(10);
        return view('commoditymappings.index', ['commoditymappings'=>$commoditymappings]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Contracts\View\View
     */
    public function create()
    {
        return view('commoditymappings.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  CommoditymappingRequest  $request
     * @return \Illuminate\Http\RedirectResponse
     */
    public function store(CommoditymappingRequest $request)
    {
        $commoditymapping = new Commoditymapping;
		$commoditymapping->integration_code = $request->input('integration_code');
		$commoditymapping->integration_name = $request->input('integration_name');
		$commoditymapping->csul_code = $request->input('csul_code');
		$commoditymapping->csul_name = $request->input('csul_name');
		$commoditymapping->status = $request->input('status');
        $commoditymapping->save();

        return to_route('commoditymappings.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Contracts\View\View
     */
    public function show($id)
    {
        $commoditymapping = Commoditymapping::findOrFail($id);
        return view('commoditymappings.show',['commoditymapping'=>$commoditymapping]);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Contracts\View\View
     */
    public function edit($id)
    {
        $commoditymapping = Commoditymapping::findOrFail($id);
        return view('commoditymappings.edit',['commoditymapping'=>$commoditymapping]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  CommoditymappingRequest  $request
     * @param  int  $id
     * @return \Illuminate\Http\RedirectResponse
     */
    public function update(CommoditymappingRequest $request, $id)
    {
        $commoditymapping = Commoditymapping::findOrFail($id);
		$commoditymapping->integration_code = $request->input('integration_code');
		$commoditymapping->integration_name = $request->input('integration_name');
		$commoditymapping->csul_code = $request->input('csul_code');
		$commoditymapping->csul_name = $request->input('csul_name');
		$commoditymapping->status = $request->input('status');
        $commoditymapping->save();

        return to_route('commoditymappings.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\RedirectResponse
     */
    public function destroy($id)
    {
        $commoditymapping = Commoditymapping::findOrFail($id);
        $commoditymapping->delete();

        return to_route('commoditymappings.index');
    }
}
