<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;

use App\Models\CostCenterGroup;
use App\Http\Requests\CostCenterGroupRequest;

class CostCenterGroupsController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Contracts\View\View
     */
    public function index()
    {
        $costcentergroups = CostCenterGroup::paginate(10);
        return view('costcentergroups.index', ['costcentergroups' => $costcentergroups]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Contracts\View\View
     */
    public function create()
    {
        return view('costcentergroups.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  CostCenterGroupRequest  $request
     * @return \Illuminate\Http\RedirectResponse
     */
    public function store(CostCenterGroupRequest $request)
    {
        $costcentergroup = new CostCenterGroup;
        $costcentergroup->name = $request->input('name');
        $costcentergroup->status = $request->input('status');
        $costcentergroup->save();

        return to_route('costcentergroups.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Contracts\View\View
     */
    public function show($id)
    {
        $costcentergroup = CostCenterGroup::findOrFail($id);
        return view('costcentergroups.show', ['costcentergroup' => $costcentergroup]);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Contracts\View\View
     */
    public function edit($id)
    {
        $costcentergroup = CostCenterGroup::findOrFail($id);
        return view('costcentergroups.edit', ['costcentergroup' => $costcentergroup]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  CostCenterGroupRequest  $request
     * @param  int  $id
     * @return \Illuminate\Http\RedirectResponse
     */
    public function update(CostCenterGroupRequest $request, $id)
    {
        $costcentergroup = CostCenterGroup::findOrFail($id);
        $costcentergroup->name = $request->input('name');
        $costcentergroup->status = $request->input('status');
        $costcentergroup->save();

        return to_route('costcentergroups.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\RedirectResponse
     */
    public function destroy($id)
    {
        $costcentergroup = CostCenterGroup::findOrFail($id);
        $costcentergroup->delete();

        return to_route('costcentergroups.index');
    }
}
