<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;

use App\Models\Airport;
use App\Http\Requests\AirportRequest;
use App\Models\BlMaster;
use App\Models\City;
use App\Models\Commodity;
use App\Models\Country;
use App\Models\CroDetail;
use App\Models\CroGatePass;
use App\Models\CroMaster;
use App\Models\CroVessel;
use App\Models\JobMaster;
use App\Models\Party;
use App\Models\PartyLocations;
use App\Models\Un_location;
use App\Models\Vessel;
use App\Models\Voyage;
use Exception;
use Illuminate\Http\Request;

class CroController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function index(Request $request)
    {
        // Get filter parameters from the request
        $filterBy = $request->filterBy;
        $filterValue = $request->filterValue;
        // dd($filterBy, $filterValue);

        if ($filterBy && $filterValue) {
            switch ($filterBy) {
                case 'id':
                    $cro_master = CroMaster::where('id', $filterValue)->get();
                    break;
                case 'job_master_id':
                    $cro_master = CroMaster::where('job_master_id', $filterValue)->get();
                    break;
                case 'client_id':
                    $cro_master = CroMaster::where('client_id', $filterValue)->get();
                    break;
                case 'reference_no':
                    $cro_master = CroMaster::where('id', $filterValue)->get();
                    break;
                case 'overseas_agent_id':
                    $cro_master = CroMaster::whereHas('cro_detail', function ($subQuery) use ($filterValue) {
                        $subQuery->where('overseas_agent_id', $filterValue);
                    })->get();
                    // $se_bls = BlDetails::where('description_of_goods_and_pkgs', $filterValue)->get();
                    break;
                case 'shipper_id':
                    $cro_master = CroMaster::whereHas('cro_detail', function ($subQuery) use ($filterValue) {
                        $subQuery->where('shipper_id', $filterValue);
                    })->get();
                    // $se_bls = BlDetails::where('description_of_goods_and_pkgs', $filterValue)->get();
                    break;
                default:
                    return redirect()->back()->with('error', 'Invalid filter key: ' . $filterBy);
            }
        } else {
            // $se_bls = BlMaster::where('operation_id', 1)->get();
            $cro_master = CroMaster::where('status', 1)->get();
        }

        return view('sea_export.cro.index', compact('cro_master'));
    }

    public function add(JobMaster $job_master, BlMaster $bl_master)
    {
        $clients = Party::where('party_is', 'customer')->orWhere('party_is', 'customer_vendor')->get();
        $overseas_agent = Party::whereHas('party_type', function ($subQuery) {
            $subQuery->whereIn('type_id', [7, 13]);
        })->get();
        $shippers = Party::whereHas('party_type', function ($subQuery) {
            $subQuery->where('type_id', 1);
        })->get();
        $un_locations = Un_location::where('status', 1)->get();
        $commodities = Commodity::where('status', 1)->get();
        $party_locations = PartyLocations::where('status', 1)->get();
        $vessels = Vessel::where('status', 1)->get();
        $voyages = Voyage::where('status', 1)->get();
        $shipping_line = Party::whereHas('party_type', function ($subQuery) {
            $subQuery->where('type_id', 12);
        })->get();
        $custom_clearance = Party::whereHas('party_type', function ($subQuery) {
            $subQuery->where('type_id', 11);
        })->get();
        $transportation = Party::whereHas('party_type', function ($subQuery) {
            $subQuery->where('type_id', 10);
        })->get();
        $cro = CroMaster::where('job_master_id', $job_master->id)->first();

        if ($cro != null) {
            return redirect()->to('cro/edit/' . $cro->id);
        } else {
            return view('sea_export.cro.add', compact('clients', 'job_master', 'bl_master', 'overseas_agent', 'shippers', 'un_locations', 'commodities', 'party_locations', 'vessels', 'transportation', 'voyages', 'custom_clearance', 'shipping_line'));
        }
    }

    public function store(JobMaster $job_master, Request $request, LogsController $logController)
    {
        try {
            // dd($request->all());

            $cro_master = CroMaster::create([
                'job_master_id' => $job_master->id,
                'cro_type' => $request->cro_type,
                'client_id' => $request->client_id,
                'issue_date' => $request->issue_date,
                'cro_valid_for' => $request->cro_valid_for,
                'equip_qty' => $request->equip_qty,
                'reference_no' => $request->reference_no,
                'size_type' => $request->size_type,
                'status' => 1,
            ]);

            $cro_details = CroDetail::create([
                'cro_master_id' => $cro_master->id,
                'overseas_agent_id' => $request->overseas_agent_id,
                'clearing_agent_id' => $request->clearing_agent_id,
                'shipper_id' => $request->shipper_id,
                'pickup_location' => $request->pickup_location,
                'port_of_loading_id' => $request->port_of_loading_id,
                'port_of_discharge_id' => $request->detail_port_of_discharge_id,
                'final_destination_id' => $request->final_destination_id,
                'commodity_id' => $request->commodity_id,
                'terminal_id' => $request->terminal_id,
                'empty_depot' => $request->empty_depot,
                'transporter_id' => $request->transported_id,
                'status' => 1,
            ]);

            $cro_gatepass = CroGatePass::create([
                'cro_master_id' => $cro_master->id,
                'book_no' => $request->book_no,
                'date' => $request->date,
                'licence_no' => $request->licence_no,
                'expiry_date' => $request->expiry_date,
                'shipping_agent' => $request->shipping_agent,
                'gate_pass_no' => $request->gate_pass_no,
                'letter_no' => $request->letter_no,
                'status' => 1,
            ]);

            $cro_vessel = CroVessel::create([
                'cro_master_id' => $cro_master->id,
                'cargo_type' => $request->cargo_type,
                'vessel_id' => $request->vessel_id,
                'voyage_id' => $request->voyage_id,
                'manual' => $request->manual,
                'manual_value' => $request->manual_value,
                'print_logo' => $request->print_logo,
                'continue_mode' => $request->continue_mode,
                'sailing_date' => $request->sailing_date,
                'haulage_instructions' => $request->haulage_instructions,
                'status' => 1,
            ]);

            $logController->createLog(__METHOD__, 'success', 'CRO Created.', auth()->user(), '');

            // return redirect()->to('/cro')->with('success', 'New Record Created SuccessFully!');
            return redirect()->to('/cro/edit/' . $cro_master->id)->with('success', 'Record Created SuccessFully!');
        } catch (Exception $e) {
            // dd($e);
            $logController->createLog(__METHOD__, 'error', $e, auth()->user(), '');

            return redirect()->back()->with('error', 'Something Went Wrong!');
        }
    }
    public function edit(CroMaster $cro_master, BlMaster $bl_master)
    {
        $clients = Party::where('party_is', 'customer')->orWhere('party_is', 'customer_vendor')->get();
        $overseas_agent = Party::whereHas('party_type', function ($subQuery) {
            $subQuery->whereIn('type_id', [7, 13]);
        })->get();
        $shippers = Party::whereHas('party_type', function ($subQuery) {
            $subQuery->where('type_id', 1);
        })->get();
        $un_locations = Un_location::where('status', 1)->get();
        $commodities = Commodity::where('status', 1)->get();
        $party_locations = PartyLocations::where('status', 1)->get();
        $vessels = Vessel::where('status', 1)->get();
        $voyages = Voyage::where('status', 1)->get();
        $shipping_line = Party::whereHas('party_type', function ($subQuery) {
            $subQuery->where('type_id', 12);
        })->get();
        $custom_clearance = Party::whereHas('party_type', function ($subQuery) {
            $subQuery->where('type_id', 11);
        })->get();
        $transportation = Party::whereHas('party_type', function ($subQuery) {
            $subQuery->where('type_id', 10);
        })->get();

        return view('sea_export.cro.edit', compact('cro_master', 'clients', 'bl_master', 'overseas_agent', 'shippers', 'un_locations', 'commodities', 'party_locations', 'vessels', 'transportation', 'voyages', 'custom_clearance', 'shipping_line'));
    }

    public function update(JobMaster $job_master, Request $request, LogsController $logController)
    {
        try {
            // dd($request->all());

            $cro_master = CroMaster::create([
                'job_master_id' => $job_master->id,
                'cro_type' => $request->cro_type,
                'client_id' => $request->client_id,
                'issue_date' => $request->issue_date,
                'cro_valid_for' => $request->cro_valid_for,
                'equip_qty' => $request->equip_qty,
                'reference_no' => $request->reference_no,
                'size_type' => $request->size_type,
                'status' => 1,
            ]);

            $cro_details = CroDetail::create([
                'cro_master_id' => $cro_master->id,
                'overseas_agent_id' => $request->overseas_agent_id,
                'clearing_agent_id' => $request->clearing_agent_id,
                'shipper_id' => $request->shipper_id,
                'pickup_location' => $request->pickup_location,
                'port_of_loading_id' => $request->port_of_loading_id,
                'port_of_discharge_id' => $request->detail_port_of_discharge_id,
                'final_destination_id' => $request->final_destination_id,
                'commodity_id' => $request->commodity_id,
                'terminal_id' => $request->terminal_id,
                'empty_depot' => $request->empty_depot,
                'transporter_id' => $request->transported_id,
                'status' => 1,
            ]);

            $cro_gatepass = CroGatePass::create([
                'cro_master_id' => $cro_master->id,
                'book_no' => $request->book_no,
                'date' => $request->date,
                'licence_no' => $request->licence_no,
                'expiry_date' => $request->expiry_date,
                'shipping_agent' => $request->shipping_agent,
                'gate_pass_no' => $request->gate_pass_no,
                'letter_no' => $request->letter_no,
                'status' => 1,
            ]);

            $cro_vessel = CroVessel::create([
                'cro_master_id' => $cro_master->id,
                'cargo_type' => $request->cargo_type,
                'vessel_id' => $request->vessel_id,
                'voyage_id' => $request->voyage_id,
                'manual' => $request->manual,
                'manual_value' => $request->manual_value,
                'print_logo' => $request->print_logo,
                'continue_mode' => $request->continue_mode,
                'sailing_date' => $request->sailing_date,
                'haulage_instructions' => $request->haulage_instructions,
                'status' => 1,
            ]);

            $logController->createLog(__METHOD__, 'success', 'CRO Created.', auth()->user(), '');

            // return redirect()->to('/cro')->with('success', 'New Record Created SuccessFully!');
            return redirect()->to('/cro/edit/' . $cro_master->id)->with('success', 'Record Updated SuccessFully!');

        } catch (Exception $e) {
            dd($e);
            $logController->createLog(__METHOD__, 'error', $e, auth()->user(), '');

            return redirect()->back()->with('error', 'Something Went Wrong!');
        }
    }
}
