<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;

use App\Models\CustomerGroup;
use App\Http\Requests\CustomerGroupRequest;

class CustomerGroupsController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Contracts\View\View
     */
    public function index()
    {
        $customergroups = CustomerGroup::paginate(10);
        return view('customergroups.index', ['customergroups' => $customergroups]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Contracts\View\View
     */
    public function create()
    {
        return view('customergroups.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  CustomerGroupRequest  $request
     * @return \Illuminate\Http\RedirectResponse
     */
    public function store(CustomerGroupRequest $request)
    {
        $customergroup = new CustomerGroup;
        $customergroup->name = $request->input('name');
        $customergroup->status = $request->input('status');
        $customergroup->save();

        return to_route('customergroups.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Contracts\View\View
     */
    public function show($id)
    {
        $customergroup = CustomerGroup::findOrFail($id);
        return view('customergroups.show', ['customergroup' => $customergroup]);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Contracts\View\View
     */
    public function edit($id)
    {
        $customergroup = CustomerGroup::findOrFail($id);
        return view('customergroups.edit', ['customergroup' => $customergroup]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  CustomerGroupRequest  $request
     * @param  int  $id
     * @return \Illuminate\Http\RedirectResponse
     */
    public function update(CustomerGroupRequest $request, $id)
    {
        $customergroup = CustomerGroup::findOrFail($id);
        $customergroup->name = $request->input('name');
        $customergroup->status = $request->input('status');
        $customergroup->save();

        return to_route('customergroups.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\RedirectResponse
     */
    public function destroy($id)
    {
        $customergroup = CustomerGroup::findOrFail($id);
        $customergroup->delete();

        return to_route('customergroups.index');
    }
}
