<?php

namespace App\Http\Controllers;

use App\Models\Appointment;
use App\Models\DayMaster;
use App\Models\Patients;
use App\Models\Payments;
use App\Models\Procedure;
use App\Models\TransactionPayments;
use App\Models\Transactions;
use App\Models\User;
use Carbon\Carbon;
use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use Illuminate\Foundation\Bus\DispatchesJobs;
use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Routing\Controller as BaseController;

use Exception;
use GuzzleHttp\Psr7\Request;
use Illuminate\Support\Facades\DB;

class DashboardController extends BaseController
{
    use AuthorizesRequests, DispatchesJobs, ValidatesRequests;

    public function __construct()
    {
        $this->middleware('auth');
    }

    public function index(LogsController $logController)
    {
        try {

            $logController->createLog(__METHOD__, 'success', 'Navigated to Dashborad.', auth()->user(), '');

            return view('dashboard');
        } catch (Exception $e) {

            dd($e);
            $logController->createLog(__METHOD__, 'error', $e, auth()->user(), '');

            return redirect()->back()->with('error', 'Something Went Wrong!');
        }
    }
}
