<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;

use App\Models\DrawnBank;
use App\Http\Requests\DrawnBankRequest;

class DrawnBanksController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Contracts\View\View
     */
    public function index()
    {
        $drawnbanks = DrawnBank::paginate(10);
        return view('drawnbanks.index', ['drawnbanks' => $drawnbanks]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Contracts\View\View
     */
    public function create()
    {
        return view('drawnbanks.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  DrawnBankRequest  $request
     * @return \Illuminate\Http\RedirectResponse
     */
    public function store(DrawnBankRequest $request)
    {
        $drawnbank = new DrawnBank;
        $drawnbank->name = $request->input('name');
        $drawnbank->status = $request->input('status');
        $drawnbank->save();

        return to_route('drawnbanks.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Contracts\View\View
     */
    public function show($id)
    {
        $drawnbank = DrawnBank::findOrFail($id);
        return view('drawnbanks.show', ['drawnbank' => $drawnbank]);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Contracts\View\View
     */
    public function edit($id)
    {
        $drawnbank = DrawnBank::findOrFail($id);
        return view('drawnbanks.edit', ['drawnbank' => $drawnbank]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  DrawnBankRequest  $request
     * @param  int  $id
     * @return \Illuminate\Http\RedirectResponse
     */
    public function update(DrawnBankRequest $request, $id)
    {
        $drawnbank = DrawnBank::findOrFail($id);
        $drawnbank->name = $request->input('name');
        $drawnbank->status = $request->input('status');
        $drawnbank->save();

        return to_route('drawnbanks.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\RedirectResponse
     */
    public function destroy($id)
    {
        $drawnbank = DrawnBank::findOrFail($id);
        $drawnbank->delete();

        return to_route('drawnbanks.index');
    }
}
