<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;

use App\Models\EmployeeMapping;
use App\Http\Requests\EmployeeMappingRequest;

class EmployeeMappingsController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Contracts\View\View
     */
    public function index()
    {
        $employeemappings= EmployeeMapping::paginate(10);
        return view('employeemappings.index', ['employeemappings'=>$employeemappings]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Contracts\View\View
     */
    public function create()
    {
        return view('employeemappings.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  EmployeeMappingRequest  $request
     * @return \Illuminate\Http\RedirectResponse
     */
    public function store(EmployeeMappingRequest $request)
    {
        $employeemapping = new EmployeeMapping;
		$employeemapping->integration_code = $request->input('integration_code');
		$employeemapping->integration_name = $request->input('integration_name');
		$employeemapping->csul_code = $request->input('csul_code');
		$employeemapping->csul_name = $request->input('csul_name');
		$employeemapping->status = $request->input('status');
        $employeemapping->save();

        return to_route('employeemappings.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Contracts\View\View
     */
    public function show($id)
    {
        $employeemapping = EmployeeMapping::findOrFail($id);
        return view('employeemappings.show',['employeemapping'=>$employeemapping]);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Contracts\View\View
     */
    public function edit($id)
    {
        $employeemapping = EmployeeMapping::findOrFail($id);
        return view('employeemappings.edit',['employeemapping'=>$employeemapping]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  EmployeeMappingRequest  $request
     * @param  int  $id
     * @return \Illuminate\Http\RedirectResponse
     */
    public function update(EmployeeMappingRequest $request, $id)
    {
        $employeemapping = EmployeeMapping::findOrFail($id);
		$employeemapping->integration_code = $request->input('integration_code');
		$employeemapping->integration_name = $request->input('integration_name');
		$employeemapping->csul_code = $request->input('csul_code');
		$employeemapping->csul_name = $request->input('csul_name');
		$employeemapping->status = $request->input('status');
        $employeemapping->save();

        return to_route('employeemappings.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\RedirectResponse
     */
    public function destroy($id)
    {
        $employeemapping = EmployeeMapping::findOrFail($id);
        $employeemapping->delete();

        return to_route('employeemappings.index');
    }
}
