<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;

use App\Models\Employee;
use App\Http\Requests\EmployeeRequest;

class EmployeesController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Contracts\View\View
     */
    public function index()
    {
        $employees = Employee::paginate(10);
        return view('employees.index', ['employees' => $employees]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Contracts\View\View
     */
    public function create()
    {
        return view('employees.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  EmployeeRequest  $request
     * @return \Illuminate\Http\RedirectResponse
     */
    public function store(EmployeeRequest $request)
    {
        $employee = new Employee;
        $employee->code = $request->input('code');
        $employee->name = $request->input('employee_name');
        $employee->father_name = $request->input('father_name');
        $employee->cnic = $request->input('cnic');
        $employee->gender = $request->input('gender');
        $employee->phone_no = $request->input('phone_no');
        $employee->mobile = $request->input('mobile');
        $employee->dob = $request->input('dob');
        $employee->address = $request->input('address');
        $employee->nationality = $request->input('nationality');
        $employee->date = $request->input('date');
        $employee->employment_status = $request->input('employment_status');
        $employee->department = $request->input('department');
        $employee->location = $request->input('location');
        $employee->designation = $request->input('designation');
        $employee->status = $request->input('status');
        $employee->save();

        return to_route('employees.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Contracts\View\View
     */
    public function show($id)
    {
        $employee = Employee::findOrFail($id);
        return view('employees.show', ['employee' => $employee]);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Contracts\View\View
     */
    public function edit($id)
    {
        $employee = Employee::findOrFail($id);
        return view('employees.edit', ['employee' => $employee]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  EmployeeRequest  $request
     * @param  int  $id
     * @return \Illuminate\Http\RedirectResponse
     */
    public function update(EmployeeRequest $request, $id)
    {
        $employee = Employee::findOrFail($id);
        $employee->code = $request->input('code');
        $employee->name = $request->input('employee_name');
        $employee->father_name = $request->input('father_name');
        $employee->cnic = $request->input('cnic');
        $employee->gender = $request->input('gender');
        $employee->phone_no = $request->input('phone_no');
        $employee->mobile = $request->input('mobile');
        $employee->dob = $request->input('dob');
        $employee->address = $request->input('address');
        $employee->nationality = $request->input('nationality');
        $employee->date = $request->input('date');
        $employee->employment_status = $request->input('employment_status');
        $employee->department = $request->input('department');
        $employee->location = $request->input('location');
        $employee->designation = $request->input('designation');
        $employee->status = $request->input('status');
        $employee->save();

        return to_route('employees.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\RedirectResponse
     */
    public function destroy($id)
    {
        $employee = Employee::findOrFail($id);
        $employee->delete();

        return to_route('employees.index');
    }
}
