<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;

use App\Models\Equipmentsizetype;
use App\Http\Requests\EquipmentsizetypeRequest;

class EquipmentsizetypesController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Contracts\View\View
     */
    public function index()
    {
        $equipmentsizetypes = Equipmentsizetype::paginate(10);
        return view('equipmentsizetypes.index', ['equipmentsizetypes' => $equipmentsizetypes]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Contracts\View\View
     */
    public function create()
    {
        return view('equipmentsizetypes.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  EquipmentsizetypeRequest  $request
     * @return \Illuminate\Http\RedirectResponse
     */
    public function store(EquipmentsizetypeRequest $request)
    {
        $equipmentsizetype = new Equipmentsizetype;
        $equipmentsizetype->code = $request->input('code');
        $equipmentsizetype->size = $request->input('size');
        $equipmentsizetype->type = $request->input('type');
        $equipmentsizetype->teu = $request->input('teu');
        $equipmentsizetype->old_iso_code = $request->input('old_iso_code');
        $equipmentsizetype->iso_code = $request->input('iso_code');
        $equipmentsizetype->weight = $request->input('weight');
        $equipmentsizetype->status = $request->input('status');
        $equipmentsizetype->save();

        return to_route('equipmentsizetypes.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Contracts\View\View
     */
    public function show($id)
    {
        $equipmentsizetype = Equipmentsizetype::findOrFail($id);
        return view('equipmentsizetypes.show', ['equipmentsizetype' => $equipmentsizetype]);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Contracts\View\View
     */
    public function edit($id)
    {
        $equipmentsizetype = Equipmentsizetype::findOrFail($id);
        return view('equipmentsizetypes.edit', ['equipmentsizetype' => $equipmentsizetype]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  EquipmentsizetypeRequest  $request
     * @param  int  $id
     * @return \Illuminate\Http\RedirectResponse
     */
    public function update(EquipmentsizetypeRequest $request, $id)
    {
        $equipmentsizetype = Equipmentsizetype::findOrFail($id);
        $equipmentsizetype->code = $request->input('code');
        $equipmentsizetype->size = $request->input('size');
        $equipmentsizetype->type = $request->input('type');
        $equipmentsizetype->teu = $request->input('teu');
        $equipmentsizetype->old_iso_code = $request->input('old_iso_code');
        $equipmentsizetype->iso_code = $request->input('iso_code');
        $equipmentsizetype->weight = $request->input('weight');
        $equipmentsizetype->status = $request->input('status');
        $equipmentsizetype->save();

        return to_route('equipmentsizetypes.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\RedirectResponse
     */
    public function destroy($id)
    {
        $equipmentsizetype = Equipmentsizetype::findOrFail($id);
        $equipmentsizetype->delete();

        return to_route('equipmentsizetypes.index');
    }
}
