<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;

use App\Models\HsCode;
use App\Http\Requests\HsCodeRequest;

class HsCodesController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Contracts\View\View
     */
    public function index()
    {
        $hscodes= HsCode::paginate(10);
        return view('hscodes.index', ['hscodes'=>$hscodes]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Contracts\View\View
     */
    public function create()
    {
        return view('hscodes.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  HsCodeRequest  $request
     * @return \Illuminate\Http\RedirectResponse
     */
    public function store(HsCodeRequest $request)
    {
        $hscode = new HsCode;
		$hscode->code = $request->input('code');
		$hscode->name = $request->input('name');
		$hscode->status = $request->input('status');
        $hscode->save();

        return to_route('hscodes.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Contracts\View\View
     */
    public function show($id)
    {
        $hscode = HsCode::findOrFail($id);
        return view('hscodes.show',['hscode'=>$hscode]);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Contracts\View\View
     */
    public function edit($id)
    {
        $hscode = HsCode::findOrFail($id);
        return view('hscodes.edit',['hscode'=>$hscode]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  HsCodeRequest  $request
     * @param  int  $id
     * @return \Illuminate\Http\RedirectResponse
     */
    public function update(HsCodeRequest $request, $id)
    {
        $hscode = HsCode::findOrFail($id);
		$hscode->code = $request->input('code');
		$hscode->name = $request->input('name');
		$hscode->status = $request->input('status');
        $hscode->save();

        return to_route('hscodes.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\RedirectResponse
     */
    public function destroy($id)
    {
        $hscode = HsCode::findOrFail($id);
        $hscode->delete();

        return to_route('hscodes.index');
    }
}
