<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;

use App\Models\Airport;
use App\Http\Requests\AirportRequest;
use App\Imports\PartiesImport;
use App\Models\City;
use App\Models\Country;
use Illuminate\Http\Request;
use Maatwebsite\Excel\Facades\Excel;

class ImportController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Contracts\View\View
     */
    public function parties()
    {
        return view('import.parties');
    }

    public function partiesImport(Request $request)
    {
        // dd($request->all());
        Excel::import(new PartiesImport, request()->file('file'));

        dd('test');
    }

}
