<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;

use App\Models\IncoTerm;
use App\Http\Requests\IncoTermRequest;

class IncoTermsController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Contracts\View\View
     */
    public function index()
    {
        $incoterms = IncoTerm::paginate(10);
        return view('incoterms.index', ['incoterms' => $incoterms]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Contracts\View\View
     */
    public function create()
    {
        return view('incoterms.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  IncoTermRequest  $request
     * @return \Illuminate\Http\RedirectResponse
     */
    public function store(IncoTermRequest $request)
    {
        $incoterm = new IncoTerm;
        $incoterm->code = $request->input('code');
        $incoterm->name = $request->input('name');
        $incoterm->status = $request->input('status');
        $incoterm->save();

        return to_route('incoterms.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Contracts\View\View
     */
    public function show($id)
    {
        $incoterm = IncoTerm::findOrFail($id);
        return view('incoterms.show', ['incoterm' => $incoterm]);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Contracts\View\View
     */
    public function edit($id)
    {
        $incoterm = IncoTerm::findOrFail($id);
        return view('incoterms.edit', ['incoterm' => $incoterm]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  IncoTermRequest  $request
     * @param  int  $id
     * @return \Illuminate\Http\RedirectResponse
     */
    public function update(IncoTermRequest $request, $id)
    {
        $incoterm = IncoTerm::findOrFail($id);
        $incoterm->code = $request->input('code');
        $incoterm->name = $request->input('name');
        $incoterm->status = $request->input('status');
        $incoterm->save();

        return to_route('incoterms.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\RedirectResponse
     */
    public function destroy($id)
    {
        $incoterm = IncoTerm::findOrFail($id);
        $incoterm->delete();

        return to_route('incoterms.index');
    }
}
