<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;

use App\Models\Commodity;
use App\Models\Employee;
use App\Models\JobMaster;
use App\Models\JobStatus;
use App\Models\Party;
use App\Models\ShipStatus;
use App\Models\Un_location;
use App\Models\Vessel;
use App\Models\Voyage;
use Illuminate\Http\Request;

class JobController extends Controller
{

    public function __construct()
    {
        $this->middleware('auth');
    }

    public function index(Request $request)
    {
        $perPage = $request->input('perPage', session('perPage', 100));
        session(['perPage' => $perPage]);

        // Get filter parameters from the request
        $filterBy = $request->filterBy;
        $filterValue = null;

        if ($request->job_type) {
            $filterValue = $request->job_type;
        } else if ($request->cost_center) {
            $filterValue = $request->cost_center;
        } else if ($request->client_id) {
            $filterValue = $request->client_id;
        } else if ($request->shipper_id) {
            $filterValue = $request->shipper_id;
        } else if ($request->consignee_id) {
            $filterValue = $request->consignee_id;
        } else if ($request->sales_rep_id) {
            $filterValue = $request->sales_rep_id;
        } else if ($request->shipping_line_id) {
            $filterValue = $request->shipping_line_id;
        } else if ($request->local_vendor_id) {
            $filterValue = $request->local_vendor_id;
        } else if ($request->overseas_agent_id) {
            $filterValue = $request->overseas_agent_id;
        } else if ($request->vessel_id) {
            $filterValue = $request->vessel_id;
        } else if ($request->voyage_id) {
            $filterValue = $request->voyage_id;
        } else if ($request->job_status_id) {
            $filterValue = $request->job_status_id;
        } else if ($request->ship_status_id) {
            $filterValue = $request->ship_status_id;
        } else if ($request->commodity_id) {
            $filterValue = $request->commodity_id;
        } else if ($request->port_of_loading_id) {
            $filterValue = $request->port_of_loading_id;
        } else if ($request->port_of_discharge_id) {
            $filterValue = $request->port_of_discharge_id;
        } else {
            $filterValue = $request->filterValue;
        }
        // $url = $request->getRequestUri();
        // $url = $request->path();

        // dd($url);

        // if ($url == "se_job") {
        //     $query = JobMaster::with(['job_detail', 'job_vessel', 'job_weight', 'job_equipments', 'job_charges_receivable', 'job_charges_payable', 'job_charges', 'job_routing', 'job_other_info', 'bl_master'])
        //         ->where('operation_id', 1);
        // } elseif ($url == "si_job") {
        //     $query = JobMaster::with(['job_detail', 'job_vessel', 'job_weight', 'job_equipments', 'job_charges_receivable', 'job_charges_payable', 'job_charges', 'job_routing', 'job_other_info', 'bl_master'])
        //         ->where('operation_id', 2);
        // } elseif ($url == "ae_job") {
        //     $query = JobMaster::with(['job_detail', 'job_vessel', 'job_weight', 'job_equipments', 'job_charges_receivable', 'job_charges_payable', 'job_charges', 'job_routing', 'job_other_info', 'bl_master'])
        //         ->where('operation_id', 3);
        // } elseif ($url == "ai_job") {
        //     $query = JobMaster::with(['job_detail', 'job_vessel', 'job_weight', 'job_equipments', 'job_charges_receivable', 'job_charges_payable', 'job_charges', 'job_routing', 'job_other_info', 'bl_master'])
        //         ->where('operation_id', 4);
        // }

        $query = JobMaster::with(['job_detail', 'job_vessel', 'job_weight', 'job_equipments', 'job_charges_receivable', 'job_charges_payable', 'job_charges', 'job_routing', 'job_other_info', 'bl_master']);

        if ($filterBy && $filterValue) {
            switch ($filterBy) {
                case 'id':
                    $query->where('id', $filterValue);
                    break;
                case 'job_type':
                    $query->where('job_type', $filterValue);
                    break;
                case 'cost_center':
                    $query->where('cost_center', $filterValue);
                    break;
                case 'customer_reference_no':
                    $query->where('customer_reference_no', $filterValue);
                    break;
                case 'client_id':
                    $query->whereHas('job_detail', function ($subQuery) use ($filterValue) {
                        $subQuery->where('client_id', $filterValue);
                    });
                    break;
                case 'shipper_id':
                    $query->whereHas('job_detail', function ($subQuery) use ($filterValue) {
                        $subQuery->where('shipper_id', $filterValue);
                    });
                    break;
                case 'consignee_id':
                    $query->whereHas('job_detail', function ($subQuery) use ($filterValue) {
                        $subQuery->where('consignee_id', $filterValue);
                    });
                    break;
                case 'sales_rep_id':
                    $query->whereHas('job_detail', function ($subQuery) use ($filterValue) {
                        $subQuery->where('sales_rep_id', $filterValue);
                    });
                    break;
                case 'shipping_line_id':
                    $query->whereHas('job_detail', function ($subQuery) use ($filterValue) {
                        $subQuery->where('shipping_line_id', $filterValue);
                    });
                    break;
                case 'local_vendor_id':
                    $query->whereHas('job_detail', function ($subQuery) use ($filterValue) {
                        $subQuery->where('local_vendor_id', $filterValue);
                    });
                    break;
                case 'overseas_agent_id':
                    $query->whereHas('job_detail', function ($subQuery) use ($filterValue) {
                        $subQuery->where('overseas_agent_id', $filterValue);
                    });
                    break;
                case 'vessel_id':
                    $query->whereHas('job_vessel', function ($subQuery) use ($filterValue) {
                        $subQuery->where('vessel_id', $filterValue);
                    });
                    break;
                case 'voyage_id':
                    $query->whereHas('job_vessel', function ($subQuery) use ($filterValue) {
                        $subQuery->where('voyage_id', $filterValue);
                    });
                    break;
                case 'c_bkg_ed':
                    $query->whereHas('job_vessel', function ($subQuery) use ($filterValue) {
                        $subQuery->where('c_bkg_ed', $filterValue);
                    });
                    break;
                case 'ship_status_id':
                    $query->where('ship_status_id', $filterValue);
                    break;
                case 'commodity_id':
                    $query->whereHas('job_detail', function ($subQuery) use ($filterValue) {
                        $subQuery->where('commodity_id', $filterValue);
                    });
                    break;
                case 'port_of_loading_id':
                    $query->whereHas('job_detail', function ($subQuery) use ($filterValue) {
                        $subQuery->where('port_of_loading_id', $filterValue);
                    });
                    break;
                case 'port_of_discharge_id':
                    $query->whereHas('job_detail', function ($subQuery) use ($filterValue) {
                        $subQuery->where('port_of_discharge_id', $filterValue);
                    });
                    break;
                case 'hbl_no':
                    $query->whereHas('bl_master', function ($subQuery) use ($filterValue) {
                        $subQuery->where('hbl_no', $filterValue);
                    });
                    break;
                case 'mbl_no':
                    $query->whereHas('bl_master', function ($subQuery) use ($filterValue) {
                        $subQuery->where('mbl_no', $filterValue);
                    });
                    break;
                case 'file_number':
                    $query->where('file_no', $filterValue);
                    break;
                case 'container_no':
                    $query->whereHas('bl_master.bl_container_info', function ($subQuery) use ($filterValue) {
                        // $subQuery->where('container_no', $filterValue);
                        $subQuery->where('container_no', 'LIKE', "%$filterValue%");
                    });
                    break;
                default:
                    return redirect()->back()->with('error', 'Invalid filter key: ' . $filterBy);
            }
        }

        if ($request->job_status_id) {
            $query->where('job_status_id', $request->job_status_id);
        }

        if ($request->filled('date_filter')) {
            $dateFilter = $request->input('date_filter');
            if ($dateFilter == 'today') {
                $query->whereDate('created_at', today());
            } elseif ($dateFilter == 'this_week') {
                $query->whereBetween('created_at', [now()->startOfWeek(), now()->endOfWeek()]);
            } elseif ($dateFilter == 'this_month') {
                $query->whereBetween('created_at', [now()->startOfMonth(), now()->endOfMonth()]);
            } elseif ($dateFilter == 'custom') {
                if ($request->filled('date_from') && $request->filled('date_to')) {
                    $query->whereBetween('created_at', [$request->input('date_from'), $request->input('date_to')]);
                }
            }
        }

        $se_jobs = $query->orderBy('id', 'Desc')->paginate($perPage);

        $clients = Party::where('party_is', 'customer')->orWhere('party_is', 'customer_vendor')->get();
        $shippers = Party::whereHas('party_type', function ($subQuery) {
            $subQuery->where('type_id', 1);
        })->get();
        $consignees = Party::whereHas('party_type', function ($subQuery) {
            $subQuery->where('type_id', 2);
        })->get();
        $shipping_line = Party::whereHas('party_type', function ($subQuery) {
            $subQuery->where('type_id', 12);
        })->get();
        $local_vendor = Party::whereHas('party_type', function ($subQuery) {
            $subQuery->where('type_id', 6);
        })->get();
        $overseas_agent = Party::whereHas('party_type', function ($subQuery) {
            $subQuery->whereIn('type_id', [7, 13]);
        })->get();
        $commodities = Commodity::where('status', 1)->get();
        $un_locations = Un_location::where('status', 1)->get();
        $sales_rep = Employee::where('status', 1)->get();
        $vessels = Vessel::where('status', 1)->get();
        $voyages = Voyage::where('status', 1)->get();
        $job_status = JobStatus::where('status', 1)->get();
        $ship_status = ShipStatus::where('status', 1)->get();
        $vendors = Party::where('party_is', 'vendor')->orWhere('party_is', 'customer_vendor')->get();

        return view('jobs.index', compact('se_jobs', 'perPage', 'vendors', 'clients', 'shippers', 'consignees', 'shipping_line', 'local_vendor', 'overseas_agent', 'commodities', 'un_locations', 'sales_rep', 'vessels', 'voyages', 'job_status', 'ship_status'));
    }

}
