<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;

use App\Models\LocalizationSetup;
use App\Http\Requests\LocalizationSetupRequest;

class LocalizationSetupsController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Contracts\View\View
     */
    public function index()
    {
        $localizationsetups = LocalizationSetup::paginate(10);
        return view('localizationsetups.index', ['localizationsetups' => $localizationsetups]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Contracts\View\View
     */
    public function create()
    {
        return view('localizationsetups.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  LocalizationSetupRequest  $request
     * @return \Illuminate\Http\RedirectResponse
     */
    public function store(LocalizationSetupRequest $request)
    {
        $localizationsetup = new LocalizationSetup;
        $localizationsetup->caption = $request->input('caption');
        $localizationsetup->name = $request->input('name');
        $localizationsetup->status = $request->input('status');
        $localizationsetup->save();

        return to_route('localizationsetups.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Contracts\View\View
     */
    public function show($id)
    {
        $localizationsetup = LocalizationSetup::findOrFail($id);
        return view('localizationsetups.show', ['localizationsetup' => $localizationsetup]);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Contracts\View\View
     */
    public function edit($id)
    {
        $localizationsetup = LocalizationSetup::findOrFail($id);
        return view('localizationsetups.edit', ['localizationsetup' => $localizationsetup]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  LocalizationSetupRequest  $request
     * @param  int  $id
     * @return \Illuminate\Http\RedirectResponse
     */
    public function update(LocalizationSetupRequest $request, $id)
    {
        $localizationsetup = LocalizationSetup::findOrFail($id);
        $localizationsetup->caption = $request->input('caption');
        $localizationsetup->name = $request->input('name');
        $localizationsetup->status = $request->input('status');
        $localizationsetup->save();

        return to_route('localizationsetups.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\RedirectResponse
     */
    public function destroy($id)
    {
        $localizationsetup = LocalizationSetup::findOrFail($id);
        $localizationsetup->delete();

        return to_route('localizationsetups.index');
    }
}
