<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;

use App\Models\Location_type;
use App\Http\Requests\Location_typeRequest;

class Location_typesController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Contracts\View\View
     */
    public function index()
    {
        $location_types= Location_type::all();
        return view('location_types.index', ['location_types'=>$location_types]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Contracts\View\View
     */
    public function create()
    {
        return view('location_types.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  Location_typeRequest  $request
     * @return \Illuminate\Http\RedirectResponse
     */
    public function store(Location_typeRequest $request)
    {
        $location_type = new Location_type;
		$location_type->name = $request->input('name');
		$location_type->status = $request->input('status');
        $location_type->save();

        return to_route('location_types.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Contracts\View\View
     */
    public function show($id)
    {
        $location_type = Location_type::findOrFail($id);
        return view('location_types.show',['location_type'=>$location_type]);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Contracts\View\View
     */
    public function edit($id)
    {
        $location_type = Location_type::findOrFail($id);
        return view('location_types.edit',['location_type'=>$location_type]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  Location_typeRequest  $request
     * @param  int  $id
     * @return \Illuminate\Http\RedirectResponse
     */
    public function update(Location_typeRequest $request, $id)
    {
        $location_type = Location_type::findOrFail($id);
		$location_type->name = $request->input('name');
		$location_type->status = $request->input('status');
        $location_type->save();

        return to_route('location_types.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\RedirectResponse
     */
    public function destroy($id)
    {
        $location_type = Location_type::findOrFail($id);
        $location_type->delete();

        return to_route('location_types.index');
    }
}
