<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;

use App\Models\NearByPort;
use App\Http\Requests\NearByPortRequest;

class NearByPortsController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Contracts\View\View
     */
    public function index()
    {
        $nearbyports= NearByPort::paginate(10);
        return view('nearbyports.index', ['nearbyports'=>$nearbyports]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Contracts\View\View
     */
    public function create()
    {
        return view('nearbyports.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  NearByPortRequest  $request
     * @return \Illuminate\Http\RedirectResponse
     */
    public function store(NearByPortRequest $request)
    {
        $nearbyport = new NearByPort;
		$nearbyport->port_code = $request->input('port_code');
		$nearbyport->port_name = $request->input('port_name');
		$nearbyport->nearby_port_code = $request->input('nearby_port_code');
		$nearbyport->nearby_port_name = $request->input('nearby_port_name');
		$nearbyport->status = $request->input('status');
        $nearbyport->save();

        return to_route('nearbyports.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Contracts\View\View
     */
    public function show($id)
    {
        $nearbyport = NearByPort::findOrFail($id);
        return view('nearbyports.show',['nearbyport'=>$nearbyport]);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Contracts\View\View
     */
    public function edit($id)
    {
        $nearbyport = NearByPort::findOrFail($id);
        return view('nearbyports.edit',['nearbyport'=>$nearbyport]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  NearByPortRequest  $request
     * @param  int  $id
     * @return \Illuminate\Http\RedirectResponse
     */
    public function update(NearByPortRequest $request, $id)
    {
        $nearbyport = NearByPort::findOrFail($id);
		$nearbyport->port_code = $request->input('port_code');
		$nearbyport->port_name = $request->input('port_name');
		$nearbyport->nearby_port_code = $request->input('nearby_port_code');
		$nearbyport->nearby_port_name = $request->input('nearby_port_name');
		$nearbyport->status = $request->input('status');
        $nearbyport->save();

        return to_route('nearbyports.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\RedirectResponse
     */
    public function destroy($id)
    {
        $nearbyport = NearByPort::findOrFail($id);
        $nearbyport->delete();

        return to_route('nearbyports.index');
    }
}
