<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;

use App\Models\OverseasAgentNetwork;
use App\Http\Requests\OverseasAgentNetworkRequest;

class OverseasAgentNetworksController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Contracts\View\View
     */
    public function index()
    {
        $overseasagentnetworks = OverseasAgentNetwork::paginate(10);
        return view('overseasagentnetworks.index', ['overseasagentnetworks' => $overseasagentnetworks]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Contracts\View\View
     */
    public function create()
    {
        return view('overseasagentnetworks.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  OverseasAgentNetworkRequest  $request
     * @return \Illuminate\Http\RedirectResponse
     */
    public function store(OverseasAgentNetworkRequest $request)
    {
        $overseasagentnetwork = new OverseasAgentNetwork;
        $overseasagentnetwork->name = $request->input('name');
        $overseasagentnetwork->status = $request->input('status');
        $overseasagentnetwork->save();

        return to_route('overseasagentnetworks.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Contracts\View\View
     */
    public function show($id)
    {
        $overseasagentnetwork = OverseasAgentNetwork::findOrFail($id);
        return view('overseasagentnetworks.show', ['overseasagentnetwork' => $overseasagentnetwork]);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Contracts\View\View
     */
    public function edit($id)
    {
        $overseasagentnetwork = OverseasAgentNetwork::findOrFail($id);
        return view('overseasagentnetworks.edit', ['overseasagentnetwork' => $overseasagentnetwork]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  OverseasAgentNetworkRequest  $request
     * @param  int  $id
     * @return \Illuminate\Http\RedirectResponse
     */
    public function update(OverseasAgentNetworkRequest $request, $id)
    {
        $overseasagentnetwork = OverseasAgentNetwork::findOrFail($id);
        $overseasagentnetwork->name = $request->input('name');
        $overseasagentnetwork->status = $request->input('status');
        $overseasagentnetwork->save();

        return to_route('overseasagentnetworks.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\RedirectResponse
     */
    public function destroy($id)
    {
        $overseasagentnetwork = OverseasAgentNetwork::findOrFail($id);
        $overseasagentnetwork->delete();

        return to_route('overseasagentnetworks.index');
    }
}
