<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;

use App\Models\Packages_coding;
use App\Http\Requests\Packages_codingRequest;

class Packages_codingsController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Contracts\View\View
     */
    public function index()
    {
        $packages_codings= Packages_coding::paginate(10);
        return view('packages_codings.index', ['packages_codings'=>$packages_codings]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Contracts\View\View
     */
    public function create()
    {
        return view('packages_codings.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  Packages_codingRequest  $request
     * @return \Illuminate\Http\RedirectResponse
     */
    public function store(Packages_codingRequest $request)
    {
        $packages_coding = new Packages_coding;
		$packages_coding->pack_code = $request->input('pack_code');
		$packages_coding->pack_name = $request->input('pack_name');
		$packages_coding->epas_code = $request->input('epas_code');
		$packages_coding->std_code_2digit = $request->input('std_code_2digit');
		$packages_coding->std_code_3digit = $request->input('std_code_3digit');
		$packages_coding->default = $request->input('default');
		$packages_coding->status = $request->input('status');
        $packages_coding->save();

        return to_route('packages_codings.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Contracts\View\View
     */
    public function show($id)
    {
        $packages_coding = Packages_coding::findOrFail($id);
        return view('packages_codings.show',['packages_coding'=>$packages_coding]);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Contracts\View\View
     */
    public function edit($id)
    {
        $packages_coding = Packages_coding::findOrFail($id);
        return view('packages_codings.edit',['packages_coding'=>$packages_coding]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  Packages_codingRequest  $request
     * @param  int  $id
     * @return \Illuminate\Http\RedirectResponse
     */
    public function update(Packages_codingRequest $request, $id)
    {
        $packages_coding = Packages_coding::findOrFail($id);
		$packages_coding->pack_code = $request->input('pack_code');
		$packages_coding->pack_name = $request->input('pack_name');
		$packages_coding->epas_code = $request->input('epas_code');
		$packages_coding->std_code_2digit = $request->input('std_code_2digit');
		$packages_coding->std_code_3digit = $request->input('std_code_3digit');
		$packages_coding->default = $request->input('default');
		$packages_coding->status = $request->input('status');
        $packages_coding->save();

        return to_route('packages_codings.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\RedirectResponse
     */
    public function destroy($id)
    {
        $packages_coding = Packages_coding::findOrFail($id);
        $packages_coding->delete();

        return to_route('packages_codings.index');
    }
}
