<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Http\Controllers\LogsController;
use App\Models\AccountCategory;
use App\Models\AccountSubCategory;
use App\Models\ChartOfAccounts;
use App\Models\City;
use App\Models\Country;
use App\Models\Party;
use App\Models\PartyDetailOperation;
use App\Models\PartyDetailType;
use App\Models\PartyOperations;
use App\Models\PartyType;
use App\Models\Role;
use App\Models\RoleUser;
use App\Models\User;
use Carbon\Carbon;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class PartyController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    // public function index(Request $request, LogsController $logController)
    // {
    //     try {

    //         // $name = $request->name;
    //         // $email = $request->email;
    //         // $partys = Party::when($name, function ($query) use ($name) {
    //         //     $query->where('name', 'like', '%' . $name . '%');
    //         // })->when($email, function ($query) use ($email) {
    //         //     $query->where('email', 'like', '%' . $email . '%');
    //         // })->paginate($perPage);

    //         $perPage = $request->input('perPage', session('perPage', 10));
    //         session(['perPage' => $perPage]);
    //         // $partys = Party::paginate($perPage);

    //         // Get filter parameters from the request
    //         $filterBy = $request->filterBy;
    //         $filterValue = null;
    //         // dd($filterBy, $filterValue);
    //         if ($request->party_is) {
    //             $filterValue = $request->party_is;
    //         } else if ($request->city_id) {
    //             $filterValue = $request->city_id;
    //         } else if ($request->country_id) {
    //             $filterValue = $request->country_id;
    //         } else {
    //             $filterValue = $request->filterValue;
    //         }

    //         if ($filterBy && $filterValue) {
    //             switch ($filterBy) {
    //                 case 'party_is':
    //                     $partys = Party::where('party_is', $filterValue)->paginate($perPage);
    //                     break;
    //                 case 'name':
    //                     $partys = Party::where('name', $filterValue)->paginate($perPage);
    //                     break;
    //                 case 'ntn_no':
    //                     $partys = Party::where('ntn_no', $filterValue)->paginate($perPage);
    //                     break;
    //                 case 'strn_no':
    //                     $partys = Party::where('strn_no', $filterValue)->paginate($perPage);
    //                     break;
    //                 case 'city_id':
    //                     $partys = Party::where('city_id', $filterValue)->paginate($perPage);
    //                     break;
    //                 case 'country_id':
    //                     $partys = Party::where('country_id', $filterValue)->paginate($perPage);
    //                     break;
    //                 case 'email':
    //                     $partys = Party::where('email', $filterValue)->paginate($perPage);
    //                     break;
    //                 case 'phone_no':
    //                     $partys = Party::where('phone_no', $filterValue)->paginate($perPage);
    //                     break;
    //                 default:
    //                     return redirect()->back()->with('error', 'Invalid filter key: ' . $filterBy);
    //             }
    //         } else {
    //             $partys = Party::paginate($perPage);
    //         }

    //         $cities = City::all();
    //         $countries = Country::all();

    //         $logController->createLog(__METHOD__, 'success', 'Accessing User Index Page.', auth()->user(), '');

    //         return view('party.index', compact('partys', 'perPage', 'cities', 'countries'));
    //     } catch (Exception $e) {
    //         dd($e);
    //         $logController->createLog(__METHOD__, 'error', $e, auth()->user(), '');

    //         return redirect()->back()->with('error', 'Something Went Wrong!');
    //     }
    // }

    public function index(Request $request)
    {
        $perPage = $request->input('perPage', session('perPage', 10));
        session(['perPage' => $perPage]);

        // Get filter parameters from the request
        $filterBy = $request->filterBy;
        $filterValue = null;

        if ($request->party_is) {
            $filterValue = $request->party_is;
        } else if ($request->city_id) {
            $filterValue = $request->city_id;
        } else if ($request->country_id) {
            $filterValue = $request->country_id;
        } else {
            $filterValue = $request->filterValue;
        }

        $query = Party::query();

        if ($filterBy && $filterValue) {
            switch ($filterBy) {
                case 'party_is':
                    $query->where('party_is', $filterValue);
                    break;
                case 'name':
                    $query->where('name', 'like', '%' . $filterValue . '%');
                    break;
                case 'ntn_no':
                    $query->where('ntn_no', $filterValue);
                    break;
                case 'strn_no':
                    $query->where('strn_no', $filterValue);
                    break;
                case 'city_id':
                    $query->where('city_id', $filterValue);
                    break;
                case 'country_id':
                    $query->where('country_id', $filterValue);
                    break;
                case 'email':
                    $query->where('email', $filterValue);
                    break;
                case 'phone_no':
                    $query->where('phone_no', $filterValue);
                    break;
                default:
                    return redirect()->back()->with('error', 'Invalid filter key: ' . $filterBy);
            }
        }

        if ($request->status) {
            $query->where('status', $request->status);
        }

        // Apply date filter
        if ($request->filled('date_filter')) {
            $dateFilter = $request->input('date_filter');
            if ($dateFilter == 'today') {
                $query->whereDate('created_at', today());
            } elseif ($dateFilter == 'this_week') {
                $query->whereBetween('created_at', [now()->startOfWeek(), now()->endOfWeek()]);
            } elseif ($dateFilter == 'this_month') {
                $query->whereBetween('created_at', [now()->startOfMonth(), now()->endOfMonth()]);
            } elseif ($dateFilter == 'custom') {
                if ($request->filled('date_from') && $request->filled('date_to')) {
                    $query->whereBetween('created_at', [$request->input('date_from'), $request->input('date_to')]);
                }
            }
        }

        $partys = $query->paginate($perPage);

        $cities = City::all();
        $countries = Country::all();

        return view('party.index', compact('partys', 'perPage', 'cities', 'countries'));
    }

    public function add(LogsController $logController)
    {
        try {
            $party_types = PartyType::where('status', 1)->get();
            $party_operations = PartyOperations::all();
            $cities = City::all();
            $countries = Country::all();
            $account_categories = AccountCategory::all();
            $account_sub_categories = AccountSubCategory::all();
            // $parent_accounts = ChartOfAccounts::all();
            $parent_accounts = ChartOfAccounts::whereIn('level', [2, 3])->get();
            $child_accounts = ChartOfAccounts::where('level', 4)->get();

            $logController->createLog(__METHOD__, 'success', 'Accessing User Add Page.', auth()->user(), '');

            return view('party.add', compact('account_categories', 'account_sub_categories', 'parent_accounts', 'child_accounts', 'party_types', 'party_operations', 'countries', 'cities'));
        } catch (Exception $e) {
            dd($e);
            $logController->createLog(__METHOD__, 'error', $e, auth()->user(), '');

            return redirect()->back()->with('error', 'Something Went Wrong!');
        }
    }

    public function store(Request $request, LogsController $logController)
    {
        try {
            $customer_coa = ChartOfAccounts::where('parent_account_id', 48)->max('account_code');
            $vendor_coa = ChartOfAccounts::where('parent_account_id', 76)->max('account_code');

            $request->validate([
                'name' => 'required|unique:party'
            ]);

            $party = Party::create([
                'name' => $request->name,
                'reg_date' => $request->reg_date,
                'contact_person' => $request->contact_person,
                'address' => $request->address,
                'city_id' => $request->city_id,
                'country_id' => $request->country_id,
                'zip_code' => $request->zip_code,
                'phone_no' => $request->phone_no,
                'mobile' => $request->mobile,
                'email' => $request->email,
                'website' => $request->website,
                'import_nomination' => $request->import_nomination,
                'export_nomination' => $request->export_nomination,
                'company_restriction' => $request->company_restriction,
                'cost_center_restriction' => $request->cost_center_restriction,
                'ntn_no' => $request->ntn_no,
                'strn_no' => $request->strn_no,
                'license_no' => $request->license_no,
                'party_is' => $request->party_is,
                'manual_account' => $request->manual_account,
                'existing_account' => $request->existing_account,
                'status' => 1,
            ]);

            if ($request->operation_id) {
                foreach ($request->operation_id as $operation) {
                    PartyDetailOperation::create([
                        'party_id' => $party->id,
                        'operation_id' => $operation,
                    ]);
                }
            }

            if ($request->type_id) {
                foreach ($request->type_id as $type) {
                    PartyDetailType::create([
                        'party_id' => $party->id,
                        'type_id' => $type,
                    ]);
                }
            }

            if ($request->existing_account == 1) {
                ChartOfAccounts::where('id', $request->child_account_id)->update([
                    'party_id' => $party->id,
                ]);
            } else {
                if ($request->manual_account == 1) {
                    ChartOfAccounts::create([
                        'party_id' => $party->id,
                        'name' => $request->coa_name,
                        'account_code' => $request->account_code,
                        'alias' => $request->alias,
                        'max_child_account' => $request->max_child_account,
                        'category_id' => $request->category_id,
                        'sub_category_id' => $request->sub_category_id,
                        // 'pl_category_id' => $request->name,
                        'reference_number' => $request->reference_number,
                        'parent_account_id' => $request->parent_account_id,
                        'status' => $request->status,
                        'level' => 4
                    ]);
                } else if ($request->party_is == "customer") {
                    ChartOfAccounts::create([
                        'party_id' => $party->id,
                        'name' => $request->name,
                        'account_code' => (int) $customer_coa + 1,
                        'alias' => $request->coa_name,
                        'max_child_account' => '999',
                        'category_id' => 1,
                        'sub_category_id' => 3,
                        // 'pl_category_id' => $request->name,
                        'reference_number' => (int) $customer_coa + 1,
                        'parent_account_id' => 48,
                        'status' => 1,
                        'level' => 4
                    ]);
                } else if ($request->party_is == "vendor") {
                    ChartOfAccounts::create([
                        'party_id' => $party->id,
                        'name' => $request->name,
                        'account_code' => (int) $vendor_coa + 1,
                        'alias' => $request->coa_name,
                        'max_child_account' => '999',
                        'category_id' => 5,
                        'sub_category_id' => 4,
                        // 'pl_category_id' => $request->name,
                        'reference_number' => (int) $vendor_coa + 1,
                        'parent_account_id' => 76,
                        'status' => 1,
                        'level' => 4
                    ]);
                }
            }

            $logController->createLog(__METHOD__, 'success', 'User Created.', auth()->user(), '');

            // return redirect()->to('/party')->with('success', 'New Record Created SuccessFully!');
            return redirect()->to('/party/edit/' . $party->id)->with('success', 'Record Created SuccessFully!');
        } catch (\Illuminate\Validation\ValidationException $e) {
            return redirect()->back()->with('error', 'The party name has already exist.');
        } catch (Exception $e) {
            dd($e);
            $logController->createLog(__METHOD__, 'error', $e, auth()->user(), '');

            return redirect()->back()->with('error', 'Something Went Wrong!');
        }
    }

    public function edit(Party $party, LogsController $logController)
    {
        try {
            $party = Party::where('id', $party->id)->first();
            $party_types = PartyType::where('status', 1)->get();
            $party_operations = PartyOperations::all();
            $cities = City::all();
            $countries = Country::all();
            $account_categories = AccountCategory::all();
            $account_sub_categories = AccountSubCategory::all();
            // $parent_accounts = ChartOfAccounts::all();
            $parent_accounts = ChartOfAccounts::whereIn('level', [2, 3])->get();
            $child_accounts = ChartOfAccounts::where('level', 4)->get();

            $logController->createLog(__METHOD__, 'success', 'Accessing User Edit Page.', auth()->user(), '');

            return view('party.edit', compact('account_categories', 'account_sub_categories', 'parent_accounts', 'child_accounts', 'party', 'party_operations', 'cities', 'countries', 'party_types'));
        } catch (Exception $e) {
            $logController->createLog(__METHOD__, 'error', $e, auth()->user(), '');

            return redirect()->back()->with('error', 'Something Went Wrong!');
        }
    }

    public function update(Party $party, Request $request, LogsController $logController)
    {
        try {
            $request->validate([
                'name' => 'required',
            ]);

            Party::where('id', $party->id)->update([
                'name' => $request->name,
                'reg_date' => $request->reg_date,
                'contact_person' => $request->contact_person,
                'address' => $request->address,
                'city_id' => $request->city_id,
                'country_id' => $request->country_id,
                'zip_code' => $request->zip_code,
                'phone_no' => $request->phone_no,
                'mobile' => $request->mobile,
                'email' => $request->email,
                'website' => $request->website,
                'import_nomination' => $request->import_nomination,
                'export_nomination' => $request->export_nomination,
                'company_restriction' => $request->company_restriction,
                'cost_center_restriction' => $request->cost_center_restriction,
                'ntn_no' => $request->ntn_no,
                'strn_no' => $request->strn_no,
                'license_no' => $request->license_no,
                'party_is' => $request->party_is,
                'status' => 1,
            ]);

            ChartOfAccounts::updateOrCreate(['party_id' => $party->id], [
                'name' => $request->name,
                'account_code' => $request->account_code,
                'alias' => $request->alias,
                'max_child_account' => $request->max_child_account,
                'category_id' => $request->category_id,
                'sub_category_id' => $request->sub_category_id,
                // 'pl_category_id' => $request->name,
                'reference_number' => $request->reference_number,
                'parent_account_id' => $request->parent_account_id,
                'status' => $request->status,
                'party_id' => $party->id
            ]);

            if ($request->operation_id) {
                PartyDetailOperation::where('party_id', $party->id)->delete();
                foreach ($request->operation_id as $operation) {
                    PartyDetailOperation::create([
                        'party_id' => $party->id,
                        'operation_id' => $operation,
                    ]);
                }
            }

            if ($request->type_id) {
                PartyDetailType::where('party_id', $party->id)->delete();
                foreach ($request->type_id as $type) {
                    PartyDetailType::create([
                        'party_id' => $party->id,
                        'type_id' => $type,
                    ]);
                }
            }

            $logController->createLog(__METHOD__, 'success', 'Edited User', auth()->user(), json_encode($party));

            // return redirect()->to('/party')->with('success', 'Record Updated SuccessFully!');
            return redirect()->to('/party/edit/' . $party->id)->with('success', 'Record Updated SuccessFully!');
        } catch (Exception $e) {

            dd($e);

            $logController->createLog(__METHOD__, 'error', 'Error on Edited User', auth()->user(), json_encode($party));

            return redirect()->back()->with('error', 'Something Went Wrong!');
        }
    }

    public function delete($id)
    {
        try {
            $party = Party::find($id);
            $party->where('id', $id)->delete();

            return redirect()->back()->with('success', 'Record Deleted Succesfully!');
        } catch (Exception $e) {

            return redirect()->back()->with('error', 'Something Went Wrong!');
        }
    }

    // public function toggleStatus(Request $request, User $party)
    // {
    //     try {
    //         User::where('id', $party->id)->update([
    //             'status' => !$party->status
    //         ]);

    //         return redirect()->back()->with('success', 'Status Updated Succesfully!');
    //     } catch (Exception $e) {
    //         return redirect()->back()->with('error', 'Something Went Wrong!');
    //     }
    // }
}
