<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Http\Controllers\LogsController;
use App\Models\City;
use App\Models\Country;
use App\Models\Location_type;
use App\Models\Party;
use App\Models\PartyDetailOperation;
use App\Models\PartyDetailType;
use App\Models\PartyLocations;
use App\Models\PartyLocationTypes;
use App\Models\PartyOperations;
use App\Models\PartyType;
use App\Models\Role;
use App\Models\RoleUser;
use App\Models\User;
use Carbon\Carbon;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class PartyLocationsController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    
    public function index(Request $request, LogsController $logController)
    {
        try {

            $name = $request->name;
            $email = $request->email;
            $perPage = $request->input('perPage', session('perPage', 100));
            session(['perPage' => $perPage]);

            $party_locations = PartyLocations::when($name, function ($query) use ($name) {
                $query->where('name', 'like', '%' . $name . '%');
            })->when($email, function ($query) use ($email) {
                $query->where('email', 'like', '%' . $email . '%');
            })
                ->paginate($perPage);
            $logController->createLog(__METHOD__, 'success', 'Accessing User Index Page.', auth()->user(), '');

            return view('party_locations.index', compact('party_locations', 'name', 'email', 'perPage'));
        } catch (Exception $e) {
            dd($e);
            $logController->createLog(__METHOD__, 'error', $e, auth()->user(), '');

            return redirect()->back()->with('error', 'Something Went Wrong!');
        }
    }

    public function add(LogsController $logController)
    {
        try {
            $location_types = Location_type::where('status', 1)->get();
            $parties = Party::all();
            $cities = City::all();
            $countries = Country::all();

            $logController->createLog(__METHOD__, 'success', 'Accessing User Add Page.', auth()->user(), '');

            return view('party_locations.add', compact('location_types', 'parties', 'cities', 'countries'));
        } catch (Exception $e) {
            dd($e);
            $logController->createLog(__METHOD__, 'error', $e, auth()->user(), '');

            return redirect()->back()->with('error', 'Something Went Wrong!');
        }
    }

    public function store(Request $request, LogsController $logController)
    {
        try {
            $request->validate([
                'name' => 'required',
            ]);

            $party_location = PartyLocations::create([
                'name' => $request->name,
                'party_id' => $request->party_id,
                'contact_person' => $request->contact_person,
                'address' => $request->address,
                'city_id' => $request->city_id,
                'country_id' => $request->country_id,
                'state' => $request->state,
                'remarks' => $request->remarks,
                'status' => $request->status,
            ]);

            foreach ($request->type_id as $type) {
                PartyLocationTypes::create([
                    'party_location_id' => $party_location->id,
                    'party_id' => $request->party_id,
                    'type_id' => $type,
                ]);
            }

            $logController->createLog(__METHOD__, 'success', 'User Created.', auth()->user(), '');

            // return redirect()->to('/party')->with('success', 'New Record Created SuccessFully!');
            return redirect()->to('/party_location/edit/' . $party_location->id)->with('success', 'Record Created SuccessFully!');

        } catch (Exception $e) {
            // dd($e);
            $logController->createLog(__METHOD__, 'error', $e, auth()->user(), '');

            return redirect()->back()->with('error', 'Something Went Wrong!');
        }
    }

    public function edit(PartyLocations $party_location, LogsController $logController)
    {
        try {
            $location_types = Location_type::where('status', 1)->get();
            $parties = Party::all();
            $cities = City::all();
            $countries = Country::all();
            
            $logController->createLog(__METHOD__, 'success', 'Accessing User Edit Page.', auth()->user(), '');

            return view('party_locations.edit', compact('party_location', 'location_types', 'parties', 'cities', 'countries'));
        } catch (Exception $e) {
            $logController->createLog(__METHOD__, 'error', $e, auth()->user(), '');

            return redirect()->back()->with('error', 'Something Went Wrong!');
        }
    }

    public function update(PartyLocations $party_location, Request $request, LogsController $logController)
    {
        try {
            $request->validate([
                'name' => 'required',
            ]);

            PartyLocations::where('id', $party_location->id)->update([
                'name' => $request->name,
                'party_id' => $request->party_id,
                'contact_person' => $request->contact_person,
                'address' => $request->address,
                'city_id' => $request->city_id,
                'country_id' => $request->country_id,
                'state' => $request->state,
                'remarks' => $request->remarks,
                'status' => $request->status,
            ]);

            PartyDetailOperation::where('party_location_id', $party_location->id)->delete();
            foreach ($request->type_id as $type) {
                PartyLocationTypes::create([
                    'party_location_id' => $party_location->id,
                    'party_id' => $request->party_id,
                    'type_id' => $type,
                ]);
            }

            $logController->createLog(__METHOD__, 'success', 'Edited User', auth()->user(), json_encode($party));

            // return redirect()->to('/party_location')->with('success', 'Record Updated SuccessFully!');
            return redirect()->to('/party_location/edit/' . $party_location->id)->with('success', 'Record Updated SuccessFully!');

        } catch (Exception $e) {

            $logController->createLog(__METHOD__, 'error', 'Error on Edited User', auth()->user(), json_encode($party));

            return redirect()->back()->with('error', 'Something Went Wrong!');
        }
    }

    public function delete($id)
    {
        try {
            $party = PartyLocations::find($id);
            $party->where('id', $id)->delete();

            return redirect()->back()->with('success', 'Record Deleted Succesfully!');
        } catch (Exception $e) {

            return redirect()->back()->with('error', 'Something Went Wrong!');
        }
    }

    // public function toggleStatus(Request $request, User $party)
    // {
    //     try {
    //         User::where('id', $party->id)->update([
    //             'status' => !$party->status
    //         ]);

    //         return redirect()->back()->with('success', 'Status Updated Succesfully!');
    //     } catch (Exception $e) {
    //         return redirect()->back()->with('error', 'Something Went Wrong!');
    //     }
    // }
}
