<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;

use App\Models\PartyMapping;
use App\Http\Requests\PartyMappingRequest;

class PartyMappingsController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Contracts\View\View
     */
    public function index()
    {
        $partymappings = PartyMapping::paginate(10);
        return view('partymappings.index', ['partymappings' => $partymappings]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Contracts\View\View
     */
    public function create()
    {
        return view('partymappings.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  PartyMappingRequest  $request
     * @return \Illuminate\Http\RedirectResponse
     */
    public function store(PartyMappingRequest $request)
    {
        $partymapping = new PartyMapping;
        $partymapping->mapping_type = $request->input('mapping_type');
        $partymapping->integration_code = $request->input('integration_code');
        $partymapping->integration_name = $request->input('integration_name');
        $partymapping->csul_code = $request->input('csul_code');
        $partymapping->csul_name = $request->input('csul_name');
        $partymapping->status = $request->input('status');
        $partymapping->save();

        return to_route('partymappings.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Contracts\View\View
     */
    public function show($id)
    {
        $partymapping = PartyMapping::findOrFail($id);
        return view('partymappings.show', ['partymapping' => $partymapping]);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Contracts\View\View
     */
    public function edit($id)
    {
        $partymapping = PartyMapping::findOrFail($id);
        return view('partymappings.edit', ['partymapping' => $partymapping]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  PartyMappingRequest  $request
     * @param  int  $id
     * @return \Illuminate\Http\RedirectResponse
     */
    public function update(PartyMappingRequest $request, $id)
    {
        $partymapping = PartyMapping::findOrFail($id);
        $partymapping->mapping_type = $request->input('mapping_type');
        $partymapping->integration_code = $request->input('integration_code');
        $partymapping->integration_name = $request->input('integration_name');
        $partymapping->csul_code = $request->input('csul_code');
        $partymapping->csul_name = $request->input('csul_name');
        $partymapping->status = $request->input('status');
        $partymapping->save();

        return to_route('partymappings.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\RedirectResponse
     */
    public function destroy($id)
    {
        $partymapping = PartyMapping::findOrFail($id);
        $partymapping->delete();

        return to_route('partymappings.index');
    }
}
