<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;

use App\Models\PartyType;
use App\Http\Requests\PartyTypeRequest;

class PartyTypesController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Contracts\View\View
     */
    public function index()
    {
        $partytypes= PartyType::paginate(10);
        return view('partytypes.index', ['partytypes'=>$partytypes]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Contracts\View\View
     */
    public function create()
    {
        return view('partytypes.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  PartyTypeRequest  $request
     * @return \Illuminate\Http\RedirectResponse
     */
    public function store(PartyTypeRequest $request)
    {
        $partytype = new PartyType;
		$partytype->name = $request->input('name');
		$partytype->status = $request->input('status');
        $partytype->save();

        return to_route('partytypes.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Contracts\View\View
     */
    public function show($id)
    {
        $partytype = PartyType::findOrFail($id);
        return view('partytypes.show',['partytype'=>$partytype]);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Contracts\View\View
     */
    public function edit($id)
    {
        $partytype = PartyType::findOrFail($id);
        return view('partytypes.edit',['partytype'=>$partytype]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  PartyTypeRequest  $request
     * @param  int  $id
     * @return \Illuminate\Http\RedirectResponse
     */
    public function update(PartyTypeRequest $request, $id)
    {
        $partytype = PartyType::findOrFail($id);
		$partytype->name = $request->input('name');
		$partytype->status = $request->input('status');
        $partytype->save();

        return to_route('partytypes.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\RedirectResponse
     */
    public function destroy($id)
    {
        $partytype = PartyType::findOrFail($id);
        $partytype->delete();

        return to_route('partytypes.index');
    }
}
