<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;

use App\Models\Party_s_c_a_c__i_a_t_a__code;
use App\Http\Requests\Party_s_c_a_c__i_a_t_a__codeRequest;

class Party_s_c_a_c__i_a_t_a__codesController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Contracts\View\View
     */
    public function index()
    {
        $party_s_c_a_c__i_a_t_a__codes= Party_s_c_a_c__i_a_t_a__code::paginate(10);
        return view('party_s_c_a_c__i_a_t_a__codes.index', ['party_s_c_a_c__i_a_t_a__codes'=>$party_s_c_a_c__i_a_t_a__codes]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Contracts\View\View
     */
    public function create()
    {
        return view('party_s_c_a_c__i_a_t_a__codes.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  Party_s_c_a_c__i_a_t_a__codeRequest  $request
     * @return \Illuminate\Http\RedirectResponse
     */
    public function store(Party_s_c_a_c__i_a_t_a__codeRequest $request)
    {
        $party_s_c_a_c__i_a_t_a__code = new Party_s_c_a_c__i_a_t_a__code;
		$party_s_c_a_c__i_a_t_a__code->code = $request->input('code');
		$party_s_c_a_c__i_a_t_a__code->name = $request->input('name');
		$party_s_c_a_c__i_a_t_a__code->status = $request->input('status');
        $party_s_c_a_c__i_a_t_a__code->save();

        return to_route('party_s_c_a_c__i_a_t_a__codes.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Contracts\View\View
     */
    public function show($id)
    {
        $party_s_c_a_c__i_a_t_a__code = Party_s_c_a_c__i_a_t_a__code::findOrFail($id);
        return view('party_s_c_a_c__i_a_t_a__codes.show',['party_s_c_a_c__i_a_t_a__code'=>$party_s_c_a_c__i_a_t_a__code]);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Contracts\View\View
     */
    public function edit($id)
    {
        $party_s_c_a_c__i_a_t_a__code = Party_s_c_a_c__i_a_t_a__code::findOrFail($id);
        return view('party_s_c_a_c__i_a_t_a__codes.edit',['party_s_c_a_c__i_a_t_a__code'=>$party_s_c_a_c__i_a_t_a__code]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  Party_s_c_a_c__i_a_t_a__codeRequest  $request
     * @param  int  $id
     * @return \Illuminate\Http\RedirectResponse
     */
    public function update(Party_s_c_a_c__i_a_t_a__codeRequest $request, $id)
    {
        $party_s_c_a_c__i_a_t_a__code = Party_s_c_a_c__i_a_t_a__code::findOrFail($id);
		$party_s_c_a_c__i_a_t_a__code->code = $request->input('code');
		$party_s_c_a_c__i_a_t_a__code->name = $request->input('name');
		$party_s_c_a_c__i_a_t_a__code->status = $request->input('status');
        $party_s_c_a_c__i_a_t_a__code->save();

        return to_route('party_s_c_a_c__i_a_t_a__codes.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\RedirectResponse
     */
    public function destroy($id)
    {
        $party_s_c_a_c__i_a_t_a__code = Party_s_c_a_c__i_a_t_a__code::findOrFail($id);
        $party_s_c_a_c__i_a_t_a__code->delete();

        return to_route('party_s_c_a_c__i_a_t_a__codes.index');
    }
}
