<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;

use App\Models\RateGroup;
use App\Http\Requests\RateGroupRequest;

class RateGroupsController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Contracts\View\View
     */
    public function index()
    {
        $rategroups = RateGroup::paginate(10);
        return view('rategroups.index', ['rategroups' => $rategroups]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Contracts\View\View
     */
    public function create()
    {
        return view('rategroups.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  RateGroupRequest  $request
     * @return \Illuminate\Http\RedirectResponse
     */
    public function store(RateGroupRequest $request)
    {
        $rategroup = new RateGroup;
        $rategroup->name = $request->input('name');
        $rategroup->status = $request->input('status');
        $rategroup->save();

        return to_route('rategroups.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Contracts\View\View
     */
    public function show($id)
    {
        $rategroup = RateGroup::findOrFail($id);
        return view('rategroups.show', ['rategroup' => $rategroup]);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Contracts\View\View
     */
    public function edit($id)
    {
        $rategroup = RateGroup::findOrFail($id);
        return view('rategroups.edit', ['rategroup' => $rategroup]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  RateGroupRequest  $request
     * @param  int  $id
     * @return \Illuminate\Http\RedirectResponse
     */
    public function update(RateGroupRequest $request, $id)
    {
        $rategroup = RateGroup::findOrFail($id);
        $rategroup->name = $request->input('name');
        $rategroup->status = $request->input('status');
        $rategroup->save();

        return to_route('rategroups.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\RedirectResponse
     */
    public function destroy($id)
    {
        $rategroup = RateGroup::findOrFail($id);
        $rategroup->delete();

        return to_route('rategroups.index');
    }
}
