<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;

use App\Models\ReportFixedText;
use App\Http\Requests\ReportFixedTextRequest;

class ReportFixedTextsController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Contracts\View\View
     */
    public function index()
    {
        $reportfixedtexts= ReportFixedText::paginate(10);
        return view('reportfixedtexts.index', ['reportfixedtexts'=>$reportfixedtexts]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Contracts\View\View
     */
    public function create()
    {
        return view('reportfixedtexts.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  ReportFixedTextRequest  $request
     * @return \Illuminate\Http\RedirectResponse
     */
    public function store(ReportFixedTextRequest $request)
    {
        $reportfixedtext = new ReportFixedText;
		$reportfixedtext->doc_no = $request->input('doc_no');
		$reportfixedtext->report_no = $request->input('report_no');
		$reportfixedtext->description = $request->input('description');
        $reportfixedtext->save();

        return to_route('reportfixedtexts.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Contracts\View\View
     */
    public function show($id)
    {
        $reportfixedtext = ReportFixedText::findOrFail($id);
        return view('reportfixedtexts.show',['reportfixedtext'=>$reportfixedtext]);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Contracts\View\View
     */
    public function edit($id)
    {
        $reportfixedtext = ReportFixedText::findOrFail($id);
        return view('reportfixedtexts.edit',['reportfixedtext'=>$reportfixedtext]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  ReportFixedTextRequest  $request
     * @param  int  $id
     * @return \Illuminate\Http\RedirectResponse
     */
    public function update(ReportFixedTextRequest $request, $id)
    {
        $reportfixedtext = ReportFixedText::findOrFail($id);
		$reportfixedtext->doc_no = $request->input('doc_no');
		$reportfixedtext->report_no = $request->input('report_no');
		$reportfixedtext->description = $request->input('description');
        $reportfixedtext->save();

        return to_route('reportfixedtexts.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\RedirectResponse
     */
    public function destroy($id)
    {
        $reportfixedtext = ReportFixedText::findOrFail($id);
        $reportfixedtext->delete();

        return to_route('reportfixedtexts.index');
    }
}
