<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Models\AccountCategory;
use App\Models\AccountSubCategory;
use App\Models\BlMaster;
use App\Models\Charge;
use App\Models\ChartOfAccounts;
use App\Models\ChartOfAccountsOpening;
use App\Models\ChequeBookDetail;
use App\Models\ChequeBookMaster;
use App\Models\Commodity;
use App\Models\CurrencyMaster;
use App\Models\Employee;
use App\Models\Employees;
use App\Models\TransactionMaster;
use App\Models\JobMaster;
use App\Models\JobStatus;
use App\Models\Operations;
use App\Models\Party;
use App\Models\PartyLocations;
use App\Models\PartyType;
use App\Models\ReceiptPaymentsDetail;
use App\Models\ShipStatus;
use App\Models\TransactionDetail;
use App\Models\Un_location;
use App\Models\Vessel;
use App\Models\Voyage;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use App\Models\ReceiptPayments;
use Carbon\Carbon;
use App\Models\JobChargesReceivable;
use App\Models\JobChargesPayable;
use App\Models\Transactions;
use PhpOffice\PhpSpreadsheet\Chart\Chart;

// use Livewire\Component;

class ReportsController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function jobBalanceSheet(Request $request)
    {
        // $parent_accounts = ChartOfAccounts::whereIn('level', [2, 3])->get();
        // $child_accounts = ChartOfAccounts::whereIn('level', [4])->get();
        // $currencies = CurrencyMaster::where('status', 1)->get();
        $operations = Operations::all();
        $currencies = CurrencyMaster::all();
        $party_types = PartyType::all();
        $clients = Party::where('party_is', 'customer')->orWhere('party_is', 'customer_vendor')->get();
        $vendors = Party::where('party_is', 'vendor')->orWhere('party_is', 'customer_vendor')->get();
        $jobs = JobMaster::all();
        $sales_rep = Employee::where('status', 1)->get();
        $un_locations = Un_location::where('status', 1)->get();
        $overseas_agent = Party::whereHas('party_type', function ($subQuery) {
            $subQuery->whereIn('type_id', [7, 13]);
        })->get();
        $vessels = Vessel::where('status', 1)->get();
        $voyages = Voyage::where('status', 1)->get();
        $shipping_line = Party::whereHas('party_type', function ($subQuery) {
            $subQuery->where('type_id', 12);
        })->get();
        $consignees = Party::whereHas('party_type', function ($subQuery) {
            $subQuery->where('type_id', 2);
        })->get();
        $forwarded_coloader = Party::whereHas('party_type', function ($subQuery) {
            $subQuery->where('type_id', 5);
        })->get();
        $custom_clearance = Party::whereHas('party_type', function ($subQuery) {
            $subQuery->where('type_id', 11);
        })->get();
        $shippers = Party::whereHas('party_type', function ($subQuery) {
            $subQuery->where('type_id', 1);
        })->get();
        $commodities = Commodity::where('status', 1)->get();
        $ship_status = ShipStatus::where('status', 1)->get();
        $job_status = JobStatus::where('status', 1)->get();
        $party_locations = PartyLocations::where('status', 1)->get();
        $date_from = Carbon::now()->month >= 7
            ? Carbon::now()->year . '-07-01'
            : Carbon::now()->subYear()->year . '-07-01';
        $date_to = Carbon::now()->format('Y-m-d');




        $query = JobMaster::with(['job_detail', 'job_vessel', 'job_weight', 'job_equipments', 'job_charges_receivable', 'job_charges_payable', 'job_charges', 'job_routing', 'job_other_info', 'bl_master'])->get();

        return view('report.job_balancing', compact('query', 'operations', 'party_locations', 'date_from', 'date_to', 'currencies', 'party_types', 'clients', 'vendors', 'jobs', 'sales_rep', 'un_locations', 'overseas_agent', 'voyages', 'vessels', 'shipping_line', 'consignees', 'forwarded_coloader', 'custom_clearance', 'commodities', 'shippers', 'ship_status', 'job_status'));
    }
    public function printView(Request $request)
    {
        $mergedData = $request->query('mergedData');
        $client = $request->query('client');
        $vendor = $request->query('vendor');
        $receipt_payment_rec = $request->query('receipt_payment_rec');
        $receipt_payment_pay = $request->query('receipt_payment_pay');
        return view('report.job_balancing_print', compact('type', 'mergedData', 'client', 'vendor', 'receipt_payment_rec', 'receipt_payment_pay'));
    }

    public function showJobBalanceSheet(Request $request)
    {
        $is_print = $request->query('is_print') ?? 0;
        $dateType = $request->input('date_type');
        $dateFrom = $request->input('date_from');
        $dateTill = $request->input('date_till');
        $allOperationTypes = $request->input('all_operation_types');
        $operationId = $request->input('operation_id');
        $exclude_zero = $request->input('exclude_zero');
        // $sortBy = $request->input('sort_by');
        // $category = $request->input('category');
        $subType = $request->input('sub_type');
        // $applyDateRange = $request->input('apply_date_range');
        $jobStatus = $request->input('job_status_id');
        $group_by = $request->input('group_by');
        $currency = $request->input('currency_id');
        $job_type = $request->input('job_type');
        $type = $request->input('type');
        $party_type = $request->input('party_type_id');
        $client = $request->input('client_id');
        $vendor = $request->input('vendor_id');
        $job = $request->input('job_id');
        $fileNo = $request->input('file_no');
        $costCenter = $request->input('cost_center');
        $salesRep = $request->input('sales_rep_id');
        $finalDest = $request->input('final_dest_id');
        $overseasAgent = $request->input('overseas_agent_id');
        $container = $request->input('container');
        $vessel = $request->input('vessel_id');
        $shippingLine = $request->input('shipping_line_id');
        $consignee = $request->input('consignee_id');
        $forwarderColoader = $request->input('forwarded_coloader_id');
        $clearingAgent = $request->input('clearing_agent_id');
        $shipper = $request->input('shipper_id');
        $commodity = $request->input('commodity_id');
        $portOfLoading = $request->input('port_of_loading_id');
        $terminalName = $request->input('terminal_id');
        $airPol = $request->input('air_pol_id');
        $airPod = $request->input('air_pod_id');
        $pod = $request->input('pod_id');
        $voyage = $request->input('voyage_id');

        $lgjTyp = $request->input('lgj_typ');
        $manifestNo = $request->input('manifest_no');
        $flightNo = $request->input('flight_no');
        $carrierBookingNo = $request->input('carrier_booking_no');
        $principal = $request->input('principal');
        $shipStatusId = $request->input('ship_status_id');
        // $terminalInvoiceNo = $request->input('terminal_invoice_no');
        $nomination = $request->input('nomination');
        // $customerGrp = $request->input('customer_grp');
        $refNo = $request->input('ref_no');

        $query = JobMaster::query();

        if ($dateType && $dateFrom && $dateTill) {
            if ($dateType == 1) {
                // dd($dateTill);
                $query->whereBetween('job_date', [$dateFrom, $dateTill]);
            } elseif ($dateType == 2) {
                $query->whereHas('bl_master', function ($subQuery) use ($dateFrom, $dateTill) {
                    $subQuery->whereBetween('sailing_date', [$dateFrom, $dateTill]);
                });
            } elseif ($dateType == 3) {
                // $query->whereHas('bl_master', function ($subQuery) use ($dateFrom, $dateTill) {
                //     $subQuery->whereHas('bl_ref_no', function ($subqQuery) use ($dateFrom, $dateTill) {
                //         $subqQuery->whereBetween('invoice_date', [$dateFrom, $dateTill]);
                //     });
                // });
                $query->whereBetween('job_date', [$dateFrom, $dateTill]);
            } elseif ($dateType == 4) {
                $query->whereHas('job_other_info', function ($subQuery) use ($dateFrom, $dateTill) {
                    $subQuery->whereBetween('delivery_date', [$dateFrom, $dateTill]);
                });
            }
        }

        if ($allOperationTypes == 1) {
            // No additional query modifications needed

        } elseif ($operationId) {
            $query->whereIn('operation_id', $operationId);
        }

        // if ($sortBy) {
        //     switch ($sortBy) {
        //         case 1:
        //             $query->orderBy('id');
        //             break;
        //         case 2:
        //             $query->orderBy('invoice_date');
        //             break;
        //         case 3:
        //             $query->orderBy('hbl_hawb');
        //             break;
        //         case 4:
        //             $query->orderBy('client');
        //             break;
        //         case 5:
        //             $query->orderBy('final_destination');
        //             break;
        //         case 6:
        //             $query->orderBy('sales_rep');
        //             break;
        //     }
        // }


        // if ($category) {
        //     $query->whereHas('job_detail', function ($subQuery) use ($category) {
        //         $subQuery->where('category', $category);
        //     });
        // }

        if ($subType && is_array($subType)) {
            if (in_array('Only Part FCL', $subType)) {
                $query->where('part_fcl', 1);
            }

            $allowedTypes = ['LCL', 'FCL', 'Car', 'BreakBulk'];

            // Filter based on sub_type_one if any of these types are present
            $query->whereIn('sub_type_one', array_intersect($subType, $allowedTypes));
        }


        if ($jobStatus) {
            $query->where('job_status_id', $jobStatus);
        }
        if ($currency) {
            $query->where('ex_rate', $currency);
        }
        $receipts = null;

        if ($client) {
            $query->whereHas('job_detail', function ($subQuery) use ($client) {
                $subQuery->where('client_id', $client);
            });
            if ($type == 1 || $type == 3) {
                $receipts = ReceiptPayments::where('type', 'receipt')
                    ->where('client_id', $client)
                    ->where('advance', '>', 0)
                    ->get();
            }
        }

        if ($vendor) {
            $query->whereHas('job_detail', function ($subQuery) use ($vendor) {
                $subQuery->where('local_vendor_id', $vendor);
            });
            if ($type == 2 || $type == 3) {
                $receipts = ReceiptPayments::where('type', 'payment')
                    ->where('client_id', $vendor)
                    ->where('advance', '>', 0)
                    ->get();
            }
        }

        if ($salesRep) {
            $query->whereHas('job_detail', function ($subQuery) use ($salesRep) {
                $subQuery->where('sales_rep_id', $salesRep);
            });
        }
        if ($finalDest) {
            $query->whereHas('job_detail', function ($subQuery) use ($finalDest) {
                $subQuery->where('final_destination_id', $finalDest);
            });
        }
        if ($overseasAgent) {
            $query->whereHas('job_detail', function ($subQuery) use ($overseasAgent) {
                $subQuery->where('overseas_agent_id', $overseasAgent);
            });
        }

        if ($container) {
            $query->whereHas('bl_master.bl_container_info', function ($subQuery) use ($container) {
                $subQuery->where('container_no', 'LIKE', "%$container%");
            });
        }

        if ($job) {
            $query->where('id', $job);
        }

        if ($fileNo) {
            $query->where('file_no', $fileNo);
        }

        if ($costCenter) {
            $query->where('cost_center', $costCenter);
        }

        if ($vessel) {
            $query->whereHas('job_vessel', function ($subQuery) use ($vessel) {
                $subQuery->where('vessel_id', $vessel);
            });
        }

        if ($voyage) {
            $query->whereHas('job_vessel', function ($subQuery) use ($voyage) {
                $subQuery->where('voyage_id', $voyage);
            });
        }

        if ($shippingLine) {
            $query->whereHas('job_detail', function ($subQuery) use ($shippingLine) {
                $subQuery->where('shipping_line_id', $shippingLine);
            });
        }

        if ($consignee) {
            $query->whereHas('job_detail', function ($subQuery) use ($consignee) {
                $subQuery->where('consignee_id', $consignee);
            });
        }

        if ($forwarderColoader) {
            $query->whereHas('job_detail', function ($subQuery) use ($forwarderColoader) {
                $subQuery->where('forwarder_coloader_id', $forwarderColoader);
            });
        }

        if ($clearingAgent) {
            $query->whereHas('job_detail', function ($subQuery) use ($clearingAgent) {
                $subQuery->where('custom_clearance_id', $clearingAgent);
            });
        }

        if ($commodity) {
            $query->whereHas('job_detail', function ($subQuery) use ($commodity) {
                $subQuery->where('commodity_id', $commodity);
            });
        }

        if ($shipper) {
            $query->whereHas('job_detail', function ($subQuery) use ($shipper) {
                $subQuery->where('shipper_id', $shipper);
            });
        }

        if ($portOfLoading) {
            $query->whereHas('job_detail', function ($subQuery) use ($portOfLoading) {
                $subQuery->where('port_of_loading_id', $portOfLoading);
            });
        }
        if ($pod) {
            $query->whereHas('job_detail', function ($subQuery) use ($pod) {
                $subQuery->where('port_of_discharge_id', $pod);
            });
        }

        if ($terminalName) {
            $query->whereHas('job_routing', function ($subQuery) use ($terminalName) {
                $subQuery->where('terminal_id', $terminalName);
            });
        }

        if ($airPol) {
            $query->whereIn('operation_id', [3, 4])  // Check if operation_id is either 1 or 2
                ->whereHas('job_detail', function ($subQuery) use ($airPol) {
                    $subQuery->whereIn('port_of_loading_id', $airPol);  // Use whereIn if $airPol is an array of IDs
                });
        }

        if ($airPod) {
            $query->whereIn('operation_id', [3, 4])  // Check if operation_id is either 1 or 2
                ->whereHas('job_detail', function ($subQuery) use ($airPod) {
                    $subQuery->whereIn('port_of_discharge_id', $airPod);  // Use whereIn if $airPol is an array of IDs
                });
        }

        // if ($group_by) {
        //     switch ($group_by) {
        //         case 1:
        //             $query->whereHas('job_detail', function ($subQuery) use ($group_by) {
        //                 $subQuery->groupBy('client_id');
        //             });
        //             break;
        //         case 2:
        //             $query->whereHas('job_detail', function ($subQuery) use ($group_by) {
        //                 $subQuery->groupBy('final_destination_id');
        //             });
        //             break;
        //         case 3:
        //             $query->whereHas('job_detail', function ($subQuery) {
        //                 $subQuery->groupBy('client_id', 'sales_rep_id');
        //             });
        //             break;
        //         case 4:
        //             $query->whereHas('JobChargesReceivable', function ($subQuery) {
        //                 $subQuery->where('ppcc', 'CC');
        //             });
        //             break;
        //         case 5:
        //             $query->whereHas('job_detail', function ($subQuery) {
        //                 $subQuery->groupBy('sales_rep_id');
        //             });
        //             break;
        //         case 6:
        //             $query->whereHas('job_detail', function ($subQuery) {
        //                 $subQuery->groupBy('shipper_id', 'consignee_id');
        //             });
        //             break;
        //         case 7:
        //             $query->groupBy('operation_id');
        //             break;
        //         case 8:
        //             $query->whereHas('job_detail', function ($subQuery) {
        //                 $subQuery->groupBy('local_vendor_id');
        //             });
        //             break;
        //         case 9:
        //             $query->whereHas('job_detail', function ($subQuery) {
        //                 $subQuery->groupBy('sales_rep_id', 'local_vendor_id');
        //             });
        //             break;
        //         case 10:
        //             $query->whereHas('job_detail', function ($subQuery) {
        //                 $subQuery->groupBy('forwarder_coloader_id');
        //             });
        //             break;
        //         case 11:
        //             $query->whereHas('job_detail', function ($subQuery) {
        //                 $subQuery->groupBy('custom_clearance_id');
        //             });
        //             break;
        //         case 12:
        //             $query->whereHas('job_detail', function ($subQuery) {
        //                 $subQuery->groupBy('forwarder_coloader_id', 'client_id');
        //             });
        //             break;
        //     }
        // }

        if ($shipStatusId) {
            $query->where('ship_status_id', $shipStatusId);
        }

        if ($job_type) {
            $query->whereIn('job_type', $job_type);
        }

        // if ($type) {
        //     switch ($type) {
        //         case 1:
        //             $query->with('job_charges_receivable');
        //             break;
        //         case 2:
        //             $query->with('job_charges_payable');
        //             break;
        //         case 3:
        //             $query->with(['job_charges_receivable', 'job_charges_payable']);
        //             break;
        //     }
        // }

        if ($party_type) {
            switch ($party_type) {
                case 1:
                    $query->whereHas('job_detail', function ($subQuery) {
                        $subQuery->whereNotNull('shipper_id');
                    });
                    break;
                case 2:
                    $query->whereHas('job_detail', function ($subQuery) {
                        $subQuery->whereNotNull('consignee_id');
                    });
                    break;
            }
        }

        // if ($terminalInvoiceNo) {
        //     $query->whereHas('job_detail', function ($subQuery) use ($terminalInvoiceNo) {
        //         $subQuery->where('terminal_invoice_no', $terminalInvoiceNo);
        //     });
        // }

        if ($nomination) {
            $query->where('nomination', $nomination);
        }

        // if ($customerGrp) {
        //     $query->whereHas('job_detail', function ($subQuery) use ($customerGrp) {
        //         $subQuery->whereHas('customer', function ($subSubQuery) use ($customerGrp) {
        //             $subSubQuery->whereHas('customer_group', function ($subSubSubQuery) use ($customerGrp) {
        //                 $subSubSubQuery->where('id', $customerGrp);
        //             });
        //         });
        //     });
        // }

        if ($refNo) {
            $query->whereHas('job_detail', function ($subQuery) use ($refNo) {
                $subQuery->where('ref_no', $refNo);
            });
        }


        $receipt_payment_rec = ReceiptPayments::where('type', 'receipt')->get();
        $receipt_payment_pay = ReceiptPayments::where('type', 'payment')->get();

        // if ($exclude_zero == 1) {

        // }
        $query->orderBy('job_date', 'asc');

        if ($exclude_zero == 1) {
            if ($type == 1) {
                $query = $query->get()->filter(function ($jobs) use ($receipt_payment_rec) {
                    $received_amount = 0;

                    foreach ($receipt_payment_rec as $receipt) {
                        foreach ($receipt->receipt_detail as $detail) {
                            if ($detail->job_no == $jobs->id) {
                                $received_amount += (int) $detail->rcvd_amount;
                            }
                        }
                    }
                    $recbalance = $jobs->total_receivable - $received_amount;

                    return $recbalance != 0;
                });
            } else if ($type == 2) {
                $query = $query->get()->filter(function ($jobs) use ($receipt_payment_pay) {
                    $paid_amount = 0;

                    foreach ($receipt_payment_pay as $receipt) {
                        foreach ($receipt->receipt_detail as $detail) {
                            if ($detail->job_no == $jobs->id) {
                                $paid_amount += $detail->rcvd_amount;
                            }
                        }
                    }
                    $paybalance = $jobs->total_payable - $paid_amount;

                    return $paybalance != 0;
                });
            } else {
                $query = $query->get()->filter(function ($jobs) use ($receipt_payment_rec, $receipt_payment_pay) {
                    $receivedAmount = 0;
                    $paidAmount = 0;

                    foreach ($receipt_payment_rec as $receipt) {
                        foreach ($receipt->receipt_detail as $detail) {
                            if ($detail->job_no == $jobs->id) {
                                $receivedAmount += $detail->rcvd_amount;
                            }
                        }
                    }
                    foreach ($receipt_payment_pay as $receipt) {
                        foreach ($receipt->receipt_detail as $detail) {
                            if ($detail->job_no == $jobs->id) {
                                $paidAmount += $detail->rcvd_amount;
                            }
                        }
                    }

                    $bothPaidRec = $receivedAmount + $paidAmount;
                    $bothamount = $jobs->total_receivable + $jobs->total_payable;
                    $bothbalance = $bothamount - $bothPaidRec;

                    return $bothbalance != 0;
                });
            }
        } else {
            $query = $query->get();
        }

        $query = $query->load([
            'job_detail',
            'job_vessel',
            'job_weight',
            'job_equipments',
            'job_charges',
            'job_routing',
            'job_other_info',
            'bl_master',
            'bl_master.bl_container_info',
        ]);

        $mergedData = [];
        foreach ($query as $job) {
            $mergedData[] = [
                'type' => 'job',
                'date' => $job->job_date,
                'data' => $job,
            ];
        }

        // Add receipts to the merged data array, but only if receipts exist
        if ($receipts && $receipts->isNotEmpty()) {
            foreach ($receipts as $receipt) {
                $mergedData[] = [
                    'type' => 'receipt',
                    'date' => $receipt->trans_date,
                    'data' => $receipt,
                ];
            }
        }

        usort($mergedData, function ($a, $b) {
            return strtotime($a['date']) - strtotime($b['date']);
        });

        // $perPage = 10;
        // session(['perPage' => $perPage]);
        // $query = $query->with([
        //     'job_detail',
        //     'job_vessel',
        //     'job_weight',
        //     'job_equipments',
        //     'job_charges',
        //     'job_routing',
        //     'job_other_info',
        //     'bl_master'
        // ])->get();

        // dd($query->job_charges_receivable);

        // $query = JobMaster::with(['job_detail', 'job_vessel', 'job_weight', 'job_equipments', 'job_charges_receivable', 'job_charges_payable', 'job_charges', 'job_routing', 'job_other_info', 'bl_master'])->get();
        if ($is_print == 1) {
            return view('report.job_balancing_print', compact('type', 'mergedData', 'client', 'vendor', 'receipt_payment_rec', 'receipt_payment_pay','dateFrom','dateTill'));
        }
        return view('report.job_balancing_report', compact('mergedData', 'client', 'vendor', 'receipt_payment_rec', 'receipt_payment_pay', 'type'));
    }
    public function profitAndLossSheet(Request $request)
    {
        // $parent_accounts = ChartOfAccounts::whereIn('level', [2, 3])->get();
        // $child_accounts = ChartOfAccounts::whereIn('level', [4])->get();
        // $currencies = CurrencyMaster::where('status', 1)->get();
        $operations = Operations::all();
        $currencies = CurrencyMaster::all();
        $party_types = PartyType::all();
        $clients = Party::where('party_is', 'customer')->orWhere('party_is', 'customer_vendor')->get();
        $vendors = Party::where('party_is', 'vendor')->orWhere('party_is', 'customer_vendor')->get();
        $jobs = JobMaster::all();
        $sales_rep = Employee::where('status', 1)->get();
        $un_locations = Un_location::where('status', 1)->get();
        $overseas_agent = Party::whereHas('party_type', function ($subQuery) {
            $subQuery->whereIn('type_id', [7, 13]);
        })->get();
        $vessels = Vessel::where('status', 1)->get();
        $voyages = Voyage::where('status', 1)->get();
        $shipping_line = Party::whereHas('party_type', function ($subQuery) {
            $subQuery->where('type_id', 12);
        })->get();
        $consignees = Party::whereHas('party_type', function ($subQuery) {
            $subQuery->where('type_id', 2);
        })->get();
        $forwarded_coloader = Party::whereHas('party_type', function ($subQuery) {
            $subQuery->where('type_id', 5);
        })->get();
        $custom_clearance = Party::whereHas('party_type', function ($subQuery) {
            $subQuery->where('type_id', 11);
        })->get();
        $shippers = Party::whereHas('party_type', function ($subQuery) {
            $subQuery->where('type_id', 1);
        })->get();
        $commodities = Commodity::where('status', 1)->get();
        $ship_status = ShipStatus::where('status', 1)->get();
        $job_status = JobStatus::where('status', 1)->get();
        $party_locations = PartyLocations::where('status', 1)->get();
        $date_from = Carbon::now()->month >= 7
            ? Carbon::now()->year . '-07-01'
            : Carbon::now()->subYear()->year . '-07-01';
        $date_to = Carbon::now()->format('Y-m-d');



        $query = JobMaster::with(['job_detail', 'job_vessel', 'job_weight', 'job_equipments', 'job_charges_receivable', 'job_charges_payable', 'job_charges', 'job_routing', 'job_other_info', 'bl_master'])->get();

        return view('report.job_profit_and_loss', compact('query', 'operations', 'date_from', 'date_to', 'party_locations', 'currencies', 'party_types', 'clients', 'vendors', 'jobs', 'sales_rep', 'un_locations', 'overseas_agent', 'voyages', 'vessels', 'shipping_line', 'consignees', 'forwarded_coloader', 'custom_clearance', 'commodities', 'shippers', 'ship_status', 'job_status'));
    }
    public function showProfitAndLossSheet(Request $request)
    {
        $dateType = $request->input('date_type');
        $dateFrom = $request->input('date_from');
        $dateTill = $request->input('date_till');
        $reportType = $request->input('report_type');
        $allOperationTypes = $request->input('all_operation_types');
        $operationId = $request->input('operation_id');
        $jobStatus = $request->input('job_status_id');
        // $group_by = $request->input('group_by');
        $job = $request->input('job_id');
        $vessel = $request->input('vessel_id');
        $client = $request->input('client_id');
        $shippingLine = $request->input('shipping_line_id');
        $voyage = $request->input('voyage_id');
        $costCenter = $request->input('cost_center');
        $salesRep = $request->input('sales_rep_id');
        $finalDest = $request->input('final_dest_id');
        $overseasAgent = $request->input('overseas_agent_id');
        $container = $request->input('container');
        $clearingAgent = $request->input('clearing_agent_id');
        $commodity = $request->input('commodity_id');
        $carrierBookingNo = $request->input('carrier_booking_no');
        $portOfLoading = $request->input('port_of_loading_id');
        $consignee = $request->input('consignee_id');
        $shipper = $request->input('shipper_id');
        $lgjTyp = $request->input('lgj_typ');
        $subType = $request->input('sub_type');
        $fileNo = $request->input('file_no');
        $shipStatusId = $request->input('ship_status_id');

        $query = JobMaster::query();

        if ($dateType && $dateFrom && $dateTill) {
            if ($dateType == 1) {
                $query->whereBetween('job_date', [$dateFrom, $dateTill]);
            } elseif ($dateType == 2) {
                $query->whereHas('bl_master', function ($subQuery) use ($dateFrom, $dateTill) {
                    $subQuery->whereBetween('sailing_date', [$dateFrom, $dateTill]);
                });
            }
        }

        if ($allOperationTypes == 1) {
            // No additional query modifications needed

        } elseif ($operationId) {
            $query->whereIn('operation_id', $operationId);
        }

        if ($jobStatus) {
            $query->where('job_status_id', $jobStatus);
        }

        if ($job) {
            $query->where('id', $job);
        }

        if ($vessel) {
            $query->whereHas('job_vessel', function ($subQuery) use ($vessel) {
                $subQuery->where('vessel_id', $vessel);
            });
        }

        if ($client) {
            $query->whereHas('job_detail', function ($subQuery) use ($client) {
                $subQuery->where('client_id', $client);
            });
        }

        if ($shippingLine) {
            $query->whereHas('job_detail', function ($subQuery) use ($shippingLine) {
                $subQuery->where('shipping_line_id', $shippingLine);
            });
        }

        if ($voyage) {
            $query->whereHas('job_vessel', function ($subQuery) use ($voyage) {
                $subQuery->where('voyage_id', $voyage);
            });
        }

        if ($costCenter) {
            $query->where('cost_center', $costCenter);
        }

        if ($salesRep) {
            $query->whereHas('job_detail', function ($subQuery) use ($salesRep) {
                $subQuery->where('sales_rep_id', $salesRep);
            });
        }

        if ($finalDest) {
            $query->whereHas('job_detail', function ($subQuery) use ($finalDest) {
                $subQuery->where('final_destination_id', $finalDest);
            });
        }

        if ($overseasAgent) {
            $query->whereHas('job_detail', function ($subQuery) use ($overseasAgent) {
                $subQuery->where('overseas_agent_id', $overseasAgent);
            });
        }

        if ($container) {
            $query->whereHas('bl_master.bl_container_info', function ($subQuery) use ($container) {
                $subQuery->where('container_no', 'LIKE', "%$container%");
            });
        }

        if ($clearingAgent) {
            $query->whereHas('job_detail', function ($subQuery) use ($clearingAgent) {
                $subQuery->where('custom_clearance_id', $clearingAgent);
            });
        }

        if ($commodity) {
            $query->whereHas('job_detail', function ($subQuery) use ($commodity) {
                $subQuery->where('commodity_id', $commodity);
            });
        }

        if ($portOfLoading) {
            $query->whereHas('job_detail', function ($subQuery) use ($portOfLoading) {
                $subQuery->where('port_of_loading_id', $portOfLoading);
            });
        }

        if ($consignee) {
            $query->whereHas('job_detail', function ($subQuery) use ($consignee) {
                $subQuery->where('consignee_id', $consignee);
            });
        }

        if ($shipper) {
            $query->whereHas('job_detail', function ($subQuery) use ($shipper) {
                $subQuery->where('shipper_id', $shipper);
            });
        }

        if ($fileNo) {
            $query->where('file_no', $fileNo);
        }


        if ($shipStatusId) {
            $query->where('ship_status_id', $shipStatusId);
        }

        if ($subType) {
            switch ($subType) {
                case 'LCL':
                    $query->where('sub_type_one', $subType);
                    break;
                case 'FCL':
                    $query->where('sub_type_one', $subType);

                    break;
                case 'Car':
                    $query->where('sub_type_one', $subType);
                    break;
                case 'BreakBulk':
                    $query->where('sub_type_one', $subType);
                    break;
            }
        }

        $receipt_payment_rec = ReceiptPayments::where('type', 'receipt')->get();
        $receipt_payment_pay = ReceiptPayments::where('type', 'payment')->get();

        $query = $query->with([
            'job_detail',
            'job_vessel',
            'job_weight',
            'job_equipments',
            'job_charges',
            'job_routing',
            'job_other_info',
            'bl_master'
        ])->get();

        return view('report.job_profit_and_loss_report', compact('query', 'receipt_payment_rec', 'receipt_payment_pay', 'reportType'));
    }

    public function jobListSheet(Request $request)
    {
        // $parent_accounts = ChartOfAccounts::whereIn('level', [2, 3])->get();
        // $child_accounts = ChartOfAccounts::whereIn('level', [4])->get();
        // $currencies = CurrencyMaster::where('status', 1)->get();
        $operations = Operations::all();
        $currencies = CurrencyMaster::all();
        $party_types = PartyType::all();
        $clients = Party::where('party_is', 'customer')->orWhere('party_is', 'customer_vendor')->get();
        $vendors = Party::where('party_is', 'vendor')->orWhere('party_is', 'customer_vendor')->get();
        $jobs = JobMaster::all();
        $sales_rep = Employee::where('status', 1)->get();
        $un_locations = Un_location::where('status', 1)->get();
        $overseas_agent = Party::whereHas('party_type', function ($subQuery) {
            $subQuery->whereIn('type_id', [7, 13]);
        })->get();
        $vessels = Vessel::where('status', 1)->get();
        $voyages = Voyage::where('status', 1)->get();
        $shipping_line = Party::whereHas('party_type', function ($subQuery) {
            $subQuery->where('type_id', 12);
        })->get();
        $consignees = Party::whereHas('party_type', function ($subQuery) {
            $subQuery->where('type_id', 2);
        })->get();
        $forwarded_coloader = Party::whereHas('party_type', function ($subQuery) {
            $subQuery->where('type_id', 5);
        })->get();
        $custom_clearance = Party::whereHas('party_type', function ($subQuery) {
            $subQuery->where('type_id', 11);
        })->get();
        $shippers = Party::whereHas('party_type', function ($subQuery) {
            $subQuery->where('type_id', 1);
        })->get();
        $commodities = Commodity::where('status', 1)->get();
        $ship_status = ShipStatus::where('status', 1)->get();
        $job_status = JobStatus::where('status', 1)->get();
        $party_locations = PartyLocations::where('status', 1)->get();
        $date_from = Carbon::now()->month >= 7
            ? Carbon::now()->year . '-07-01'
            : Carbon::now()->subYear()->year . '-07-01';
        $date_to = Carbon::now()->format('Y-m-d');


        $query = JobMaster::with(['job_detail', 'job_vessel', 'job_weight', 'job_equipments', 'job_charges_receivable', 'job_charges_payable', 'job_charges', 'job_routing', 'job_other_info', 'bl_master'])->get();

        return view('report.job_list', compact('query', 'operations', 'party_locations', 'date_from', 'date_to', 'currencies', 'party_types', 'clients', 'vendors', 'jobs', 'sales_rep', 'un_locations', 'overseas_agent', 'voyages', 'vessels', 'shipping_line', 'consignees', 'forwarded_coloader', 'custom_clearance', 'commodities', 'shippers', 'ship_status', 'job_status'));
    }

    public function showJobListSheet(Request $request)
    {
        $dateType = $request->input('date_type');
        $dateFrom = $request->input('date_from');
        $dateTill = $request->input('date_till');
        $client = $request->input('client_id');
        $shippingLine = $request->input('shipping_line_id');
        $vendor = $request->input('vendor_id');
        $costCenter = $request->input('cost_center');
        $salesRep = $request->input('sales_rep_id');
        $finalDest = $request->input('final_dest_id');
        $overseasAgent = $request->input('overseas_agent_id');
        $consignee = $request->input('consignee_id');
        $container = $request->input('container');
        $vessel = $request->input('vessel_id');
        // $principal = $request->input('principal');
        $clearingAgent = $request->input('clearing_agent_id');
        $terminalName = $request->input('terminal_id');
        $shipper = $request->input('shipper_id');
        $forwarderColoader = $request->input('forwarded_coloader_id');
        $job_type = $request->input('job_type');
        $voyage = $request->input('voyage_id');
        // $flightNo = $request->input('flight_no');
        $shipStatusId = $request->input('ship_status_id');
        $fileNo = $request->input('file_no');
        $subType = $request->input('sub_type');
        // $manifestNo = $request->input('manifest_no');
        $portOfLoading = $request->input('port_of_loading_id');
        $pod = $request->input('pod_id');
        // $lgjTyp = $request->input('lgj_typ');
        $nomination = $request->input('nomination');
        $allOperationTypes = $request->input('all_operation_types');
        $operationId = $request->input('operation_id');
        // $sortBy = $request->input('sort_by');
        $jobStatus = $request->input('job_status_id');
        // $group_by = $request->input('group_by');

        $cBkgEd = $request->input('c_bkg_ed');
        $deliveryAgent = $request->input('delivery_agent');
        $hblNo = $request->input('hbl_no');
        $mblNo = $request->input('mbl_no');
        $approved_unapproved = $request->input('approved_unapproved');

        $query = JobMaster::query();

        if ($dateType && $dateFrom && $dateTill) {
            if ($dateType == 1) {
                $query->whereBetween('job_date', [$dateFrom, $dateTill]);
            } elseif ($dateType == 2) {
                $query->whereHas('bl_master', function ($subQuery) use ($dateFrom, $dateTill) {
                    $subQuery->whereBetween('sailing_date', [$dateFrom, $dateTill]);
                });
            }
        }

        if ($client) {
            $query->whereHas('job_detail', function ($subQuery) use ($client) {
                $subQuery->where('client_id', $client);
            });
        }

        if ($shippingLine) {
            $query->whereHas('job_detail', function ($subQuery) use ($shippingLine) {
                $subQuery->where('shipping_line_id', $shippingLine);
            });
        }

        if ($vendor) {
            $query->whereHas('job_detail', function ($subQuery) use ($vendor) {
                $subQuery->where('local_vendor_id', $vendor);
            });
        }

        if ($costCenter) {
            $query->where('cost_center', $costCenter);
        }

        if ($salesRep) {
            $query->whereHas('job_detail', function ($subQuery) use ($salesRep) {
                $subQuery->where('sales_rep_id', $salesRep);
            });
        }

        if ($finalDest) {
            $query->whereHas('job_detail', function ($subQuery) use ($finalDest) {
                $subQuery->where('final_destination_id', $finalDest);
            });
        }

        if ($overseasAgent) {
            $query->whereHas('job_detail', function ($subQuery) use ($overseasAgent) {
                $subQuery->where('overseas_agent_id', $overseasAgent);
            });
        }

        if ($consignee) {
            $query->whereHas('job_detail', function ($subQuery) use ($consignee) {
                $subQuery->where('consignee_id', $consignee);
            });
        }

        if ($container) {
            $query->whereHas('bl_master.bl_container_info', function ($subQuery) use ($container) {
                $subQuery->where('container_no', 'LIKE', "%$container%");
            });
        }

        if ($vessel) {
            $query->whereHas('job_vessel', function ($subQuery) use ($vessel) {
                $subQuery->where('vessel_id', $vessel);
            });
        }

        if ($clearingAgent) {
            $query->whereHas('job_detail', function ($subQuery) use ($clearingAgent) {
                $subQuery->where('custom_clearance_id', $clearingAgent);
            });
        }

        if ($terminalName) {
            $query->whereHas('job_routing', function ($subQuery) use ($terminalName) {
                $subQuery->where('terminal_id', $terminalName);
            });
        }

        if ($shipper) {
            $query->whereHas('job_detail', function ($subQuery) use ($shipper) {
                $subQuery->where('shipper_id', $shipper);
            });
        }

        if ($forwarderColoader) {
            $query->whereHas('job_detail', function ($subQuery) use ($forwarderColoader) {
                $subQuery->where('forwarder_coloader_id', $forwarderColoader);
            });
        }

        if ($job_type) {
            $query->where('job_type', $job_type);
        }

        if ($voyage) {
            $query->whereHas('job_vessel', function ($subQuery) use ($voyage) {
                $subQuery->where('voyage_id', $voyage);
            });
        }

        if ($shipStatusId) {
            $query->where('ship_status_id', $shipStatusId);
        }

        if ($fileNo) {
            $query->where('file_no', 'like', '%' . $fileNo . '%');
        }

        if ($subType) {
            switch ($subType) {
                case 'LCL':
                    $query->where('sub_type_one', $subType);
                    break;
                case 'FCL':
                    $query->where('sub_type_one', $subType);

                    break;
                case 'Car':
                    $query->where('sub_type_one', $subType);
                    break;
                case 'BreakBulk':
                    $query->where('sub_type_one', $subType);
                    break;
            }
        }

        if ($portOfLoading) {
            $query->whereHas('job_detail', function ($subQuery) use ($portOfLoading) {
                $subQuery->where('port_of_loading_id', $portOfLoading);
            });
        }

        if ($pod) {
            $query->whereHas('job_detail', function ($subQuery) use ($pod) {
                $subQuery->where('port_of_discharge_id', $pod);
            });
        }

        if ($nomination) {
            $query->where('nomination', $nomination);
        }

        // if ($allOperationTypes == 1) {
        // } elseif ($operationId) {
        //     $query->where('operation_id', $operationId);
        // }

        if ($allOperationTypes == 1) {
        } elseif ($operationId) {
            $query->whereIn('operation_id', $operationId);
        }

        if ($jobStatus) {
            $query->where('job_status_id', $jobStatus);
        }

        // if ($group_by) {
        //     switch ($group_by) {
        //         case 1:
        //             $query->whereHas('job_detail', function ($subQuery) use ($group_by) {
        //                 $subQuery->groupBy('client_id');
        //             });
        //             break;
        //         case 2:
        //             $query->whereHas('job_detail', function ($subQuery) {
        //                 $subQuery->groupBy('shipping_line_id');
        //             });
        //             break;
        //         case 3:
        //             $query->whereHas('job_detail', function ($subQuery) {
        //                 $subQuery->groupBy('local_vendor_id');
        //             });
        //             break;
        //         case 4:
        //             $query->whereHas('job_vessel', function ($subQuery) {
        //                 $subQuery->groupBy('vessel_id');
        //             });
        //             break;
        //         case 5:
        //             $query->whereHas('job_detail', function ($subQuery) {
        //                 $subQuery->groupBy('sales_rep_id');
        //             });
        //             break;
        //         case 6:
        //             $query->whereHas('job_detail', function ($subQuery) {
        //                 $subQuery->groupBy('commodity_id');
        //             });
        //             break;
        //         case 7:
        //             $query->groupBy('job_status_id');
        //             break;
        //     }
        // }

        if ($cBkgEd) {
            $query->whereHas('job_vessel', function ($subQuery) use ($cBkgEd) {
                $subQuery->where('c_bkg_ed', 'like', '%' . $cBkgEd . '%');
            });
        }

        if ($hblNo) {
            $query->whereHas('bl_master', function ($subQuery) use ($hblNo) {
                $subQuery->where('hbl_no', 'like', '%' . $hblNo . '%');
            });
        }

        if ($mblNo) {
            $query->whereHas('bl_master', function ($subQuery) use ($mblNo) {
                $subQuery->where('mbl_no', 'like', '%' . $mblNo . '%');
            });
        }

        if ($approved_unapproved) {
            switch ($approved_unapproved) {
                case 1:
                    break;
                case 2:
                    $query->where('status', 2);
                    break;
                case 3:
                    $query->groupBy('status', 1);
                    break;
            }
        }

        if ($deliveryAgent) {
            $query->whereHas('bl_master', function ($subQuery) use ($deliveryAgent) {
                $subQuery->whereHas('bl_details', function ($subqQuery) use ($deliveryAgent) {
                    $subqQuery->whereHas('delivery_agent', 'like', '%' . $deliveryAgent . '%');
                });
            });
        }

        $query = $query->with([
            'job_detail',
            'job_vessel',
            'job_weight',
            'job_equipments',
            'job_charges',
            'job_routing',
            'job_other_info',
            'bl_master'
        ])->get();

        return view('report.job_list_report', compact('query'));
    }
    public function partySOASheet(Request $request)
    {
        // $parent_accounts = ChartOfAccounts::whereIn('level', [2, 3])->get();
        // $child_accounts = ChartOfAccounts::whereIn('level', [4])->get();
        // $currencies = CurrencyMaster::where('status', 1)->get();
        $operations = Operations::all();
        $currencies = CurrencyMaster::all();
        $party_types = PartyType::all();
        $clients = Party::where('party_is', 'customer')->orWhere('party_is', 'customer_vendor')->get();
        $vendors = Party::where('party_is', 'vendor')->orWhere('party_is', 'customer_vendor')->get();
        $jobs = JobMaster::all();
        $sales_rep = Employee::where('status', 1)->get();
        $un_locations = Un_location::where('status', 1)->get();
        $overseas_agent = Party::whereHas('party_type', function ($subQuery) {
            $subQuery->whereIn('type_id', [7, 13]);
        })->get();
        $vessels = Vessel::where('status', 1)->get();
        $voyages = Voyage::where('status', 1)->get();
        $shipping_line = Party::whereHas('party_type', function ($subQuery) {
            $subQuery->where('type_id', 12);
        })->get();
        $consignees = Party::whereHas('party_type', function ($subQuery) {
            $subQuery->where('type_id', 2);
        })->get();
        $forwarded_coloader = Party::whereHas('party_type', function ($subQuery) {
            $subQuery->where('type_id', 5);
        })->get();
        $custom_clearance = Party::whereHas('party_type', function ($subQuery) {
            $subQuery->where('type_id', 11);
        })->get();
        $shippers = Party::whereHas('party_type', function ($subQuery) {
            $subQuery->where('type_id', 1);
        })->get();
        $commodities = Commodity::where('status', 1)->get();
        $ship_status = ShipStatus::where('status', 1)->get();
        $job_status = JobStatus::where('status', 1)->get();
        $party_locations = PartyLocations::where('status', 1)->get();
        $date_from = Carbon::now()->month >= 7
            ? Carbon::now()->year . '-07-01'
            : Carbon::now()->subYear()->year . '-07-01';
        $date_to = Carbon::now()->format('Y-m-d');



        $query = JobMaster::with(['job_detail', 'job_vessel', 'job_weight', 'job_equipments', 'job_charges_receivable', 'job_charges_payable', 'job_charges', 'job_routing', 'job_other_info', 'bl_master'])->get();

        return view('report.party_soa', compact('query', 'operations', 'date_from', 'date_to', 'party_locations', 'currencies', 'party_types', 'clients', 'vendors', 'jobs', 'sales_rep', 'un_locations', 'overseas_agent', 'voyages', 'vessels', 'shipping_line', 'consignees', 'forwarded_coloader', 'custom_clearance', 'commodities', 'shippers', 'ship_status', 'job_status'));
    }

    public function showPartySOASheet(Request $request)
    {
        $dateFrom = $request->input('date_from');
        $dateTill = $request->input('date_till');
        // ?? Carbon::now()->toDateString();
        $client = $request->input('client_id');
        // dd($request->all());
        $vendor = $request->input('vendor_id');
        $overseasAgent = $request->input('overseas_agent_id');
        $currency = $request->input('currency_id');

        $report = $request->input('report_type');
        $groupOn = 1;
        $groupOn = $request->input('report_for');

        // $query = TransactionMaster::query();
        $query = TransactionMaster::whereNotNull('receipt_payment_id');

        if ($dateFrom || $dateTill) {
            $query->whereBetween('date', [$dateFrom, $dateTill]);
        }

        if ($client) {
            $query->whereHas('chart_of_accounts', function ($subQuery) use ($client) {
                $subQuery->whereHas('party', function ($subqQuery) use ($client) {
                    $subqQuery->where('id', $client);
                });
            });
            // $query->whereHas('party', function ($subQuery) use ($client) {
            //     $subQuery->where('id', $client);
            // });
        }

        if ($vendor) {
            $query->whereHas('chart_of_accounts', function ($subQuery) use ($vendor) {
                $subQuery->whereHas('party', function ($subqQuery) use ($vendor) {
                    $subqQuery->where('id', $vendor);
                });
            });
            // $query->whereHas('party', function ($subQuery) use ($vendor) {
            //     $subQuery->where('id', $vendor);
            // });
        }

        if ($overseasAgent) {
            $query->whereHas('chart_of_accounts', function ($subQuery) use ($overseasAgent) {
                $subQuery->whereHas('party', function ($subqQuery) use ($overseasAgent) {
                    $subqQuery->where('id', $overseasAgent);
                });
            });
            // $query->whereHas('party', function ($subQuery) use ($overseasAgent) {
            //     $subQuery->where('id', $overseasAgent);
            // });
        }

        if ($currency) {
            $query->where('currency_id', $currency);
        }

        if ($groupOn == 1) {
            // dd($query);
            $query = $query->get(); // No grouping, default case
        } elseif ($groupOn == 2) { // Overseas Agent
            // $query = $query->with(['party']) // Eager load 'party'
            //     ->join('party', 'party.id', '=', 'transaction_master.party_id') // Join 'party' table with 'transaction_master'
            //     ->whereNotNull('transaction_master.party_id') // Ensure 'party_id' is not null
            //     ->whereHas('party', function ($q) {
            //         // Filter where 'party_is' is either 'vendor' or 'customer_vendor'
            //         $q->whereIn('party_is', ['customer', 'customer_vendor']);
            //     })
            //     ->orderBy('transaction_master.party_id') // Order by 'party_id'
            //     ->get();

            $query = $query->with(['chart_of_accounts.party']) // Eager load 'party' through 'chart_of_accounts'
                ->whereHas('chart_of_accounts.party', function ($q) {
                    // Filter where 'party_is' is either 'customer' or 'customer_vendor'
                    $q->whereIn('party_is', ['customer', 'customer_vendor']);
                })
                ->whereNotNull('party_id') // Ensure 'party_id' is not null
                ->orderBy('party_id') // Order by 'party_id'
                ->get();

            // Group the results by 'party_id' using collection grouping
            $groupedResults = $query->groupBy('party_id');

            // dd($groupedResults);
            // Set the grouped results back to the $query variable
            $query = $groupedResults;
        } elseif ($groupOn == 3) { // Client
            $query = $query->with(['chart_of_accounts.party']) // Eager load 'party' through 'chart_of_accounts'
                ->whereHas('chart_of_accounts.party', function ($q) {
                    // Filter where 'party_is' is either 'customer' or 'customer_vendor'
                    $q->whereIn('party_is', ['vendor', 'customer_vendor']);
                })
                ->whereNotNull('party_id') // Ensure 'party_id' is not null
                ->orderBy('party_id') // Order by 'party_id'
                ->get();
            // $query = $query->with(['party']) // Eager load 'party' and 'party_is'
            //     ->join('party', 'party.id', '=', 'transaction_master.party_id') // Join 'party' table with 'transaction_master'
            //     ->whereNotNull('transaction_master.party_id') // Ensure 'party_id' is not null
            //     ->whereHas('party', function ($q) {
            //         // Filter where 'party_is' is either 'customer' or 'customer_vendor'
            //         $q->whereIn('party_is', ['vendor', 'customer_vendor']);
            //     })
            //     ->orderBy('transaction_master.party_id') // Order by 'party_id'
            //     ->get();

            // Group the results by 'transaction_master.party_id'
            $groupedResults = $query->groupBy('party_id');

            // Set the grouped results back to the $query variable
            $query = $groupedResults;
        } elseif ($groupOn == 4) { // Port
            // $query = $query->with(['party']) // Eager load 'party' and 'party_type'
            //     ->join('party', 'party.id', '=', 'transaction_master.party_id') // Join 'party' table with 'transaction_master'
            //     ->whereNotNull('transaction_master.party_id') // Ensure 'party_id' is not null
            //     ->whereHas('party.party_type', function ($q) {
            //         // Filter where 'type_id' is either 7 or 13 for overseas agents
            //         $q->whereIn('type_id', [7, 13]);
            //     })
            //     ->orderBy('party_id') // Order by 'party_id'
            //     ->get();

            $query = $query->with(['chart_of_accounts.party.party_type']) // Eager load 'party' and 'party_type' through 'chart_of_accounts'
                ->whereNotNull('party_id') // Ensure 'party_id' is not null
                ->whereHas('chart_of_accounts.party.party_type', function ($q) {
                    // Filter where 'type_id' is either 7 or 13 for overseas agents
                    $q->whereIn('type_id', [7, 13]);
                })
                ->orderBy('party_id') // Order by 'party_id'
                ->get();

            // Group the results by 'party_id' (overseas_agent ID)
            $groupedResults = $query->groupBy('transaction_master.party_id');

            // Set the grouped results back to the $query variable
            $query = $groupedResults;
        } else {
            $query = $query->get(); // No grouping, default case
        }

        // dd($query);
        $job_charges_receivables = JobChargesReceivable::all();
        $job_charges_payables = JobChargesPayable::all();


        if ($report == 1) {
            return view('report.party_soa_report_detail', compact('query', 'groupOn', 'job_charges_receivables', 'job_charges_payables'));
        } else {

            return view('report.party_soa_report_summary', compact('query', 'groupOn', 'job_charges_receivables', 'job_charges_payables'));
        }
    }
    public function newPartySOASheet(Request $request)
    {
        // $parent_accounts = ChartOfAccounts::whereIn('level', [2, 3])->get();
        // $child_accounts = ChartOfAccounts::whereIn('level', [4])->get();
        // $currencies = CurrencyMaster::where('status', 1)->get();
        $operations = Operations::all();
        $currencies = CurrencyMaster::all();
        $party_types = PartyType::all();
        $clients = Party::where('party_is', 'customer')->orWhere('party_is', 'customer_vendor')->get();
        $vendors = Party::where('party_is', 'vendor')->orWhere('party_is', 'customer_vendor')->get();
        $jobs = JobMaster::all();
        $sales_rep = Employee::where('status', 1)->get();
        $un_locations = Un_location::where('status', 1)->get();
        $overseas_agent = Party::whereHas('party_type', function ($subQuery) {
            $subQuery->whereIn('type_id', [7, 13]);
        })->get();
        $vessels = Vessel::where('status', 1)->get();
        $voyages = Voyage::where('status', 1)->get();
        $shipping_line = Party::whereHas('party_type', function ($subQuery) {
            $subQuery->where('type_id', 12);
        })->get();
        $consignees = Party::whereHas('party_type', function ($subQuery) {
            $subQuery->where('type_id', 2);
        })->get();
        $forwarded_coloader = Party::whereHas('party_type', function ($subQuery) {
            $subQuery->where('type_id', 5);
        })->get();
        $custom_clearance = Party::whereHas('party_type', function ($subQuery) {
            $subQuery->where('type_id', 11);
        })->get();
        $shippers = Party::whereHas('party_type', function ($subQuery) {
            $subQuery->where('type_id', 1);
        })->get();
        $commodities = Commodity::where('status', 1)->get();
        $ship_status = ShipStatus::where('status', 1)->get();
        $job_status = JobStatus::where('status', 1)->get();
        $party_locations = PartyLocations::where('status', 1)->get();




        $query = JobMaster::with(['job_detail', 'job_vessel', 'job_weight', 'job_equipments', 'job_charges_receivable', 'job_charges_payable', 'job_charges', 'job_routing', 'job_other_info', 'bl_master'])->get();

        return view('report.new_party_soa', compact('query', 'operations', 'party_locations', 'currencies', 'party_types', 'clients', 'vendors', 'jobs', 'sales_rep', 'un_locations', 'overseas_agent', 'voyages', 'vessels', 'shipping_line', 'consignees', 'forwarded_coloader', 'custom_clearance', 'commodities', 'shippers', 'ship_status', 'job_status'));
    }

    public function newShowPartySOASheet(Request $request)
    {
        $dateFrom = $request->input('date_from');
        $dateTill = $request->input('date_till');
        // ?? Carbon::now()->toDateString();
        $client = $request->input('client_id');
        // dd($request->all());
        $vendor = $request->input('vendor_id');
        $overseasAgent = $request->input('overseas_agent_id');
        $currency = $request->input('currency_id');

        $report = $request->input('report_type');
        $groupOn = 1;
        // $groupOn = $request->input('report_for');

        $query = TransactionMaster::query();

        if ($dateFrom || $dateTill) {
            $query->whereBetween('date', [$dateFrom, $dateTill]);
        }

        if ($client) {
            $query->whereHas('chart_of_accounts', function ($subQuery) use ($client) {
                $subQuery->whereHas('party', function ($subqQuery) use ($client) {
                    $subqQuery->where('id', $client);
                });
            });
            // $query->whereHas('party', function ($subQuery) use ($client) {
            //     $subQuery->where('id', $client);
            // });
        }

        if ($vendor) {
            $query->whereHas('chart_of_accounts', function ($subQuery) use ($vendor) {
                $subQuery->whereHas('party', function ($subqQuery) use ($vendor) {
                    $subqQuery->where('id', $vendor);
                });
            });
            // $query->whereHas('party', function ($subQuery) use ($vendor) {
            //     $subQuery->where('id', $vendor);
            // });
        }

        if ($overseasAgent) {
            $query->whereHas('chart_of_accounts', function ($subQuery) use ($overseasAgent) {
                $subQuery->whereHas('party', function ($subqQuery) use ($overseasAgent) {
                    $subqQuery->where('id', $overseasAgent);
                });
            });
            // $query->whereHas('party', function ($subQuery) use ($overseasAgent) {
            //     $subQuery->where('id', $overseasAgent);
            // });
        }

        if ($currency) {
            $query->where('currency_id', $currency);
        }

        if ($groupOn == 1) {
            // dd($query);
            $query = $query->get(); // No grouping, default case
        } elseif ($groupOn == 2) { // Overseas Agent
            $query = $query->with(['party']) // Eager load 'party'
                ->join('party', 'party.id', '=', 'transaction_master.party_id') // Join 'party' table with 'transaction_master'
                ->whereNotNull('transaction_master.party_id') // Ensure 'party_id' is not null
                ->whereHas('party', function ($q) {
                    // Filter where 'party_is' is either 'vendor' or 'customer_vendor'
                    $q->whereIn('party_is', ['customer', 'customer_vendor']);
                })
                ->orderBy('transaction_master.party_id') // Order by 'party_id'
                ->get();


            // Group the results by 'transaction_master.party_id'
            $groupedResults = $query->groupBy('party_id');

            // Set the grouped results back to the $query variable
            $query = $groupedResults;
        } elseif ($groupOn == 3) { // Client
            $query = $query->with(['party']) // Eager load 'party' and 'party_is'
                ->join('party', 'party.id', '=', 'transaction_master.party_id') // Join 'party' table with 'transaction_master'
                ->whereNotNull('transaction_master.party_id') // Ensure 'party_id' is not null
                ->whereHas('party', function ($q) {
                    // Filter where 'party_is' is either 'customer' or 'customer_vendor'
                    $q->whereIn('party_is', ['vendor', 'customer_vendor']);
                })
                ->orderBy('transaction_master.party_id') // Order by 'party_id'
                ->get();

            // Group the results by 'transaction_master.party_id'
            $groupedResults = $query->groupBy('party_id');

            // Set the grouped results back to the $query variable
            $query = $groupedResults;
        } elseif ($groupOn == 4) { // Port
            $query = $query->with(['party']) // Eager load 'party' and 'party_type'
                ->join('party', 'party.id', '=', 'transaction_master.party_id') // Join 'party' table with 'transaction_master'
                ->whereNotNull('transaction_master.party_id') // Ensure 'party_id' is not null
                ->whereHas('party.party_type', function ($q) {
                    // Filter where 'type_id' is either 7 or 13 for overseas agents
                    $q->whereIn('type_id', [7, 13]);
                })
                ->orderBy('party_id') // Order by 'party_id'
                ->get();

            // Group the results by 'party_id' (overseas_agent ID)
            $groupedResults = $query->groupBy('transaction_master.party_id');

            // Set the grouped results back to the $query variable
            $query = $groupedResults;
        } else {
            $query = $query->get(); // No grouping, default case
        }

        // dd($query);
        $job_charges_receivables = JobChargesReceivable::all();
        $job_charges_payables = JobChargesPayable::all();


        if ($report == 1) {
            return view('report.new_party_soa_report_detail', compact('query', 'groupOn', 'job_charges_receivables', 'job_charges_payables'));
        } else {

            return view('report.new_party_soa_report_summary', compact('query', 'groupOn', 'job_charges_receivables', 'job_charges_payables'));
        }
    }

    public function chargesWiseSheet(Request $request)
    {
        // $parent_accounts = ChartOfAccounts::whereIn('level', [2, 3])->get();
        // $child_accounts = ChartOfAccounts::whereIn('level', [4])->get();
        // $currencies = CurrencyMaster::where('status', 1)->get();
        $operations = Operations::all();
        $currencies = CurrencyMaster::all();
        $party_types = PartyType::all();
        $clients = Party::where('party_is', 'customer')->orWhere('party_is', 'customer_vendor')->get();
        $vendors = Party::where('party_is', 'vendor')->orWhere('party_is', 'customer_vendor')->get();
        $jobs = JobMaster::all();
        $sales_rep = Employee::where('status', 1)->get();
        $un_locations = Un_location::where('status', 1)->get();
        $overseas_agent = Party::whereHas('party_type', function ($subQuery) {
            $subQuery->whereIn('type_id', [7, 13]);
        })->get();
        $vessels = Vessel::where('status', 1)->get();
        $voyages = Voyage::where('status', 1)->get();
        $shipping_line = Party::whereHas('party_type', function ($subQuery) {
            $subQuery->where('type_id', 12);
        })->get();
        $consignees = Party::whereHas('party_type', function ($subQuery) {
            $subQuery->where('type_id', 2);
        })->get();
        $forwarded_coloader = Party::whereHas('party_type', function ($subQuery) {
            $subQuery->where('type_id', 5);
        })->get();
        $custom_clearance = Party::whereHas('party_type', function ($subQuery) {
            $subQuery->where('type_id', 11);
        })->get();
        $shippers = Party::whereHas('party_type', function ($subQuery) {
            $subQuery->where('type_id', 1);
        })->get();
        $commodities = Commodity::where('status', 1)->get();
        $ship_status = ShipStatus::where('status', 1)->get();
        $job_status = JobStatus::where('status', 1)->get();
        $party_locations = PartyLocations::where('status', 1)->get();
        $charges = Charge::all();
        $date_from = Carbon::now()->month >= 7
            ? Carbon::now()->year . '-07-01'
            : Carbon::now()->subYear()->year . '-07-01';
        $date_to = Carbon::now()->format('Y-m-d');



        $query = JobMaster::with(['job_detail', 'job_vessel', 'job_weight', 'job_equipments', 'job_charges_receivable', 'job_charges_payable', 'job_charges', 'job_routing', 'job_other_info', 'bl_master'])->get();

        return view('report.charge_wise_job_report', compact('query', 'operations', 'date_from', 'date_to', 'party_locations', 'currencies', 'party_types', 'clients', 'vendors', 'jobs', 'sales_rep', 'un_locations', 'overseas_agent', 'voyages', 'vessels', 'shipping_line', 'consignees', 'forwarded_coloader', 'custom_clearance', 'commodities', 'shippers', 'ship_status', 'job_status', 'charges'));
    }

    public function showChargesWiseSheet(Request $request)
    {
        $dateType = $request->input('date_type');
        $dateFrom = $request->input('date_from');
        $dateTill = $request->input('date_till');

        $report = $request->input('report');
        $job = $request->input('job_id');
        $manifestNo = $request->input('manifest_no');
        $vessel = $request->input('vessel_id');
        $voyage = $request->input('voyage_id');
        $charge = $request->input('charge_id');
        $client = $request->input('client_id');
        $shippingLine = $request->input('shipping_line_id');
        $vendor = $request->input('vendor_id');
        $costCenter = $request->input('cost_center');
        $salesRep = $request->input('sales_rep_id');
        $finalDest = $request->input('final_dest_id');
        $overseasAgent = $request->input('overseas_agent_id');
        $consignee = $request->input('consignee_id');
        $job_type = $request->input('job_type');
        $subType = $request->input('sub_type');
        $shipStatusId = $request->input('ship_status_id');
        $fileNo = $request->input('file_no');
        $allOperationTypes = $request->input('all_operation_types');
        $operationId = $request->input('operation_id');
        $jobStatus = $request->input('job_status_id');
        $group_by = $request->input('group_by');

        $principal = $request->input('principal');
        // $lgjTyp = $request->input('lgj_typ');
        // $sortBy = $request->input('sort_by');
        $type = $request->input('type');

        $query = JobMaster::query();

        if ($dateType && $dateFrom && $dateTill) {
            if ($dateType == 1) {
                $query->whereBetween('job_date', [$dateFrom, $dateTill]);
            } elseif ($dateType == 2) {
                $query->whereHas('bl_master', function ($subQuery) use ($dateFrom, $dateTill) {
                    $subQuery->whereBetween('sailing_date', [$dateFrom, $dateTill]);
                });
            } elseif ($dateType == 3) {
                $query->whereHas('bl_master', function ($subQuery) use ($dateFrom, $dateTill) {
                    $subQuery->whereHas('bl_ref_no', function ($subqQuery) use ($dateFrom, $dateTill) {
                        $subqQuery->whereBetween('invoice_date', [$dateFrom, $dateTill]);
                    });
                });
            } elseif ($dateType == 4) {
                $query->whereHas('job_other_info', function ($subQuery) use ($dateFrom, $dateTill) {
                    $subQuery->whereBetween('delivery_date', [$dateFrom, $dateTill]);
                });
            }
        }

        if ($allOperationTypes == 1) {
            // No additional query modifications needed

        } elseif ($operationId) {
            $query->whereIn('operation_id', $operationId);
        }

        if ($subType) {
            switch ($subType) {
                case 'LCL':
                    $query->where('sub_type_one', $subType);
                    break;
                case 'FCL':
                    $query->where('sub_type_one', $subType);

                    break;
                case 'Car':
                    $query->where('sub_type_one', $subType);
                    break;
                case 'BreakBulk':
                    $query->where('sub_type_one', $subType);
                    break;
            }
        }

        if ($charge) {
            $query->whereHas('job_charges_receivable', function ($subQuery) use ($charge) {
                $subQuery->where('charge_id', $charge);
            })->orWhereHas('job_charges_payable', function ($subQuery) use ($charge) {
                $subQuery->where('charge_id', $charge);
            });
        }


        if ($jobStatus) {
            $query->where('job_status_id', $jobStatus);
        }

        if ($client) {
            $query->whereHas('job_detail', function ($subQuery) use ($client) {
                $subQuery->where('client_id', $client);
            });
        }

        if ($vendor) {
            $query->whereHas('job_detail', function ($subQuery) use ($vendor) {
                $subQuery->where('local_vendor_id', $vendor);
            });
        }

        if ($salesRep) {
            $query->whereHas('job_detail', function ($subQuery) use ($salesRep) {
                $subQuery->where('sales_rep_id', $salesRep);
            });
        }
        if ($finalDest) {
            $query->whereHas('job_detail', function ($subQuery) use ($finalDest) {
                $subQuery->where('final_destination_id', $finalDest);
            });
        }
        if ($overseasAgent) {
            $query->whereHas('job_detail', function ($subQuery) use ($overseasAgent) {
                $subQuery->where('overseas_agent_id', $overseasAgent);
            });
        }

        if ($job) {
            $query->where('id', $job);
        }

        if ($fileNo) {
            $query->where('file_no', $fileNo);
        }

        if ($costCenter) {
            $query->where('cost_center', $costCenter);
        }

        if ($vessel) {
            $query->whereHas('job_vessel', function ($subQuery) use ($vessel) {
                $subQuery->where('vessel_id', $vessel);
            });
        }

        if ($voyage) {
            $query->whereHas('job_vessel', function ($subQuery) use ($voyage) {
                $subQuery->where('voyage_id', $voyage);
            });
        }

        if ($shippingLine) {
            $query->whereHas('job_detail', function ($subQuery) use ($shippingLine) {
                $subQuery->where('shipping_line_id', $shippingLine);
            });
        }

        if ($consignee) {
            $query->whereHas('job_detail', function ($subQuery) use ($consignee) {
                $subQuery->where('consignee_id', $consignee);
            });
        }

        // if ($group_by) {
        //     switch ($group_by) {
        //         case 1:
        //         case 2:
        //             $query->whereHas('job_detail', function ($subQuery) {
        //                 $subQuery->groupBy('final_destination_id');
        //             });
        //             break;
        //         case 3:
        //             $query->whereHas('job_detail', function ($subQuery) {
        //                 $subQuery->groupBy('sales_rep_id');
        //             });
        //             break;
        //         case 4:
        //             $query->groupBy('id');
        //             break;
        //         case 5:
        //             $query->whereHas('job_detail', function ($subQuery) {
        //                 $subQuery->groupBy('client_id');
        //             });
        //             break;
        //     }
        // }

        if ($shipStatusId) {
            $query->where('ship_status_id', $shipStatusId);
        }

        if ($job_type) {
            $query->where('job_type', $job_type);
        }

        // $perPage = 10;
        $query = $query->with([
            'job_detail',
            'job_charges_receivable',
            'job_charges_payable',
            'job_vessel',
            'job_weight',
            'job_equipments',
            'job_charges',
            'job_routing',
            'job_other_info',
            'bl_master'
        ])->whereHas('job_charges_receivable')  // Ensures jobs have receivable charges
            ->orWhereHas('job_charges_payable')   // Ensures jobs have payable charges
            ->get();

        $receipt_payment_detail = ReceiptPaymentsDetail::all();

        if ($report == 1) {
            // dd($query->job_charges_receivable);
            return view('report.charge_wise_job_report_report', compact('query', 'receipt_payment_detail', 'type'));
        } else {

            return view('report.charge_wise_job_summary', compact('query', 'receipt_payment_detail', 'type'));
        }
    }

    public function containerWiseSheet(Request $request)
    {
        // $parent_accounts = ChartOfAccounts::whereIn('level', [2, 3])->get();
        // $child_accounts = ChartOfAccounts::whereIn('level', [4])->get();
        // $currencies = CurrencyMaster::where('status', 1)->get();
        $operations = Operations::all();
        $currencies = CurrencyMaster::all();
        $party_types = PartyType::all();
        $clients = Party::where('party_is', 'customer')->orWhere('party_is', 'customer_vendor')->get();
        $vendors = Party::where('party_is', 'vendor')->orWhere('party_is', 'customer_vendor')->get();
        $jobs = JobMaster::all();
        $sales_rep = Employee::where('status', 1)->get();
        $un_locations = Un_location::where('status', 1)->get();
        $overseas_agent = Party::whereHas('party_type', function ($subQuery) {
            $subQuery->whereIn('type_id', [7, 13]);
        })->get();
        $vessels = Vessel::where('status', 1)->get();
        $voyages = Voyage::where('status', 1)->get();
        $shipping_line = Party::whereHas('party_type', function ($subQuery) {
            $subQuery->where('type_id', 12);
        })->get();
        $consignees = Party::whereHas('party_type', function ($subQuery) {
            $subQuery->where('type_id', 2);
        })->get();
        $forwarded_coloader = Party::whereHas('party_type', function ($subQuery) {
            $subQuery->where('type_id', 5);
        })->get();
        $custom_clearance = Party::whereHas('party_type', function ($subQuery) {
            $subQuery->where('type_id', 11);
        })->get();
        $shippers = Party::whereHas('party_type', function ($subQuery) {
            $subQuery->where('type_id', 1);
        })->get();
        $commodities = Commodity::where('status', 1)->get();
        $ship_status = ShipStatus::where('status', 1)->get();
        $job_status = JobStatus::where('status', 1)->get();
        $party_locations = PartyLocations::where('status', 1)->get();
        $charges = Charge::all();
        $date_from = Carbon::now()->month >= 7
            ? Carbon::now()->year . '-07-01'
            : Carbon::now()->subYear()->year . '-07-01';
        $date_to = Carbon::now()->format('Y-m-d');


        $query = JobMaster::with(['job_detail', 'job_vessel', 'job_weight', 'job_equipments', 'job_charges_receivable', 'job_charges_payable', 'job_charges', 'job_routing', 'job_other_info', 'bl_master'])->get();

        return view('report.container_wise_job_report', compact('query', 'date_from', 'date_to', 'operations', 'party_locations', 'currencies', 'party_types', 'clients', 'vendors', 'jobs', 'sales_rep', 'un_locations', 'overseas_agent', 'voyages', 'vessels', 'shipping_line', 'consignees', 'forwarded_coloader', 'custom_clearance', 'commodities', 'shippers', 'ship_status', 'job_status', 'charges'));
    }

    public function showContainerWiseSheet(Request $request)
    {
        $dateType = $request->input('date_type');
        $dateFrom = $request->input('date_from');
        $dateTill = $request->input('date_till');

        $vessel = $request->input('vessel_id');
        $voyage = $request->input('voyage_id');
        $overseasAgent = $request->input('overseas_agent_id');
        $shippingLine = $request->input('shipping_line_id');
        $consignee = $request->input('consignee_id');
        $portOfLoading = $request->input('port_of_loading_id');
        $shipper = $request->input('shipper_id');
        $allOperationTypes = $request->input('all_operation_types');
        $operationId = $request->input('operation_id');
        $sortBy = $request->input('sort_by');
        $jobStatus = $request->input('job_status_id');
        $subType = $request->input('sub_type');
        $job_type = $request->input('job_type');
        $costCenter = $request->input('cost_center');
        $salesRep = $request->input('sales_rep_id');
        $client = $request->input('client_id');
        $groupOn = $request->input('group_on');

        $query = BlMaster::query();

        if ($dateType && $dateFrom && $dateTill) {
            if ($dateType == 1) {
                $query->whereHas('job_master', function ($subQuery) use ($dateFrom, $dateTill) {
                    $subQuery->whereBetween('job_date', [$dateFrom, $dateTill]);
                });
            } elseif ($dateType == 2) {
                $query->whereBetween('sailing_date', [$dateFrom, $dateTill]);
            }
        }

        if ($allOperationTypes == 1) {
            // No additional query modifications needed

        } elseif ($operationId) {
            $query->whereIn('operation_id', $operationId);
        }

        if ($sortBy) {
            switch ($sortBy) {
                case 1:
                    $query->orderBy('job_master_id');
                    break;
                case 2:
                    $query->orderBy('created_at');
                    break;
                case 3:
                    $query->orderBy('id');
                    break;
                case 4:
                    $query->whereHas('job_master', function ($subQuery) {
                        $subQuery->whereNotNull('job_date');
                    })->orderBy('job_date');
                    break;
                case 5:
                    $query->orderBy('sailing_date');
                    break;
            }
        }

        if ($subType) {
            switch ($subType) {
                case 'LCL':
                    $query->whereHas('job_master', function ($subQuery) use ($subType) {
                        $subQuery->where('sub_type_one', $subType);
                    });
                    break;
                case 'FCL':
                    $query->whereHas('job_master', function ($subQuery) use ($subType) {
                        $subQuery->where('sub_type_one', $subType);
                    });

                    break;
                case 'Car':
                    $query->whereHas('job_master', function ($subQuery) use ($subType) {
                        $subQuery->where('sub_type_one', $subType);
                    });
                    break;
                case 'BreakBulk':
                    $query->whereHas('job_master', function ($subQuery) use ($subType) {
                        $subQuery->where('sub_type_one', $subType);
                    });
                    break;
            }
        }


        if ($jobStatus) {
            $query->whereHas('job_master', function ($subQuery) use ($jobStatus) {
                $subQuery->where('job_status_id', $jobStatus);
            });
        }

        if ($client) {
            $query->whereHas('job_master', function ($subQuery) use ($client) {
                $subQuery->whereHas('job_detail', function ($subqQuery) use ($client) {
                    $subqQuery->where('client_id', $client);
                });
            });
        }

        if ($salesRep) {
            $query->whereHas('job_master', function ($subQuery) use ($salesRep) {
                $subQuery->whereHas('job_detail', function ($subqQuery) use ($salesRep) {
                    $subqQuery->where('sales_rep_id', $salesRep);
                });
            });
        }

        if ($overseasAgent) {
            $query->whereHas('bl_booking_info', function ($subQuery) use ($overseasAgent) {
                $subQuery->where('overseas_agent_id', $overseasAgent);
            });
        }

        if ($costCenter) {
            $query->whereHas('job_master', function ($subQuery) use ($costCenter) {
                $subQuery->where('cost_center', $costCenter);
            });
        }

        if ($vessel) {
            $query->where('vessel_id', $vessel);
        }

        if ($voyage) {
            $query->where('voyage_id', $voyage);
        }

        if ($shippingLine) {
            $query->whereHas('bl_booking_info', function ($subQuery) use ($shippingLine) {
                $subQuery->where('shipping_line_id', $shippingLine);
            });
        }

        if ($consignee) {
            $query->where('consignee_id', $consignee);
        }

        if ($job_type) {
            $query->whereHas('job_master', function ($subQuery) use ($job_type) {
                $subQuery->where('job_type', $job_type);
            });
        }

        if ($shipper) {
            $query->where('shipper_id', $shipper);
        }

        if ($portOfLoading) {
            $query->whereHas('bl_booking_info', function ($subQuery) use ($portOfLoading) {
                $subQuery->where('port_of_loading_id', $portOfLoading);
            });
        }

        // $perPage = 10;

        if ($groupOn == 1) { // Vessel Wise
            $query = $query->with('vessel')->orderBy('vessel_id')->get();
            // $groupedResults = $query->getCollection()->groupBy('vessel_id');
            // $query->setCollection($groupedResults);
            $groupedResults = $query->groupBy('vessel_id');
            $query = $groupedResults;
            // dd($query);
        } elseif ($groupOn == 2) { // Overseas Agent
            $query = $query->with(['bl_booking_info.overseas_agent', 'bl_container_info']) // Eager load both overseas_agent and bl_container_info
                ->join('bl_booking_info', 'bl_master.id', '=', 'bl_booking_info.bl_master_id') // Join on bl_booking_info
                ->whereNotNull('bl_booking_info.overseas_agent_id') // Ensure overseas_agent_id is not null
                ->orderBy('bl_booking_info.overseas_agent_id') // Order by overseas_agent_id
                ->get();
            // Group by overseas_agent_id after pagination
            // $groupedResults = $query->getCollection()->groupBy('bl_booking_info.overseas_agent_id');
            // $query->setCollection($groupedResults);

            $groupedResults = $query->groupBy('bl_booking_info.overseas_agent_id');
            $query = $groupedResults;

            // } elseif ($groupOn == 3) { // Line Agent
            //     $query = $query->with('line_agent')->orderBy('line_agent_id')->paginate($perPage);
            //     $groupedResults = $query->getCollection()->groupBy('line_agent_id');
            //     $query->setCollection($groupedResults);
        } elseif ($groupOn == 4) { // Client
            // $query = $query->with('job_master.job_detail.client')->orderBy('job_detail.client_id')->paginate($perPage);
            // $groupedResults = $query->getCollection()->groupBy('client_id');
            // $query->setCollection($groupedResults);
            $query = $query->with(['job_master.job_detail.client']) // Eager load the client
                ->join('job_detail', 'bl_master.job_master_id', '=', 'job_detail.job_master_id') // Join on job_detail
                ->whereNotNull('job_detail.client_id') // Ensure client_id is not null
                ->orderBy('job_detail.client_id') // Order by client_id
                ->get();

            // Group by client_id after pagination
            // $groupedResults = $query->getCollection()->groupBy('client_id');
            // $query->setCollection($groupedResults);

            $groupedResults = $query->groupBy('client_id');
            $query = $groupedResults;
        } elseif ($groupOn == 5) { // Port
            $query = $query->with(['bl_booking_info.port_of_loading']) // Eager load the port_of_loading
                ->join('bl_booking_info', 'bl_master.id', '=', 'bl_booking_info.bl_master_id') // Join on bl_booking_info
                ->whereNotNull('bl_booking_info.port_of_loading_id') // Ensure port_of_loading_id is not null
                ->orderBy('bl_booking_info.port_of_loading_id') // Order by port_of_loading_id
                ->get();

            // Group by port_of_loading_id after pagination
            // $groupedResults = $query->getCollection()->groupBy('port_of_loading_id');
            // $query->setCollection($groupedResults);

            $groupedResults = $query->groupBy('port_of_loading_id');
            $query = $groupedResults;
        } else {
            $query = $query->get(); // No grouping, default case
        }

        // $query = $query->with([
        //     'job_detail',
        //     'job_charges_receivable',
        //     'job_charges_payable',
        //     'job_vessel',
        //     'job_weight',
        //     'job_equipments',
        //     'job_charges',
        //     'job_routing',
        //     'job_other_info',
        //     'bl_master'
        // ])->paginate($perPage);

        // dd($query);

        return view('report.container_wise_report', compact('query', 'groupOn'));
    }

    public function partyAudit(Request $request)
    {
        $operations = Operations::all();
        $party_types = PartyType::all();
        $clients = Party::where('party_is', 'customer')->orWhere('party_is', 'customer_vendor')->get();
        $vendors = Party::where('party_is', 'vendor')->orWhere('party_is', 'customer_vendor')->get();
        $jobs = JobMaster::all();
        $sales_rep = Employee::where('status', 1)->get();
        $un_locations = Un_location::where('status', 1)->get();
        $overseas_agent = Party::whereHas('party_type', function ($subQuery) {
            $subQuery->whereIn('type_id', [7, 13]);
        })->get();
        $vessels = Vessel::where('status', 1)->get();
        $voyages = Voyage::where('status', 1)->get();
        $shipping_line = Party::whereHas('party_type', function ($subQuery) {
            $subQuery->where('type_id', 12);
        })->get();
        $consignees = Party::whereHas('party_type', function ($subQuery) {
            $subQuery->where('type_id', 2);
        })->get();
        $forwarded_coloader = Party::whereHas('party_type', function ($subQuery) {
            $subQuery->where('type_id', 5);
        })->get();
        $custom_clearance = Party::whereHas('party_type', function ($subQuery) {
            $subQuery->where('type_id', 11);
        })->get();
        $shippers = Party::whereHas('party_type', function ($subQuery) {
            $subQuery->where('type_id', 1);
        })->get();
        $commodities = Commodity::where('status', 1)->get();
        $ship_status = ShipStatus::where('status', 1)->get();
        $job_status = JobStatus::where('status', 1)->get();
        $party_locations = PartyLocations::where('status', 1)->get();
        $date_from = Carbon::now()->month >= 7
            ? Carbon::now()->year . '-07-01'
            : Carbon::now()->subYear()->year . '-07-01';
        $date_to = Carbon::now()->format('Y-m-d');



        $query = JobMaster::with(['job_detail', 'job_vessel', 'job_weight', 'job_equipments', 'job_charges_receivable', 'job_charges_payable', 'job_charges', 'job_routing', 'job_other_info', 'bl_master'])->get();

        return view('report.party_audit', compact('query', 'operations', 'party_locations', 'date_from', 'date_to', 'party_types', 'clients', 'vendors', 'jobs', 'sales_rep', 'un_locations', 'overseas_agent', 'voyages', 'vessels', 'shipping_line', 'consignees', 'forwarded_coloader', 'custom_clearance', 'commodities', 'shippers', 'ship_status', 'job_status'));
    }

    public function showPartyAudit(Request $request)
    {
        $dateFrom = $request->input('date_from');
        $dateTill = $request->input('date_till');
        // ?? Carbon::now()->toDateString();
        $client = $request->input('client_id');
        // dd($request->all());
        $vendor = $request->input('vendor_id');
        $overseasAgent = $request->input('overseas_agent_id');
        // $currency = $request->input('currency_id');

        $report = $request->input('report_type');
        $groupOn = 1;
        $groupOn = $request->input('report_for');

        $query = Transactions::query();
        // $query = TransactionMaster::whereNotNull('receipt_payment_id');

        if ($dateFrom || $dateTill) {
            $query->whereBetween('inv_date', [$dateFrom, $dateTill]);
        }

        if ($client) {
            $query->where('client_id', $client);
        }

        if ($vendor) {
            $query->where('client_id', $vendor);
        }

        if ($overseasAgent) {
            $query->where('overseas_agent_id', $overseasAgent);
        }

        if ($groupOn == 1) {
            $query = $query->get();
        } elseif ($groupOn == 2) {

            $query = $query->with(['client']) // Eager load 'party' through 'chart_of_accounts'
                ->whereHas('client', function ($q) {
                    // Filter where 'party_is' is either 'customer' or 'customer_vendor'
                    $q->whereIn('party_is', ['customer', 'customer_vendor']);
                })
                ->whereNotNull('client_id') // Ensure 'party_id' is not null
                ->orderBy('client_id') // Order by 'party_id'
                ->get();

            $groupedResults = $query->groupBy('client_id');

            // dd($groupedResults);
            $query = $groupedResults;
        } elseif ($groupOn == 3) {
            $query = $query->with(['client'])
                ->whereHas('client', function ($q) {
                    $q->whereIn('party_is', ['vendor', 'customer_vendor']);
                })
                ->whereNotNull('client_id')
                ->orderBy('client_id')
                ->get();

            $groupedResults = $query->groupBy('client_id');

            $query = $groupedResults;
        } elseif ($groupOn == 4) {

            $query = $query->with(['overseas_agent.party_type'])
                ->whereNotNull('overseas_agent_id')
                ->whereHas('overseas_agent.party_type', function ($q) {
                    $q->whereIn('type_id', [7, 13]);
                })
                ->orderBy('overseas_agent_id')
                ->get();

            $groupedResults = $query->groupBy('overseas_agent_id');

            $query = $groupedResults;
        } else {
            $query = $query->get(); // No grouping, default case
        }

        // dd($query);


        if ($report == 1) {
            return view('report.party_audit_report_detail', compact('query', 'groupOn'));
        } else {
            return view('report.party_audit_report_summary', compact('query', 'groupOn'));
        }
    }

    public function clientExposure(Request $request)
    {
        $operations = Operations::all();
        $clients = Party::where('party_is', 'customer')->orWhere('party_is', 'customer_vendor')->get();
        $query = JobMaster::with(['job_detail', 'job_vessel', 'job_weight', 'job_equipments', 'job_charges_receivable', 'job_charges_payable', 'job_charges', 'job_routing', 'job_other_info', 'bl_master'])->get();

        return view('report.client_exposure', compact('query', 'clients', 'operations'));
    }

    public function showClientExposure(Request $request)
    {
        $client = $request->input('client_id');
        $operationId = $request->input('operation_id');
        $report = $request->input('report_type');

        $query = Transactions::query()
            ->with(['client']) // Eager load 'client'
            ->whereHas('client', function ($q) {
                $q->whereIn('party_is', ['customer', 'customer_vendor']);
            })
            ->whereNotNull('client_id')
            ->orderBy('client_id');

        // Apply filters before executing the query
        if ($operationId) {
            $query->whereIn('operation_id', (array) $operationId);
        }

        if ($client) {
            $query->where('client_id', $client);
        }

        // Execute the query and get results
        $results = $query->get();

        // Group the results by 'client_id'
        $query = $results->groupBy('client_id');

        // Pass the grouped results to the view
        return view('report.client_exposure_report', compact('query', 'report'));
    }

    public function loadingList(Request $request)
    {
        $bl_number = BlMaster::all();
        $clients = Party::where('party_is', 'customer')->orWhere('party_is', 'customer_vendor')->get();
        $overseas_agent = Party::whereHas('party_type', function ($subQuery) {
            $subQuery->whereIn('type_id', [7, 13]);
        })->get();
        $vessels = Vessel::where('status', 1)->get();
        $voyages = Voyage::where('status', 1)->get();
        $shipping_line = Party::whereHas('party_type', function ($subQuery) {
            $subQuery->where('type_id', 12);
        })->get();
        $date_from = Carbon::now()->month >= 7
            ? Carbon::now()->year . '-07-01'
            : Carbon::now()->subYear()->year . '-07-01';
        $date_to = Carbon::now()->format('Y-m-d');

        $query = JobMaster::with(['job_detail', 'job_vessel', 'job_weight', 'job_equipments', 'job_charges_receivable', 'job_charges_payable', 'job_charges', 'job_routing', 'job_other_info', 'bl_master'])->get();

        return view('report.loading_list', compact('query', 'date_from', 'date_to', 'clients', 'overseas_agent', 'voyages', 'vessels', 'shipping_line', 'bl_number'));
    }

    public function showLoadingList(Request $request)
    {
        $dateFrom = $request->input('date_from');
        $dateTill = $request->input('date_till');
        // $report = $request->input('report');
        $report_type = $request->input('report_type');
        $group_on = $request->input('group_on');

        $client = $request->input('client_id');
        $shippingLine = $request->input('shipping_line_id');
        $overseasAgent = $request->input('overseas_agent_id');
        $voyage = $request->input('voyage_id');
        $vessel = $request->input('vessel_id');

        $query = BlMaster::query();

        if ($dateFrom && $dateTill) {
            $query->whereBetween('bl_master.created_at', [$dateFrom, $dateTill]);
        }

        if ($client) {
            $query->whereHas('job_master', function ($subQuery) use ($client) {
                $subQuery->whereHas('job_detail', function ($subqQuery) use ($client) {
                    $subqQuery->where('client_id', $client);
                });
            });
        }

        if ($vessel) {
            $query->where('vessel_id', $vessel);
        }

        if ($voyage) {
            $query->where('voyage_id', $voyage);
        }

        if ($shippingLine) {
            $query->whereHas('bl_booking_info', function ($subQuery) use ($shippingLine) {
                $subQuery->where('shipping_line_id', $shippingLine);
            });
        }
        if ($overseasAgent) {
            $query->whereHas('bl_booking_info', function ($subQuery) use ($overseasAgent) {
                $subQuery->where('overseas_agent_id', $overseasAgent);
            });
        }

        if ($group_on == 1) { // Vessel Wise
            $query = $query->with('vessel')->orderBy('vessel_id')->get();
            $groupedResults = $query->groupBy('vessel_id');
            $query = $groupedResults;
        } elseif ($group_on == 2) { // shipping line wise
            $query = $query->with(['bl_booking_info.shipping_line']) // Eager load both shipping_line_id
                ->join('bl_booking_info', 'bl_master.id', '=', 'bl_booking_info.bl_master_id') // Join on bl_booking_info
                ->whereNotNull('bl_booking_info.shipping_line_id') // Ensure shipping_line_id is not null
                ->orderBy('bl_booking_info.shipping_line_id') // Order by shipping_line_id
                ->get();

            $groupedResults = $query->groupBy('bl_booking_info.shipping_line_id');
            $query = $groupedResults;
        } else {
            $query = $query->get(); // No grouping, default case
        }

        // $query = $query->with([
        //     'job_master',
        //     'bl_detail',
        //     'bl_booking_info',
        //     'bl_container_info',
        //     'bl_ref_no'
        // ])->get();

        // dd($query);

        return view('report.loading_list_report', compact('query', 'report_type', 'group_on'));
        // if ($report == 1) {
        // } else if($report == 2){
        //     return view('report.loading_list_fcl_report', compact('query', 'report', 'report_type', 'group_on'));
        // }
    }

    public function cargoMovements(Request $request)
    {

        $clients = Party::where('party_is', 'customer')->orWhere('party_is', 'customer_vendor')->get();
        $vendors = Party::where('party_is', 'vendor')->orWhere('party_is', 'customer_vendor')->get();
        $sales_rep = Employee::where('status', 1)->get();
        $un_locations = Un_location::where('status', 1)->get();
        $overseas_agent = Party::whereHas('party_type', function ($subQuery) {
            $subQuery->whereIn('type_id', [7, 13]);
        })->get();
        $vessels = Vessel::where('status', 1)->get();
        $voyages = Voyage::where('status', 1)->get();
        $shipping_line = Party::whereHas('party_type', function ($subQuery) {
            $subQuery->where('type_id', 12);
        })->get();
        $custom_clearance = Party::whereHas('party_type', function ($subQuery) {
            $subQuery->where('type_id', 11);
        })->get();
        $shippers = Party::whereHas('party_type', function ($subQuery) {
            $subQuery->where('type_id', 1);
        })->get();
        $date_from = Carbon::now()->month >= 7
            ? Carbon::now()->year . '-07-01'
            : Carbon::now()->subYear()->year . '-07-01';
        $date_to = Carbon::now()->format('Y-m-d');

        $query = JobMaster::with(['job_detail', 'job_vessel', 'job_weight', 'job_equipments', 'job_charges_receivable', 'job_charges_payable', 'job_charges', 'job_routing', 'job_other_info', 'bl_master'])->get();

        return view('report.cargo_movements', compact('query', 'date_from', 'date_to', 'clients', 'shippers', 'un_locations', 'vendors', 'sales_rep', 'overseas_agent', 'voyages', 'vessels', 'shipping_line', 'custom_clearance'));
    }

    public function showCargoMovements(Request $request)
    {
        $dateType = $request->input('date_type');
        $dateFrom = $request->input('date_from');
        $dateTill = $request->input('date_till');
        $client = $request->input('client_id');
        $shipper = $request->input('shipper_id');
        $clearingAgent = $request->input('clearing_agent_id');
        $salesRep = $request->input('sales_rep_id');
        $pod = $request->input('pod_id');
        $vendor = $request->input('vendor_id');
        $shippingLine = $request->input('shipping_line_id');
        $voyage = $request->input('voyage_id');
        $vessel = $request->input('vessel_id');
        $subType = $request->input('sub_type');
        $type = $request->input('type');

        $query = JobMaster::query();

        if ($dateType && $dateFrom && $dateTill) {
            if ($dateType == 1) {
                $query->whereBetween('job_date', [$dateFrom, $dateTill]);
            } elseif ($dateType == 2) {
                $query->whereHas('bl_master', function ($subQuery) use ($dateFrom, $dateTill) {
                    $subQuery->whereBetween('sailing_date', [$dateFrom, $dateTill]);
                });
            }
        }

        if ($client) {
            $query->whereHas('job_detail', function ($subqQuery) use ($client) {
                $subqQuery->where('client_id', $client);
            });
        }

        if ($shipper) {
            $query->whereHas('job_detail', function ($subQuery) use ($shipper) {
                $subQuery->where('shipper_id', $shipper);
            });
        }

        if ($clearingAgent) {
            $query->whereHas('job_detail', function ($subQuery) use ($clearingAgent) {
                $subQuery->where('custom_clearance_id', $clearingAgent);
            });
        }

        if ($salesRep) {
            $query->whereHas('job_detail', function ($subQuery) use ($salesRep) {
                $subQuery->where('sales_rep_id', $salesRep);
            });
        }

        if ($pod) {
            $query->whereHas('job_detail', function ($subQuery) use ($pod) {
                $subQuery->where('port_of_discharge_id', $pod);
            });
        }

        if ($vendor) {
            $query->whereHas('job_detail', function ($subQuery) use ($vendor) {
                $subQuery->where('local_vendor_id', $vendor);
            });
        }

        if ($shippingLine) {
            $query->whereHas('job_detail', function ($subQuery) use ($shippingLine) {
                $subQuery->where('shipping_line_id', $shippingLine);
            });
        }

        if ($vessel) {
            $query->whereHas('job_vessel', function ($subQuery) use ($vessel) {
                $subQuery->where('vessel_id', $vessel);
            });
        }

        if ($voyage) {
            $query->whereHas('job_vessel', function ($subQuery) use ($voyage) {
                $subQuery->where('voyage_id', $voyage);
            });
        }

        if ($subType) {
            $query->where('sub_type_one', $subType);
        }

        $query = $query->get();

        // dd($query);

        return view('report.cargo_movements_report', compact('query', 'type'));
    }

    public function agentInvoice(Request $request)
    {
        $operations = Operations::all();
        $currencies = CurrencyMaster::all();
        $clients = Party::where('party_is', 'customer')->orWhere('party_is', 'customer_vendor')->get();
        $jobs = JobMaster::all();
        $sales_rep = Employee::where('status', 1)->get();
        $un_locations = Un_location::where('status', 1)->get();
        $overseas_agent = Party::whereHas('party_type', function ($subQuery) {
            $subQuery->whereIn('type_id', [7, 13]);
        })->get();
        $vessels = Vessel::where('status', 1)->get();
        $voyages = Voyage::where('status', 1)->get();
        $shipping_line = Party::whereHas('party_type', function ($subQuery) {
            $subQuery->where('type_id', 12);
        })->get();
        $ship_status = ShipStatus::where('status', 1)->get();
        $job_status = JobStatus::where('status', 1)->get();

        $query = JobMaster::with(['job_detail', 'job_vessel', 'job_weight', 'job_equipments', 'job_charges_receivable', 'job_charges_payable', 'job_charges', 'job_routing', 'job_other_info', 'bl_master'])->get();

        return view('report.agent_invoice', compact('query', 'operations', 'currencies', 'jobs', 'sales_rep', 'un_locations', 'overseas_agent', 'voyages', 'vessels', 'shipping_line', 'ship_status', 'job_status'));
    }


    public function blReleaseStatus(Request $request)
    {
        $operations = Operations::all();
        $clients = Party::where('party_is', 'customer')->orWhere('party_is', 'customer_vendor')->get();
        $jobs = JobMaster::all();
        $sales_rep = Employee::where('status', 1)->get();
        $un_locations = Un_location::where('status', 1)->get();
        $vessels = Vessel::where('status', 1)->get();
        $voyages = Voyage::where('status', 1)->get();
        $shipping_line = Party::whereHas('party_type', function ($subQuery) {
            $subQuery->where('type_id', 12);
        })->get();
        $shippers = Party::whereHas('party_type', function ($subQuery) {
            $subQuery->where('type_id', 1);
        })->get();
        $commodities = Commodity::where('status', 1)->get();
        $ship_status = ShipStatus::where('status', 1)->get();
        $job_status = JobStatus::where('status', 1)->get();
        $date_from = Carbon::now()->month >= 7
            ? Carbon::now()->year . '-07-01'
            : Carbon::now()->subYear()->year . '-07-01';
        $date_to = Carbon::now()->format('Y-m-d');

        $query = JobMaster::with(['job_detail', 'job_vessel', 'job_weight', 'job_equipments', 'job_charges_receivable', 'job_charges_payable', 'job_charges', 'job_routing', 'job_other_info', 'bl_master'])->get();

        return view('report.bl_release_status', compact('query', 'operations', 'date_from', 'date_to', 'clients', 'jobs', 'sales_rep', 'un_locations', 'voyages', 'vessels', 'shipping_line', 'shippers', 'ship_status'));
    }

    public function showBlReleaseStatus(Request $request)
    {
        $dateType = $request->input('date_type');
        $dateFrom = $request->input('date_from');
        $dateTill = $request->input('date_till');
        $client = $request->input('client_id');
        $shippingLine = $request->input('shipping_line_id');
        $salesRep = $request->input('sales_rep_id');
        $jobId = $request->input('job_id');
        $finalDest = $request->input('final_dest_id');
        $vessel = $request->input('vessel_id');
        $shipper = $request->input('shipper_id');
        $voyage = $request->input('voyage_id');
        $portOfLoading = $request->input('port_of_loading_id');
        $pod = $request->input('pod_id');
        $allOperationTypes = $request->input('all_operation_types');
        $operationId = $request->input('operation_id');

        $query = BlMaster::query();

        if ($dateType && $dateFrom && $dateTill) {
            if ($dateType == 1) {
                $query->whereBetween('created_at', [$dateFrom, $dateTill]);
            } elseif ($dateType == 2) {
                $query->whereBetween('sailing_date', [$dateFrom, $dateTill]);
            }
        }

        if ($allOperationTypes == 1) {
            // No additional query modifications needed

        } elseif ($operationId) {
            $query->whereIn('operation_id', $operationId);
        }

        if ($client) {
            $query->whereHas('job_master', function ($subQuery) use ($client) {
                $subQuery->whereHas('job_detail', function ($subqQuery) use ($client) {
                    $subqQuery->where('client_id', $client);
                });
            });
        }

        if ($salesRep) {
            $query->whereHas('job_master', function ($subQuery) use ($salesRep) {
                $subQuery->whereHas('job_detail', function ($subqQuery) use ($salesRep) {
                    $subqQuery->where('sales_rep_id', $salesRep);
                });
            });
        }

        if ($finalDest) {
            $query->whereHas('bl_booking_info', function ($subQuery) use ($finalDest) {
                $subQuery->where('final_destination_id', $finalDest);
            });
        }

        if ($jobId) {
            $query->where('job_master_id', $jobId);
        }

        if ($vessel) {
            $query->where('vessel_id', $vessel);
        }

        if ($voyage) {
            $query->where('voyage_id', $voyage);
        }

        if ($shippingLine) {
            $query->whereHas('bl_booking_info', function ($subQuery) use ($shippingLine) {
                $subQuery->where('shipping_line_id', $shippingLine);
            });
        }

        if ($shipper) {
            $query->where('shipper_id', $shipper);
        }

        if ($portOfLoading) {
            $query->whereHas('bl_booking_info', function ($subQuery) use ($portOfLoading) {
                $subQuery->where('port_of_loading_id', $portOfLoading);
            });
        }
        if ($pod) {
            $query->whereHas('bl_booking_info', function ($subQuery) use ($pod) {
                $subQuery->where('port_of_discharge_id', $pod);
            });
        }


        $query = $query->with([
            'job_master',
            'bl_detail',
            'bl_booking_info',
            'bl_container_info',
            'bl_ref_no'
        ])->get();

        return view('report.bl_release_status_report', compact('query'));
    }
}
