<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;

use App\Models\Airport;
use App\Http\Requests\AirportRequest;
use App\Models\City;
use App\Models\Country;
use App\Models\Charge;
use App\Models\CurrencyMaster;
use Illuminate\Http\Request;
use App\Models\JobMaster;
use App\Models\Transactions;
use App\Models\TransactionCharges;
use App\Models\Party;
use App\Models\Operations;
use App\Http\Controllers\LogsController;

use App\Models\BlContainerInfo;
use App\Models\BlMaster;
use App\Models\ChartOfAccounts;
use App\Models\JobChargesReceivable;
use App\Models\TransactionDetail;
use App\Models\TransactionMaster;
use Exception;
use Illuminate\Support\Facades\DB;

class SEAgentInvoiceController extends Controller
{

    public function __construct()
    {
        $this->middleware('auth');
    }

    public function index(Request $request)
    {
        $url = $request->path();
        if ($url == "se_agent_invoice") {
            $agent_invoice = Transactions::where('operation_id', 1)->where('transaction_type_id', 2)->where(function ($subquery) {
                $subquery->where('bl_status', '<>', 2)
                    ->orWhereNull('bl_status');
            })->get();
        } elseif ($url == "si_agent_invoice") {
            $agent_invoice = Transactions::where('operation_id', 2)->where('transaction_type_id', 2)->where(function ($subquery) {
                $subquery->where('bl_status', '<>', 2)
                    ->orWhereNull('bl_status');
            })->get();
        } elseif ($url == "ae_agent_invoice") {
            $agent_invoice = Transactions::where('operation_id', 3)->where('transaction_type_id', 2)->where(function ($subquery) {
                $subquery->where('bl_status', '<>', 2)
                    ->orWhereNull('bl_status');
            })->get();
        } elseif ($url == "ai_agent_invoice") {
            $agent_invoice = Transactions::where('operation_id', 4)->where('transaction_type_id', 2)->where(function ($subquery) {
                $subquery->where('bl_status', '<>', 2)
                    ->orWhereNull('bl_status');
            })->get();
        }
        return view('sea_export.se_agent_invoice.index', compact('agent_invoice'));
    }

    public function add()
    {
        $overseas_agent = Party::whereHas('party_type', function ($subQuery) {
            $subQuery->whereIn('type_id', [7, 13]);
        })->get();
        $operations = Operations::all();
        $charges = Charge::all();
        $currencies = CurrencyMaster::all();
        return view('sea_export.se_agent_invoice.add', compact('charges', 'currencies', 'overseas_agent', 'operations'));
    }

    public function addFromJob(Request $request, $job_master)
    {
        $overseas_agent = Party::whereHas('party_type', function ($subQuery) {
            $subQuery->whereIn('type_id', [7, 13]);
        })->get();
        $operations = Operations::all();
        $charges = Charge::all();
        $currencies = CurrencyMaster::all();
        return view('sea_export.se_agent_invoice.addFromJob', compact('job_master', 'charges', 'currencies', 'overseas_agent', 'job_masters', 'operations'));
    }

    public function store(Request $request, LogsController $logController)
    {
        try {

            // $latest_transaction = Transactions::where('transaction_type_id', 2)->latest()->first() ?? 0;

            // $transaction = Transactions::create([
            //     'job_master_id' => $request->job_no,
            //     'transaction_type_id' => 2,
            //     'tran_no' => $request->tran_no,
            //     'inv_date' => $request->invoice_date,
            //     'agent_invoice_no' => $request->agent_invoice_no,
            //     'auto_manual' => $request->auto_manual,
            //     'job_type' => $request->job_type,
            //     'soa_date' => $request->soa_date,
            //     'soa_no' => $request->soa_no,
            //     'reference' => $request->reference,
            //     'bl_status' => $request->bl_status ?? 1,
            //     'category' => $request->category,
            //     'settlement' => $request->settlement,
            //     'overseas_agent_id' => $request->overseas_agent_id,
            //     'sequence_no' => $request->sequence_no,
            //     'invoice_type' => $request->invoice_type,
            //     'ref_tran_no' => $request->ref_tran_no,
            //     'operation_id' => $request->operation_id,
            //     'cost_center' => $request->cost_center,
            //     'invoice_to' => $request->invoice_to,
            //     'manual' => $request->manual,
            //     'due_days' => $request->due_days,
            //     'invoice_ac' => $request->invoice_ac,
            //     'auto_round_off' => $request->auto_round_off,
            //     'tax_charges' => $request->tax_charges,
            //     'remarks' => $request->remarks,
            //     'voucher_no' => $request->voucher_no,
            //     'bank_details' => $request->bank_details,
            //     'manual_remarks' => $request->manual_remarks,
            //     'grand_total_amount' => $request->grand_total_amount,
            //     'grand_net_amount' => $request->grand_net_amount,
            //     'grand_discount' => $request->grand_discount,
            //     'grand_tax_amount' => $request->grand_tax_amount,
            //     'grand_net_amount_inc_tax' => $request->grand_net_amount_inc_tax,
            //     'grand_local_amount' => $request->grand_local_amount,
            //     'status' => 1,
            // ]);
            // $party_id = ChartOfAccounts::where('party_id', $request->overseas_agent_id)->first();
            // $transaction_master = TransactionMaster::create([
            //     'transaction_id' => $transaction->id,
            //     'voucher_no' => 'AI-' . ((int) ($latest_transaction->id ?? 0) + 1) . '/' . date('y'),
            //     'date' => date('Y-m-d'),
            //     'transaction_type_master_id' => 4,
            //     'account_id' => 110, // Credit
            //     'cost_center_id' => 1,
            //     'party_id' => $party_id->id,
            //     'currency_id' => 1,
            //     // 'exchange_rate' => $request->exchange_rate,
            //     // 'cheque_date' => $request->cheque_date,
            //     'total_debit' => $request->grand_local_amount,
            //     'total_credit' => $request->grand_local_amount,
            //     // 'bank_sub_type' => $request->bank_sub_type,
            //     'company_id' => 1,
            //     'status' => 1,
            //     'narration' => 'Receivable Against Job # ' . 'AI-' . ((int) ($latest_transaction->id ?? 0) + 1) . '/' . date('y') . ' From ' . $party_id->name . '',
            //     'created_by' => auth()->user()->id,
            //     'voucher_type_id' => 10
            // ]);

            // // Debit
            // TransactionDetail::create([
            //     'transaction_master_id' => $transaction_master->id,
            //     'account_id' => $party_id->id,
            //     // 'cost_center_id' => $request->cost_center_detail[$key],
            //     // 'debit_vc' => $request->debit_vc[$key],
            //     // 'credit_vc' => $request->credit_vc[$key],
            //     'debit_lc' => $request->grand_local_amount,
            //     'credit_lc' => 0,
            //     'narration' => 'Receivable Against Job # ' . 'AI-' . ((int) ($latest_transaction->id ?? 0) + 1) . '/' . date('y') . ' From ' . $party_id->name . '',
            //     'status' => 1
            // ]);

            // // Credit
            // TransactionDetail::create([
            //     'transaction_master_id' => $transaction_master->id,
            //     'account_id' => 110,
            //     // 'cost_center_id' => $request->cost_center_detail[$key],
            //     // 'debit_vc' => $request->debit_vc[$key],
            //     // 'credit_vc' => $request->credit_vc[$key],
            //     'debit_lc' => 0,
            //     'credit_lc' => $request->grand_local_amount,
            //     'narration' => 'Receivable Against Job # ' . 'AI-' . ((int) ($latest_transaction->id ?? 0) + 1) . '/' . date('y') . ' From ' . $party_id->name . '',
            //     'status' => 1
            // ]);

            // foreach ($request->charge_id as $index => $detail) {
            //     $transaction_charges = TransactionCharges::create([
            //         'transaction_id' => $transaction->id,
            //         'job_charge_recievable_id' => $detail->id,
            //         'job_id' => $request->job_no[$index],
            //         'charge_code' => $request->charge_code[$index],
            //         'charge_id' => $detail,
            //         'description' => $request->description[$index],
            //         'size_type' => $request->size_type[$index],
            //         'rate_group' => $request->rate_group[$index],
            //         'dg_non_dg' => $request->dg_non_dg[$index],
            //         'container' => $request->container[$index],
            //         'hbl_no' => $request->container[$index],
            //         'mbl_no' => $request->container[$index],
            //         'dr_cr' => $request->container[$index],
            //         'qty' => $request->qty[$index],
            //         'rate' => $request->rate[$index],
            //         'currency' => $request->currency[$index],
            //         'amount' => $request->amount[$index],
            //         'discount' => $request->discount[$index],
            //         'net_amount' => $request->net_amount[$index],
            //         'tax' => $request->tax[$index],
            //         'tax_amount' => $request->tax_amount[$index],
            //         'net_amount_inc_tax' => $request->net_amount_inc_tax[$index],
            //         'ex_rate' => $request->ex_rate[$index],
            //         'local_amount' => $request->local_amount[$index],
            //         'status' => 1,
            //     ]);
            // }
            // $logController->createLog(__METHOD__, 'success', 'SE Agent Invoice Created.', auth()->user(), '');

            // // return redirect()->to('/se_invoice')->with('success', 'New Record Created SuccessFully!');
            // if ($request->operation_id == 1) {
            //     return redirect()->to('/se_agent_invoice/edit/' . $transaction->id)->with('success', 'Record Created SuccessFully!');
            // } else if ($request->operation_id == 2) {
            //     return redirect()->to('/si_agent_invoice/edit/' . $transaction->id)->with('success', 'Record Created SuccessFully!');
            // } else if ($request->operation_id == 3) {
            //     return redirect()->to('/ae_agent_invoice/edit/' . $transaction->id)->with('success', 'Record Created SuccessFully!');
            // } else if ($request->operation_id == 4) {
            //     return redirect()->to('/ai_agent_invoice/edit/' . $transaction->id)->with('success', 'Record Created SuccessFully!');
            // } else {
            //     return redirect()->to('/se_agent_invoice/edit/' . $transaction->id)->with('success', 'Record Created SuccessFully!');
            // }
            dd('Function disabled');
        } catch (Exception $e) {
            dd($e);

            $logController->createLog(__METHOD__, 'error', $e, auth()->user(), '');

            return redirect()->back()->with('error', 'Something Went Wrong!');
        }
    }
    public function storeFromJob(JobMaster $job_master, Request $request, LogsController $logController)
    {
        try {
            $party_id = ChartOfAccounts::where('party_id', $request->client_id)->first();
            if ($party_id) {

                $latest_transaction = Transactions::where('transaction_type_id', 2)->latest()->first();
                $transaction = Transactions::create([
                    'job_master_id' => $job_master->id,
                    'transaction_type_id' => 2,
                    'tran_no' => $request->tran_no,
                    'inv_date' => $request->invoice_date,
                    'agent_invoice_no' => $request->agent_invoice_no,
                    'auto_manual' => $request->auto_manual,
                    'job_type' => $request->job_type,
                    'soa_date' => $request->soa_date,
                    'soa_no' => $request->soa_no,
                    'reference' => $request->reference,
                    'bl_status' => $request->bl_status ?? 1,
                    'category' => $request->category,
                    'settlement' => $request->settlement,
                    'overseas_agent_id' => $request->overseas_agent_id,
                    'sequence_no' => $request->sequence_no,
                    'invoice_type' => $request->invoice_type,
                    'ref_tran_no' => $request->ref_tran_no,
                    'operation_id' => $request->operation_id,
                    'cost_center' => $request->cost_center,
                    'invoice_to' => $request->invoice_to,
                    'manual' => $request->manual,
                    'due_days' => $request->due_days,
                    'invoice_ac' => $request->invoice_ac,
                    'auto_round_off' => $request->auto_round_off,
                    'tax_charges' => $request->tax_charges,
                    'remarks' => $request->remarks,
                    'voucher_no' => $request->voucher_no,
                    'bank_details' => $request->bank_details,
                    'manual_remarks' => $request->manual_remarks,
                    'grand_total_amount' => $request->grand_total_amount,
                    'grand_net_amount' => $request->grand_net_amount,
                    'grand_discount' => $request->grand_discount,
                    'grand_tax_amount' => $request->grand_tax_amount,
                    'grand_net_amount_inc_tax' => $request->grand_net_amount_inc_tax,
                    'grand_local_amount' => $request->grand_local_amount,
                    'status' => 1,
                ]);

                $last_voucher_number = TransactionMaster::where('voucher_type_id', 10)
                    ->max('voucher_no');


                if (preg_match('/-(\d{5})\//', $last_voucher_number, $matches)) {
                    $sequence_number = intval($matches[1]) + 1;
                } else {
                    $sequence_number = 1;
                }
                $sequence_number_padded = str_pad($sequence_number, 5, '0', STR_PAD_LEFT);
                $year = date('y', strtotime($transaction->inv_date ?? date('Y-m-d')));
                $new_voucher_number = 'SI-' . $sequence_number_padded . '/' . $year;
                $transaction->update(['voucher_no' => $new_voucher_number]);

                $transaction_master = TransactionMaster::create([
                    'transaction_id' => $transaction->id,
                    'job_master_id' => $transaction->job_master_id,
                    'voucher_no' => $new_voucher_number,
                    'date' => date('Y-m-d'),
                    'transaction_type_master_id' => 4,
                    'account_id' => 110, // Credit
                    'cost_center_id' => 1,
                    'party_id' => $party_id->id,
                    'currency_id' => 1,
                    'exchange_rate' => $job_master->buying,
                    // 'cheque_date' => $request->cheque_date,
                    'total_debit_converted' => $request->grand_local_amount,
                    'total_credit_converted' => $request->grand_local_amount,
                    'total_debit' => $request->grand_net_amount_inc_tax,
                    'total_credit' => $request->grand_net_amount_inc_tax,
                    // 'bank_sub_type' => $request->bank_sub_type,
                    'company_id' => 1,
                    'status' => 4,
                    'narration' => 'Receivable Against Job # ' . 'AI-' . ((int) ($latest_transaction->id ?? 0) + 1) . '/' . date('y') . ' From ' . $party_id->name . '',
                    'created_by' => auth()->user()->id,
                    'voucher_type_id' => 10
                ]);

                // Debit
                TransactionDetail::create([
                    'transaction_master_id' => $transaction_master->id,
                    'account_id' => $party_id->id,
                    'job_master_id' => $transaction->job_master_id,
                    // 'cost_center_id' => $request->cost_center_detail[$key],
                    'debit_vc' => $request->grand_net_amount_inc_tax,
                    'credit_vc' => 0,
                    'debit_lc' => $request->grand_local_amount,
                    'credit_lc' => 0,
                    'narration' => 'Receivable Against Job # ' . 'AI-' . ((int) ($latest_transaction->id ?? 0) + 1) . '/' . date('y') . ' From ' . $party_id->name . '',
                    'status' => 1
                ]);

                // Credit
                TransactionDetail::create([
                    'transaction_master_id' => $transaction_master->id,
                    'account_id' => 110,
                    'job_master_id' => $transaction->job_master_id,
                    // 'cost_center_id' => $request->cost_center_detail[$key],
                    'debit_vc' => 0,
                    'credit_vc' => $request->grand_net_amount_inc_tax,
                    'debit_lc' => 0,
                    'credit_lc' => $request->grand_local_amount,
                    'narration' => 'Receivable Against Job # ' . 'AI-' . ((int) ($latest_transaction->id ?? 0) + 1) . '/' . date('y') . ' From ' . $party_id->name . '',
                    'status' => 1
                ]);

                foreach ($request->charge_id as $index => $detail) {
                    $transaction_charges = TransactionCharges::create([
                        'transaction_id' => $transaction->id,
                        'transaction_master_id' => $transaction_master->id,
                        'job_id' => $job_master->id,
                        'job_charge_recievable_id' => @$request->job_charge_recievable_id[$index],
                        'charge_code' => $request->charge_code[$index],
                        'charge_id' => $detail,
                        'description' => $request->description[$index],
                        'size_type' => $request->size_type[$index],
                        'rate_group' => $request->rate_group[$index],
                        'dg_non_dg' => $request->dg_non_dg[$index],
                        'container' => $request->container[$index],
                        'hbl_no' => $request->container[$index],
                        'mbl_no' => $request->container[$index],
                        'dr_cr' => $request->container[$index],
                        'qty' => $request->qty[$index],
                        'rate' => $request->rate[$index],
                        'currency' => $request->currency[$index],
                        'amount' => $request->amount[$index],
                        'discount' => $request->discount[$index],
                        'net_amount' => $request->net_amount[$index],
                        'tax' => $request->tax[$index],
                        'tax_amount' => $request->tax_amount[$index],
                        'net_amount_inc_tax' => $request->net_amount_inc_tax[$index],
                        'ex_rate' => $request->ex_rate[$index],
                        'local_amount' => $request->local_amount[$index],
                        'status' => 1,
                    ]);
                    if (isset($request->job_charge_recievable_id[$index])) {
                        JobChargesReceivable::where('id', $request->job_charge_recievable_id[$index])->update([
                            'bill_invoice' => $transaction->tran_no
                        ]);
                    }
                }
                $logController->createLog(__METHOD__, 'success', 'SE Agent Invoice Created.', auth()->user(), '');

                // return redirect()->to('/se_invoice')->with('success', 'New Record Created SuccessFully!');
                if ($job_master->operation_id == 1) {
                    return redirect()->to('/se_agent_invoice/edit/' . $transaction->id)->with('success', 'Record Created SuccessFully!');
                } else if ($job_master->operation_id == 2) {
                    return redirect()->to('/si_agent_invoice/edit/' . $transaction->id)->with('success', 'Record Created SuccessFully!');
                } else if ($job_master->operation_id == 3) {
                    return redirect()->to('/ae_agent_invoice/edit/' . $transaction->id)->with('success', 'Record Created SuccessFully!');
                } else if ($job_master->operation_id == 4) {
                    return redirect()->to('/ai_agent_invoice/edit/' . $transaction->id)->with('success', 'Record Created SuccessFully!');
                } else {
                    return redirect()->to('/se_agent_invoice/edit/' . $transaction->id)->with('success', 'Record Created SuccessFully!');
                }
            } else {
                $logController->createLog(__METHOD__, 'error', 'Chart Of Account Not Found', auth()->user(), '');

                return redirect()->back()->with('error', 'Chart Of Account Not Found');
            }
        } catch (Exception $e) {

            $logController->createLog(__METHOD__, 'error', $e, auth()->user(), '');

            return redirect()->back()->with('error', 'Something Went Wrong! ' . $e->getMessage());
        }
    }

    public function edit(Transactions $invoice)
    {
        $overseas_agent = Party::whereHas('party_type', function ($subQuery) {
            $subQuery->whereIn('type_id', [7, 13]);
        })->get();
        $transaction_master = TransactionMaster::where('transaction_id', $invoice->id)->first();
        $operations = Operations::all();
        $charges = Charge::all();
        $currencies = CurrencyMaster::all();

        // dd($invoice->receipt_payment_detail);

        return view('sea_export.se_agent_invoice.edit', compact('invoice', 'transaction_master', 'operations', 'charges', 'overseas_agent', 'currencies'));
    }
    public function editFromJob(JobMaster $job_master)
    {
        $invoice = Transactions::where('job_master_id', $job_master->id)->where('transaction_type_id', 2)->first();
        // dd($invoice);
        $invoiceCharges = TransactionCharges::where('transaction_id', $invoice->id)->get();
        $overseas_agent = Party::whereHas('party_type', function ($subQuery) {
            $subQuery->whereIn('type_id', [7, 13]);
        })->get();
        $operations = Operations::all();
        $charges = Charge::all();
        $currencies = CurrencyMaster::all();

        return view('sea_export.se_agent_invoice.editFromJob', compact('invoice', 'operations', 'charges', 'job_master', 'overseas_agent', 'invoiceCharges', 'currencies'));
    }

    public function update(Transactions $invoice, Request $request, LogsController $logController)
    {
        try {
            $status = 1;
            if ($request->bl_status == 2) {
                $status = 0;
                // Store the current job_master_id as the previous job_master_id before setting it to null
                $previousJob_master_id = $invoice->job_master_id;
            } else {
                $status = $invoice->status != 0 ? $invoice->status : 1;
                // Use the previous_job_master_id if bl_status is re-activated
                $previousJob_master_id = $invoice->previous_job_master_id ?? $invoice->job_master_id;
            }
            Transactions::where('id', $invoice->id)->update([
                'job_master_id' => $request->bl_status == 2 ? null : $previousJob_master_id,
                'previous_job_master_id' => $request->bl_status == 2 ? $previousJob_master_id : null,
                'transaction_type_id' => 2,
                // 'tran_no' => $request->tran_no,
                // 'inv_date' => $request->invoice_date,
                // 'agent_invoice_no' => $request->agent_invoice_no,
                'auto_manual' => $request->auto_manual,
                'job_type' => $request->job_type,
                'soa_date' => $request->soa_date,
                'soa_no' => $request->soa_no,
                'reference' => $request->reference,
                'bl_status' => $request->bl_status ?? 1,
                'category' => $request->category,
                'settlement' => $request->settlement,
                // 'overseas_agent_id' => $request->overseas_agent_id,
                'sequence_no' => $request->sequence_no,
                'invoice_type' => $request->invoice_type,
                'ref_tran_no' => $request->ref_tran_no,
                // 'operation_id' => $request->operation_id,
                'cost_center' => $request->cost_center,
                'invoice_to' => $request->invoice_to,
                'manual' => $request->manual,
                'due_days' => $request->due_days,
                'invoice_ac' => $request->invoice_ac,
                'auto_round_off' => $request->auto_round_off,
                'tax_charges' => $request->tax_charges,
                'remarks' => $request->remarks,
                // 'voucher_no' => $request->voucher_no,
                // 'bank_details' => $request->bank_details,
                // 'manual_remarks' => $request->manual_remarks,
                // 'grand_total_amount' => $request->grand_total_amount,
                // 'grand_net_amount' => $request->grand_net_amount,
                // 'grand_discount' => $request->grand_discount,
                // 'grand_tax_amount' => $request->grand_tax_amount,
                // 'grand_net_amount_inc_tax' => $request->grand_net_amount_inc_tax,
                // 'grand_local_amount' => $request->grand_local_amount,
                'status' => $status,
            ]);

            if ($request->bl_status == 2) {
                JobChargesReceivable::where('bill_invoice', $request->tran_no)->update([
                    'bill_invoice' => null,
                    'previous_bill_invoice' => $request->tran_no
                ]);
            } else if ($invoice->previous_job_master_id != null) {
                JobChargesReceivable::where('previous_bill_invoice', $request->tran_no)->update([
                    'bill_invoice' => $request->tran_no,
                    'previous_bill_invoice' => null,
                ]);
            }

            if ($request->bl_status == 2) {
                $transaction_master = TransactionMaster::where('transaction_id', $invoice->id)->first();

                if ($transaction_master) {
                    TransactionDetail::where('transaction_master_id', $transaction_master->id)->delete();
                    $transaction_master->delete();
                }
                TransactionCharges::where('transaction_id', $invoice->id)->delete();
            } else if ($invoice->previous_job_master_id != null) {
                $transaction_master = TransactionMaster::withTrashed()->where('transaction_id', $invoice->id)->first();
                TransactionCharges::withTrashed()->where('transaction_id', $invoice->id)->restore();

                if ($transaction_master) {
                    // Restore the TransactionMaster record
                    $transaction_master->restore();

                    // Retrieve and restore all associated soft-deleted TransactionDetail records
                    TransactionDetail::withTrashed()
                        ->where('transaction_master_id', $transaction_master->id)
                        ->restore();
                }
            }

            // $invoice = Transactions::where('job_master_id', $job_master->id)->first();

            // TransactionCharges::where('transaction_id', $invoice->id)->delete();

            // foreach ($request->charge_id as $index => $detail) {
            //     $transaction_charges = TransactionCharges::create([
            //         'transaction_id' => $invoice->id,
            //         'job_charge_recievable_id' => $request->bl_status == 2 ? null : $request->job_charge_recievable_id[$index],
            //         'job_id' => $request->bl_status == 2 ? null : $invoice->job_master_id,
            //         'charge_code' => $request->charge_code[$index],
            //         'charge_id' => $detail,
            //         'description' => $request->description[$index],
            //         'size_type' => $request->size_type[$index],
            //         'rate_group' => $request->rate_group[$index],
            //         'dg_non_dg' => $request->dg_non_dg[$index],
            //         'container' => $request->container[$index],
            //         'hbl_no' => $request->container[$index],
            //         'mbl_no' => $request->container[$index],
            //         'dr_cr' => $request->container[$index],
            //         'qty' => $request->qty[$index],
            //         'rate' => $request->rate[$index],
            //         'currency' => $request->currency[$index],
            //         'amount' => $request->amount[$index],
            //         'discount' => $request->discount[$index],
            //         'net_amount' => $request->net_amount[$index],
            //         'tax' => $request->tax[$index],
            //         'tax_amount' => $request->tax_amount[$index],
            //         'net_amount_inc_tax' => $request->net_amount_inc_tax[$index],
            //         'ex_rate' => $request->ex_rate[$index],
            //         'local_amount' => $request->local_amount[$index],
            //         'status' => 1,
            //     ]);
            // }
            $logController->createLog(__METHOD__, 'success', 'SE Agent Invoice Updated.', auth()->user(), '');

            // return redirect()->to('/se_invoice')->with('success', 'Record Updated SuccessFully!');
            if ($request->operation_id == 1) {
                return redirect()->to('/se_agent_invoice/edit/' . $invoice->id)->with('success', 'Record Updated SuccessFully!');
            } else if ($request->operation_id == 2) {
                return redirect()->to('/si_agent_invoice/edit/' . $invoice->id)->with('success', 'Record Updated SuccessFully!');
            } else if ($request->operation_id == 3) {
                return redirect()->to('/ae_agent_invoice/edit/' . $invoice->id)->with('success', 'Record Updated SuccessFully!');
            } else if ($request->operation_id == 4) {
                return redirect()->to('/ai_agent_invoice/edit/' . $invoice->id)->with('success', 'Record Updated SuccessFully!');
            } else {
                return redirect()->to('/se_agent_invoice/edit/' . $invoice->id)->with('success', 'Record Updated SuccessFully!');
            }
        } catch (Exception $e) {
            dd($e);

            $logController->createLog(__METHOD__, 'error', $e, auth()->user(), '');

            return redirect()->back()->with('error', 'Something Went Wrong!');
        }
    }
    public function updateFromJob(JobMaster $job_master, Request $request, LogsController $logController)
    {
        try {
            Transactions::where('job_master_id', $job_master->id)->update([
                'job_master_id' => $job_master->id,
                'transaction_type_id' => 2,
                'tran_no' => $request->tran_no,
                'inv_date' => $request->invoice_date,
                'agent_invoice_no' => $request->agent_invoice_no,
                'auto_manual' => $request->auto_manual,
                'job_type' => $request->job_type,
                'soa_date' => $request->soa_date,
                'soa_no' => $request->soa_no,
                'reference' => $request->reference,
                'bl_status' => $request->bl_status ?? 1,
                'category' => $request->category,
                'settlement' => $request->settlement,
                'overseas_agent_id' => $request->overseas_agent_id,
                'sequence_no' => $request->sequence_no,
                'invoice_type' => $request->invoice_type,
                'ref_tran_no' => $request->ref_tran_no,
                'operation_id' => $request->operation_id,
                'cost_center' => $request->cost_center,
                'invoice_to' => $request->invoice_to,
                'manual' => $request->manual,
                'due_days' => $request->due_days,
                'invoice_ac' => $request->invoice_ac,
                'auto_round_off' => $request->auto_round_off,
                'tax_charges' => $request->tax_charges,
                'remarks' => $request->remarks,
                'voucher_no' => $request->voucher_no,
                'bank_details' => $request->bank_details,
                'manual_remarks' => $request->manual_remarks,
                'grand_total_amount' => $request->grand_total_amount,
                'grand_net_amount' => $request->grand_net_amount,
                'grand_discount' => $request->grand_discount,
                'grand_tax_amount' => $request->grand_tax_amount,
                'grand_net_amount_inc_tax' => $request->grand_net_amount_inc_tax,
                'grand_local_amount' => $request->grand_local_amount,
                'status' => 1,
            ]);

            $invoice = Transactions::where('job_master_id', $job_master->id)->first();

            TransactionCharges::where('transaction_id', $invoice->id)->delete();

            foreach ($request->charge_id as $index => $detail) {
                $transaction_charges = TransactionCharges::create([
                    'transaction_id' => $invoice->id,
                    'job_id' => $job_master->id,
                    'job_charge_recievable_id' => $request->job_charge_recievable_id[$index],
                    'charge_code' => $request->charge_code[$index],
                    'charge_id' => $detail,
                    'description' => $request->description[$index],
                    'size_type' => $request->size_type[$index],
                    'rate_group' => $request->rate_group[$index],
                    'dg_non_dg' => $request->dg_non_dg[$index],
                    'container' => $request->container[$index],
                    'hbl_no' => $request->container[$index],
                    'mbl_no' => $request->container[$index],
                    'dr_cr' => $request->container[$index],
                    'qty' => $request->qty[$index],
                    'rate' => $request->rate[$index],
                    'currency' => $request->currency[$index],
                    'amount' => $request->amount[$index],
                    'discount' => $request->discount[$index],
                    'net_amount' => $request->net_amount[$index],
                    'tax' => $request->tax[$index],
                    'tax_amount' => $request->tax_amount[$index],
                    'net_amount_inc_tax' => $request->net_amount_inc_tax[$index],
                    'ex_rate' => $request->ex_rate[$index],
                    'local_amount' => $request->local_amount[$index],
                    'status' => 1,
                ]);
            }
            $logController->createLog(__METHOD__, 'success', 'SE Agent Invoice Updated.', auth()->user(), '');

            // return redirect()->to('/se_invoice')->with('success', 'Record Updated SuccessFully!');
            if ($job_master->operation_id == 1) {
                return redirect()->to('/se_agent_invoice/edit/fromjob/' . $job_master->id)->with('success', 'Record Updated SuccessFully!');
            } else if ($job_master->operation_id == 2) {
                return redirect()->to('/si_agent_invoice/edit/fromjob/' . $job_master->id)->with('success', 'Record Updated SuccessFully!');
            } else if ($job_master->operation_id == 3) {
                return redirect()->to('/ae_agent_invoice/edit/fromjob/' . $job_master->id)->with('success', 'Record Updated SuccessFully!');
            } else if ($job_master->operation_id == 4) {
                return redirect()->to('/ai_agent_invoice/edit/fromjob/' . $job_master->id)->with('success', 'Record Updated SuccessFully!');
            } else {
                return redirect()->to('/se_agent_invoice/edit/fromjob/' . $job_master->id)->with('success', 'Record Updated SuccessFully!');
            }
            // return redirect('/se_agent_invoice/edit/' . $job_master->id)->with('success', 'Record Updated SuccessFully!');
        } catch (Exception $e) {
            dd($e);

            $logController->createLog(__METHOD__, 'error', $e, auth()->user(), '');

            return redirect()->back()->with('error', 'Something Went Wrong!');
        }
    }

    public function manualInvoice(Request $request, JobMaster $job_master, LogsController $logController)
    {
        try {
            $job_charges_recievable = JobChargesReceivable::whereNull('bill_invoice')
                ->whereIn('id', explode(',', $request->job_receievable_charges_ids))
                ->where('ppcc', '!=', 'PP')
                ->get();
            $charges_ids = $request->job_receievable_charges_ids;

            $latest_transaction = Transactions::where('transaction_type_id', 2)->latest()->first() ?? 0;
            $voucher_no = 'AI-' . ((int) ($latest_transaction->id ?? 0) + 1) . '/' . date('y');
            $grand_total_amount = $job_charges_recievable->sum('amount');
            $grand_net_amount = $job_charges_recievable->sum('amount');
            $grand_discount = $job_charges_recievable->sum('discount');
            $grand_tax_amount = $job_charges_recievable->sum('tax_amount_lc');
            $grand_net_amount_inc_tax = $job_charges_recievable->sum('net_amount');
            $grand_local_amount = $job_charges_recievable->sum('local_amount');

            $overseas_agent = Party::whereHas('party_type', function ($subQuery) {
                $subQuery->whereIn('type_id', [7, 13]);
            })->get();
            $charges = Charge::all();
            $operations = Operations::all();
            $currencies = CurrencyMaster::all();

            $logController->createLog(__METHOD__, 'success', 'SE Agent Invoice Manual Redirect.', auth()->user(), '');


            return view('sea_export.se_agent_invoice.addFromJobManual', compact(
                'charges_ids',
                'voucher_no',
                'job_charges_recievable',
                'latest_transaction',
                'job_master',
                'grand_total_amount',
                'grand_net_amount',
                'grand_discount',
                'grand_tax_amount',
                'grand_net_amount_inc_tax',
                'grand_local_amount',
                'overseas_agent',
                'charges',
                'operations',
                'currencies'
            ));
        } catch (Exception $e) {

            $logController->createLog(__METHOD__, 'error', $e, auth()->user(), '');

            return redirect()->back()->with('error', 'Something Went Wrong!' . $e->getMessage());
        }
    }

    public function checkCC(JobMaster $job_master, Request $request, LogsController $logController)
    {
        try {
            $job_charges_recievable = JobChargesReceivable::whereNull('bill_invoice')
                ->whereIn('id', $request->job_receievable_charges_ids)
                ->where('ppcc', '!=', 'PP')
                ->get();
            // dd($job_charges_recievable);
            if ($job_charges_recievable->isEmpty()) {
                return response()->json(['error' => 'There are no CC Receivable exist', 'status' => 500], 500);
            } else {
                return response()->json(['data' => 'Data Saved!', 'status' => 200], 200);
            }
        } catch (Exception $e) {
            dd($e);

            DB::rollBack();

            $logController->createLog(__METHOD__, 'error', $e, auth()->user(), '');

            return response()->json(['data' => $e, 'status' => 500], 500);
        }
    }

    public function autoInvoice(Request $request, JobMaster $job_master, LogsController $logController)
    {
        try {
            $job_charges_recievable = JobChargesReceivable::whereNull('bill_invoice')
                ->whereIn('id', $request->job_receievable_charges_ids)
                ->where('ppcc', '!=', 'PP')
                ->get();
            // dd($job_charges_recievable);
            if ($job_charges_recievable->isEmpty()) {
                return response()->json(['error' => 'There are no CC Receivable exist', 'status' => 500], 500);
            } else {

                $chargesGroupedByCustomerId = $job_charges_recievable->groupBy('customer_id');

                DB::beginTransaction();

                foreach ($chargesGroupedByCustomerId as $customer_id => $charges) {
                    if ($customer_id) {
                        // dd($customer_id);
                        $party_id = ChartOfAccounts::where('party_id', $customer_id)->first();
                        // dd($party_id);

                        // $latest_transaction = Transactions::latest()->first();

                        // dd($latest_transaction);
                        if ($party_id) {
                            // $chargesGroupedByCurrency = $charges->groupBy('currency');
                            // foreach ($chargesGroupedByCurrency as $currency => $currencyCharges) {
                            $latest_transaction = Transactions::where('transaction_type_id', 2)->latest()->first();
                            $sum_amount = $charges->sum('amount');
                            $sum_discount = $charges->sum('discount');
                            $sum_tax = $charges->sum('tax_amount_lc');
                            $sum_net = $charges->sum('net_amount');
                            $sum_local = $charges->sum('local_amount');
                            $nextNumber = ($latest_transaction?->id ?? 0) + 1;
                            $tran_no = 'AI-' . $nextNumber . '/' . date('y');
                            $transaction = Transactions::create([
                                'job_master_id' => $job_master->id,
                                'transaction_type_id' => 2,
                                'tran_no' => $tran_no,
                                'inv_date' => $job_master->job_date ?? date('Y-m-d'),
                                'agent_invoice_no' => 'AI-' . ((int) ($latest_transaction->id ?? 0) + 1) . '/' . date('y'),
                                'auto_manual' => $request->auto_manual,
                                'job_type' => $request->job_type,
                                'soa_date' => $request->soa_date,
                                'soa_no' => $request->soa_no,
                                'reference' => $job_master->file_no,
                                'bl_status' => 1,
                                'category' => $request->category,
                                'settlement' => "un_settled",
                                'overseas_agent_id' => $customer_id,
                                'sequence_no' => $request->sequence_no,
                                'invoice_type' => "SI",
                                'ref_tran_no' => $request->ref_tran_no,
                                'operation_id' => $job_master->operation_id,
                                'cost_center' => "Head Office",
                                'invoice_to' => $request->invoice_to,
                                'manual' => $request->manual,
                                'due_days' => $request->due_days,
                                'invoice_ac' => $request->invoice_ac,
                                'auto_round_off' => $request->auto_round_off,
                                'tax_charges' => $request->tax_charges,
                                'remarks' => $request->remarks,
                                'voucher_no' => $request->voucher_no,
                                'bank_details' => $request->bank_details,
                                'manual_remarks' => $request->manual_remarks,
                                'grand_total_amount' => $sum_amount,
                                'grand_net_amount' => $sum_amount,
                                'grand_discount' => $sum_discount,
                                'grand_tax_amount' => $sum_tax,
                                'grand_net_amount_inc_tax' => $sum_net,
                                'grand_local_amount' => $sum_local,
                                // 'grand_total_amount' => $job_charges_recievable->sum('amount'),
                                // 'grand_net_amount' => $job_charges_recievable->sum('amount'),
                                // 'grand_discount' => $job_charges_recievable->sum('discount'),
                                // 'grand_tax_amount' => $job_charges_recievable->sum('tax_amount_lc'),
                                // 'grand_net_amount_inc_tax' => $job_charges_recievable->sum('net_amount'),
                                // 'grand_local_amount' => $job_charges_recievable->sum('local_amount'),
                                'status' => 1,
                            ]);

                            $last_voucher_number = TransactionMaster::where('voucher_type_id', 10)
                                ->max('voucher_no');


                            if (preg_match('/-(\d{5})\//', $last_voucher_number, $matches)) {
                                $sequence_number = intval($matches[1]) + 1;
                            } else {
                                $sequence_number = 1;
                            }
                            $sequence_number_padded = str_pad($sequence_number, 5, '0', STR_PAD_LEFT);
                            $year = date('y', strtotime($transaction->inv_date ?? date('Y-m-d')));
                            $new_voucher_number = 'SI-' . $sequence_number_padded . '/' . $year;

                            $transaction->update(['voucher_no' => $new_voucher_number]);

                            $transaction_master = TransactionMaster::create([
                                'transaction_id' => $transaction->id,
                                'voucher_no' => $new_voucher_number,
                                'job_master_id' => $transaction->job_master_id,
                                'date' => date('Y-m-d'),
                                'transaction_type_master_id' => 4,
                                'account_id' => 110, // Credit
                                'cost_center_id' => 1,
                                'party_id' => $party_id->id,
                                'exchange_rate' => $job_master->buying,
                                'total_debit' => $sum_local,
                                'total_credit' => $sum_local,
                                'currency_id' => 1,
                                // 'currency_id' => 1,
                                // 'exchange_rate' => $request->exchange_rate,
                                // 'cheque_date' => $request->cheque_date,
                                // 'total_debit' => $job_charges_recievable->sum('local_amount'),
                                // 'total_credit' => $job_charges_recievable->sum('local_amount'),
                                // 'bank_sub_type' => $request->bank_sub_type,
                                'company_id' => 1,
                                'status' => 4,
                                // 'narration' => 'Receivable Against Job # ' . 'AI-' . ((int) ($latest_transaction->id ?? 0) + 1) . '/' . date('y') . ' From ' . $party_id->name . '',
                                'narration' => 'Receivable Against Job # ' . 'AI-' . ((int) ($latest_transaction->id ?? 0) + 1) . '/' . date('y') . ', HBL Number: ' . $job_master->hbl_number . ', Reference Number: ' . $job_master->file_no . ', Invoice #: ' . $transaction->tran_no . ' From ' . $party_id->name . '',
                                'created_by' => auth()->user()->id,
                                'voucher_type_id' => 10
                            ]);

                            // Debit
                            TransactionDetail::create([
                                'transaction_master_id' => $transaction_master->id,
                                'account_id' => $party_id->id,
                                'job_master_id' => $transaction->job_master_id,
                                // 'cost_center_id' => $request->cost_center_detail[$key],
                                // 'debit_vc' => $request->debit_vc[$key],
                                // 'credit_vc' => $request->credit_vc[$key],
                                // 'debit_lc' => $job_charges_recievable->sum('local_amount'),
                                'debit_vc' => $sum_net,
                                'credit_vc' => 0,
                                'debit_lc' => $sum_local,
                                'credit_lc' => 0,
                                // 'narration' => 'Receivable Against Job # ' . 'AI-' . ((int) ($latest_transaction->id ?? 0) + 1) . '/' . date('y') . ' From ' . $party_id->name . '',
                                'narration' => 'Receivable Against Job # ' . 'AI-' . ((int) ($latest_transaction->id ?? 0) + 1) . '/' . date('y') . ', HBL Number: ' . $job_master->hbl_number . ', Reference Number: ' . $job_master->file_no . ', Invoice #: ' . $transaction->tran_no . ' From ' . $party_id->name . '',
                                'status' => 1
                            ]);

                            // Credit
                            TransactionDetail::create([
                                'transaction_master_id' => $transaction_master->id,
                                'account_id' => 110,
                                'job_master_id' => $transaction->job_master_id,
                                // 'cost_center_id' => $request->cost_center_detail[$key],
                                // 'debit_vc' => $request->debit_vc[$key],
                                // 'credit_vc' => $request->credit_vc[$key],
                                // 'debit_lc' => 0,
                                // 'credit_lc' => $job_charges_recievable->sum('local_amount'),
                                'debit_vc' => 0,
                                'credit_vc' => $sum_net,
                                'debit_lc' => 0,
                                'credit_lc' => $sum_local,
                                // 'narration' => 'Receivable Against Job # ' . 'AI-' . ((int) ($latest_transaction->id ?? 0) + 1) . '/' . date('y') . ' From ' . $party_id->name . '',
                                'narration' => 'Receivable Against Job # ' . 'AI-' . ((int) ($latest_transaction->id ?? 0) + 1) . '/' . date('y') . ', HBL Number: ' . $job_master->hbl_number . ', Reference Number: ' . $job_master->file_no . ', Invoice #: ' . $transaction->tran_no . ' From ' . $party_id->name . '',
                                'status' => 1
                            ]);

                            foreach ($charges as $detail) {
                                $transaction_charges = TransactionCharges::create([
                                    'transaction_id' => $transaction->id,
                                    'transaction_master_id' => $transaction_master->id,
                                    'job_id' => $job_master->id,
                                    'job_charge_recievable_id' => $detail->id,
                                    'charge_code' => $request->charge_code,
                                    'charge_id' => $detail->charge_id,
                                    'description' => $detail->description,
                                    'size_type' => $detail->size_type,
                                    'rate_group' => $detail->rate_group,
                                    'dg_non_dg' => $detail->dg_non_dg,
                                    'container' => $detail->container,
                                    'hbl_no' => $job_master->bl_master->hbl_no,
                                    'mbl_no' => $job_master->bl_master->mbl_no,
                                    'dr_cr' => $request->container,
                                    'qty' => $detail->qty,
                                    'rate' => $detail->rate,
                                    'currency' => $detail->currency,
                                    'amount' => $detail->amount,
                                    'net_amount' => $detail->amount,
                                    'discount' => $detail->discount,
                                    'tax' => $detail->tax,
                                    'tax_amount' => $detail->tax_amount_lc,
                                    'net_amount_inc_tax' => $detail->net_amount,
                                    'ex_rate' => $detail->ex_rate,
                                    'local_amount' => $detail->local_amount,
                                    'status' => 1,
                                ]);

                                JobChargesReceivable::where('id', $detail->id)->update([
                                    'bill_invoice' => $transaction->tran_no
                                ]);
                            }
                            // }
                        } else {
                            DB::rollBack();

                            $logController->createLog(__METHOD__, 'error', 'Party Account Not Found', auth()->user(), '');

                            return response()->json(['error' => 'Chart Of Account Not Found', 'status' => 500], 500);
                        }
                    } else {
                        DB::rollBack();

                        $logController->createLog(__METHOD__, 'error', 'Customer Name not selected', auth()->user(), '');

                        return response()->json(['error' => 'Agent Name not selected', 'status' => 500], 500);
                    }
                }
                DB::commit();

                $logController->createLog(__METHOD__, 'success', 'SE Agent Invoice Created.', auth()->user(), '');
                session()->flash('success', 'Auto Agent Invoice Created Successfully');
                return response()->json(['data' => 'Data Saved!', 'status' => 200], 200);
            }
        } catch (Exception $e) {
            // dd($e);

            DB::rollBack();

            $logController->createLog(__METHOD__, 'error', $e, auth()->user(), '');

            return response()->json(['data' => $e, 'status' => 500], 500);
        }
        // return view('sea_export.se_agent_invoice.auto_add', compact('job_master'));
    }

    public function print(Request $request, Transactions $invoice, LogsController $logController)
    {
        try {
            // dd($request->all());
            $hide_shipper_consignee = $request->hide_shipper_consignee;
            $hide_consignee = $request->hide_consignee;
            $hide_sa_line = $request->hide_sa_line;
            $hide_port_of_loading = $request->hide_port_of_loading;
            $hide_port_of_discharge = $request->hide_port_of_discharge;
            $hide_exchange_rate = $request->hide_exchange_rate;
            $hide_hbl = $request->hide_hbl;
            $hide_mbl = $request->hide_mbl;
            $print_logo = $request->print_logo;
            $print_on_letterhead = $request->print_on_letterhead;
            // $print_balance = $request->print_balance;
            $show_container = $request->show_container;
            $show_bank = $request->show_bank;
            $hide_volume = $request->hide_volume;
            $show_remarks = $request->show_remarks;
            $hide_sales_rep_and_ref_no = $request->hide_sales_rep_and_ref_no;
            $msg_of_system_generated_invoice = $request->msg_of_system_generated_invoice;
            $print_invoice_note = $request->print_invoice_note;
            $invoice_note = $request->invoice_note;
            $logController->createLog(__METHOD__, 'success', 'Invoice Print.', auth()->user(), '');
            $bl_master = BlMaster::where('job_master_id', $invoice->job_master->id)->first();
            $bl_container_info = $bl_master ? BlContainerInfo::where('bl_master_id', $bl_master->id)->first() : null;
            $containerNo = '';

            if ($bl_master && $bl_master->bl_container_info) {
                foreach ($bl_master->bl_container_info as $container) {
                    $containerNo = $bl_master->bl_container_info->pluck('container_no')->implode(', ');
                }
            }

            return view('sea_export.se_agent_invoice.pdf', compact('invoice', 'hide_sa_line', 'containerNo', 'hide_shipper_consignee', 'hide_consignee', 'hide_port_of_loading', 'hide_port_of_discharge', 'hide_exchange_rate', 'hide_hbl', 'hide_mbl', 'print_logo', 'print_on_letterhead', 'show_container', 'show_bank', 'hide_volume', 'show_remarks', 'hide_sales_rep_and_ref_no', 'msg_of_system_generated_invoice', 'print_invoice_note', 'invoice_note'));
        } catch (Exception $e) {
            $logController->createLog(__METHOD__, 'error', $e, auth()->user(), '');

            return redirect()->back()->with('error', 'Something Went Wrong!');
        }
    }
}
