<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;

use App\Models\Airport;
use App\Http\Requests\AirportRequest;
use App\Models\BlBookingInfo;
use App\Models\BlContainerInfo;
use App\Models\BlDetails;
use App\Models\BlMaster;
use App\Models\BlRefNo;
use App\Models\City;
use App\Models\Commodity;
use App\Models\Country;
use App\Models\HsCode;
use App\Models\JobMaster;
use App\Models\JobWeight;
use App\Models\Party;
use App\Models\Un_location;
use App\Models\Vessel;
use App\Models\Voyage;
use Carbon\Carbon;
use Exception;
use Illuminate\Http\Request;

class SEBlController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    // public function index(Request $request)
    // {
    //     // $se_bls = BlMaster::where('operation_id', 1)->get();
    //     // Get filter parameters from the request
    //     $filterBy = $request->filterBy;
    //     $filterValue = null;

    //     if ($request->shipper_id) {
    //         $filterValue = $request->shipper_id;
    //     } else if ($request->consignee_id) {
    //         $filterValue = $request->consignee_id;
    //     } else if ($request->vessel_id) {
    //         $filterValue = $request->vessel_id;
    //     } else if ($request->voyage_id) {
    //         $filterValue = $request->voyage_id;
    //     } else if ($request->notify_party_one) {
    //         $filterValue = $request->notify_party_one;
    //     } else if ($request->notify_party_two) {
    //         $filterValue = $request->notify_party_two;
    //     } else {
    //         $filterValue = $request->filterValue;
    //     }

    //     if ($filterBy && $filterValue) {
    //         switch ($filterBy) {
    //             case 'job_master_id':
    //                 $se_bls = BlMaster::where('job_master_id', $filterValue)->get();
    //                 break;
    //             case 'hbl_no':
    //                 $se_bls = BlMaster::where('hbl_no', $filterValue)->get();
    //                 break;
    //             case 'mbl_no':
    //                 $se_bls = BlMaster::where('mbl_no', $filterValue)->get();
    //                 break;
    //             case 'shipper_id':
    //                 $se_bls = BlMaster::where('shipper_id', $filterValue)->get();
    //                 break;
    //             case 'consignee_id':
    //                 $se_bls = BlMaster::where('consignee_id', $filterValue)->get();
    //                 break;
    //             case 'vessel_id':
    //                 $se_bls = BlMaster::where('vessel_id', $filterValue)->get();
    //                 break;
    //             case 'voyage_id':
    //                 $se_bls = BlMaster::where('voyage_id', $filterValue)->get();
    //                 break;
    //             case 'description_of_goods_and_pkgs':
    //                 $se_bls = BlMaster::whereHas('bl_detail', function ($subQuery) use ($filterValue) {
    //                     $subQuery->where('description_of_goods_and_pkgs', $filterValue);
    //                 })->get();
    //                 break;
    //             case 'notify_party_one':
    //                 $se_bls = BlMaster::where('notify_party_one', $filterValue)->get();
    //                 break;
    //             case 'notify_party_two':
    //                 $se_bls = BlMaster::where('notify_party_two', $filterValue)->get();
    //                 break;
    //             default:
    //                 return redirect()->back()->with('error', 'Invalid filter key: ' . $filterBy);
    //         }
    //     } else {
    //         $se_bls = BlMaster::where('operation_id', 1)->get();
    //     }

    //     $shippers = Party::whereHas('party_type', function ($subQuery) {
    //         $subQuery->where('type_id', 1);
    //     })->get();
    //     $consignees = Party::whereHas('party_type', function ($subQuery) {
    //         $subQuery->where('type_id', 2);
    //     })->get();
    //     $vessels = Vessel::where('status', 1)->get();
    //     $voyages = Voyage::where('status', 1)->get();
    //     $notify_parties = Party::whereHas('party_type', function ($subQuery) {
    //         $subQuery->where('type_id', 3);
    //     })->get();

    //     return view('sea_export.se_bl.index', compact('se_bls', 'shippers', 'consignees', 'vessels', 'voyages', 'notify_parties'));
    // }

    public function index(Request $request)
    {
        // Get filter parameters from the request
        $filterBy = $request->filterBy;
        $filterValue = null;
        $perPage = $request->input('perPage', session('perPage', 100));
        session(['perPage' => $perPage]);

        if ($request->shipper_id) {
            $filterValue = $request->shipper_id;
        } else if ($request->consignee_id) {
            $filterValue = $request->consignee_id;
        } else if ($request->vessel_id) {
            $filterValue = $request->vessel_id;
        } else if ($request->voyage_id) {
            $filterValue = $request->voyage_id;
        } else if ($request->notify_party_one) {
            $filterValue = $request->notify_party_one;
        } else if ($request->notify_party_two) {
            $filterValue = $request->notify_party_two;
        } else {
            $filterValue = $request->filterValue;
        }

        $url = $request->path();
        if ($url == "se_bl") {
            $query = BlMaster::where('operation_id', 1);
        } elseif ($url == "si_bl") {
            $query = BlMaster::where('operation_id', 2);
        } elseif ($url == "ae_bl") {
            $query = BlMaster::where('operation_id', 3);
        } elseif ($url == "ai_bl") {
            $query = BlMaster::where('operation_id', 4);
        }

        if ($filterBy && $filterValue) {
            switch ($filterBy) {
                case 'job_master_id':
                    $query->where('job_master_id', $filterValue);
                    break;
                case 'hbl_no':
                    $query->where('hbl_no', $filterValue);
                    break;
                case 'mbl_no':
                    $query->where('mbl_no', $filterValue);
                    break;
                case 'shipper_id':
                    $query->where('shipper_id', $filterValue);
                    break;
                case 'consignee_id':
                    $query->where('consignee_id', $filterValue);
                    break;
                case 'vessel_id':
                    $query->where('vessel_id', $filterValue);
                    break;
                case 'voyage_id':
                    $query->where('voyage_id', $filterValue);
                    break;
                case 'description_of_goods_and_pkgs':
                    $query->whereHas('bl_detail', function ($subQuery) use ($filterValue) {
                        $subQuery->where('description_of_goods_and_pkgs', 'like', '%' . $filterValue . '%');
                    });
                    break;
                case 'notify_party_one':
                    $query->where('notify_party_one', $filterValue);
                    break;
                case 'notify_party_two':
                    $query->where('notify_party_two', $filterValue);
                    break;
                default:
                    return redirect()->back()->with('error', 'Invalid filter key: ' . $filterBy);
            }
        }

        if ($request->bl_status) {
            $query->where('bl_status', $request->bl_status);
        }

        if ($request->filled('date_filter')) {
            $dateFilter = $request->input('date_filter');
            if ($dateFilter == 'today') {
                $query->whereDate('created_at', today());
            } elseif ($dateFilter == 'this_week') {
                $query->whereBetween('created_at', [now()->startOfWeek(), now()->endOfWeek()]);
            } elseif ($dateFilter == 'this_month') {
                $query->whereBetween('created_at', [now()->startOfMonth(), now()->endOfMonth()]);
            } elseif ($dateFilter == 'custom') {
                if ($request->filled('date_from') && $request->filled('date_to')) {
                    $query->whereBetween('created_at', [$request->input('date_from'), $request->input('date_to')]);
                }
            }
        }

        $se_bls = $query->orderBy('id', 'Desc')->paginate($perPage); // Remove pagination and get all results
        // dd($se_bls);
        $shippers = Party::whereHas('party_type', function ($subQuery) {
            $subQuery->where('type_id', 1);
        })->get();
        $consignees = Party::whereHas('party_type', function ($subQuery) {
            $subQuery->where('type_id', 2);
        })->get();
        $vessels = Vessel::where('status', 1)->get();
        $voyages = Voyage::where('status', 1)->get();
        $notify_parties = Party::whereHas('party_type', function ($subQuery) {
            $subQuery->where('type_id', 3);
        })->get();

        return view('sea_export.se_bl.index', compact('perPage', 'se_bls', 'shippers', 'consignees', 'vessels', 'voyages', 'notify_parties'));
    }

    public function add(JobMaster $job_master)
    {
        $shippers = Party::whereHas('party_type', function ($subQuery) {
            $subQuery->where('type_id', 1);
        })->get();
        $notify_parties = Party::whereHas('party_type', function ($subQuery) {
            $subQuery->where('type_id', 3);
        })->get();
        $consignees = Party::whereHas('party_type', function ($subQuery) {
            $subQuery->where('type_id', 2);
        })->get();
        $vessels = Vessel::where('status', 1)->get();
        $voyages = Voyage::where('status', 1)->get();
        $un_locations = Un_location::where('status', 1)->get();
        $commodities = Commodity::where('status', 1)->get();
        $overseas_agent = Party::whereHas('party_type', function ($subQuery) {
            $subQuery->whereIn('type_id', [7, 13]);
        })->get();
        $shipping_line = Party::whereHas('party_type', function ($subQuery) {
            $subQuery->where('type_id', 12);
        })->get();
        $hsCodes = HsCode::where('status', 1)->get();
        $se_bl = BlMaster::where('job_master_id', $job_master->id)->first();
        $currentDate = Carbon::now()->format('Y-m-d');
        $airline = Party::whereHas('party_type', function ($subQuery) {
            $subQuery->where('type_id', 17);
        })->get();

        if ($se_bl != null) {
            if ($se_bl->operation_id == 1) {
                return redirect()->to('se_bl/edit/' . $se_bl->id);
            } elseif ($se_bl->operation_id == 2) {
                return redirect()->to('si_bl/edit/' . $se_bl->id);
            } elseif ($se_bl->operation_id == 3) {
                return redirect()->to('ae_bl/edit/' . $se_bl->id);
            } elseif ($se_bl->operation_id == 4) {
                return redirect()->to('ai_bl/edit/' . $se_bl->id);
            }
        } else {
            return view('sea_export.se_bl.add', compact('notify_parties', 'airline', 'voyages', 'vessels', 'job_master', 'shippers', 'consignees', 'un_locations', 'commodities', 'overseas_agent', 'shipping_line', 'hsCodes', 'currentDate'));
        }
    }

    public function store(JobMaster $job_master, Request $request, LogsController $logController)
    {
        try {

            $bl_master = BlMaster::create([
                'operation_id' => $job_master->operation_id,
                'job_master_id' => $job_master->id,
                'bl_status' => $request->bl_status,
                'source' => $request->source,
                'bl_template' => $request->bl_template,
                'hbl_no' => $request->hbl_no,
                'hbl_date' => $request->hbl_date,
                'hbl_issue' => $request->hbl_issue,
                'mbl_no' => $request->mbl_no,
                'mbl_date' => $request->mbl_date,
                'shipper_id' => $request->shipper_id,
                'consignee_id' => $request->consignee_id,
                'notify_party_one' => $request->notify_party_one,
                'notify_party_two' => $request->notify_party_two,
                'vessel_id' => $request->vessel_id,
                'airline_id' => $request->airline_id,
                'sailing_date' => $request->sailing_date,
                'arrival_date' => $request->arrival_date,
                'voyage_id' => $request->voyage_id,
            ]);

            $bl_booking_info = BlBookingInfo::create([
                'bl_master_id' => $bl_master->id,
                'port_of_loading_id' => $request->port_of_loading_id,
                'port_of_discharge_id' => $request->port_of_discharge_id,
                'transportation_id' => $request->transportation_id,
                'final_destination_id' => $request->final_destination_id,
                'commodity_id' => $request->commodity_id,
                'reference_no' => $request->reference_no,
                'overseas_agent_id' => $request->overseas_agent_id,
                'shipping_line_id' => $request->shipping_line_id,
                'total_container' => $request->total_container,
                'delivery' => $request->delivery,
            ]);

            for ($i = 0; $i < $request->container_info_rows; $i++) {
                if ($request['container_no'][$i]) {
                    $bl_container_info = BlContainerInfo::create([
                        'bl_master_id' => $bl_master->id,
                        'container_no' => @$request['container_no'][$i],
                        'container_seal_no' => @$request['container_seal_no'][$i],
                        'container_size_type' => @$request['container_size_type'][$i],
                        'container_rate_group' => @$request['container_rate_group'][$i],
                        'container_gross_wt' => @$request['container_gross_wt'][$i],
                        'container_net_wt' => @$request['container_net_wt'][$i],
                        'container_tare_wt' => @$request['container_tare_wt'][$i],
                        'container_wt_unit' => @$request['container_wt_unit'][$i],
                        'container_cbm' => @$request['container_cbm'][$i],
                        'container_packages' => @$request['container_packages'][$i],
                        'container_unit' => @$request['container_unit'][$i],
                        'container_temperature' => @$request['container_temperature'][$i],
                        'container_load_type' => @$request['container_load_type'][$i],
                        'container_remarks' => @$request['container_remarks'][$i],
                        'container_detention' => @$request['container_detention'][$i],
                        'container_demurrage' => @$request['container_demurrage'][$i],
                        'container_plugin' => @$request['container_plugin'][$i],
                        'container_line_code' => @$request['container_line_code'][$i],
                        'container_part_fcl' => @$request['container_part_fcl'][$i],
                        'container_soc' => @$request['container_soc'][$i],
                        'container_dg_non_dg' => @$request['container_dg_non_dg'][$i],
                        'container_form_number' => @$request['container_form_number'][$i],
                        'container_form_date' => @$request['container_form_date'][$i],
                        'container_oog' => @$request['container_oog'][$i],
                        'container_top' => @$request['container_top'][$i],
                        'container_right' => @$request['container_right'][$i],
                        'container_left' => @$request['container_left'][$i],
                        'container_front' => @$request['container_front'][$i],
                        'container_back' => @$request['container_back'][$i],
                    ]);
                }
            }

            $bl_details = BlDetails::create([
                'bl_master_id' => $bl_master->id,
                'shipper' => $request->shipper,
                'consignee' => $request->consignee,
                'notify_party_one' => $request->detail_notify_party_one,
                'notify_party_two' => $request->detail_notify_party_two,
                'delivery_agent' => $request->delivery_agent,
                'port_of_loading_id' => $request->detail_port_of_loading_id,
                'port_of_discharge_id' => $request->detail_port_of_discharge_id,
                'place_of_delivery_id' => $request->place_of_delivery_id,
                'agent_stamp' => $request->agent_stamp,
                'no_of_original_bl' => $request->no_of_original_bl,
                'freight_type' => $request->freight_type,
                'unit' => $request->unit,
                'manual' => $request->manual,
                'net_wt' => $request->net_wt,
                'gross_wt' => $request->gross_wt,
                'tare_wt' => $request->tare_wt,
                'cbm' => $request->cbm,
                'pkgs' => $request->pkgs,
                'pkg_unit' => $request->pkg_unit,
                'hs_code_id' => $request->hs_code_id,
                'packing_group' => $request->packing_group,
                'hazmat_class' => $request->hazmat_class,
                'uno_code' => $request->uno_code,
                'marks_and_container_no' => $request->marks_and_container_no,
                'no_of_pkgs' => $request->no_of_pkgs,
                'description_of_goods_and_pkgs' => $request->description_of_goods_and_pkgs,
                'gross_weight' => $request->gross_weight,
                'measurement' => $request->measurement,
                'on_board_date' => $request->on_board_date,
                'place' => $request->place,
                'date_of_issue' => $request->date_of_issue,
                'fi_form_no' => $request->fi_form_no,
                'form_date' => $request->form_date,
            ]);

            $bl_ref_no = BlRefNo::create([
                'bl_master_id' => $bl_master->id,
                'invoice_no' => $request->invoice_no,
                'invoice_date' => $request->invoice_date,
                'export_no' => $request->export_no,
                'export_date' => $request->export_date,
                'contract_no' => $request->contract_no,
                'contract_date' => $request->contract_date,
                'lc_no' => $request->lc_no,
                'lc_date' => $request->lc_date,
                'client_ref_no' => $request->client_ref_no,
                'shipping_ref_no' => $request->shipping_ref_no,
                's_bill_no' => $request->s_bill_no,
                's_bill_date' => $request->s_bill_date,
            ]);

            $logController->createLog(__METHOD__, 'success', 'SE JOB Created.', auth()->user(), '');

            // return redirect()->to('/se_bl')->with('success', 'New Record Created SuccessFully!');
            if ($bl_master->operation_id == 1) {
                return redirect()->to('se_bl/edit/' . $bl_master->id)->with('success', 'Record Created SuccessFully!');
            } elseif ($bl_master->operation_id == 2) {
                return redirect()->to('si_bl/edit/' . $bl_master->id)->with('success', 'Record Created SuccessFully!');
            } elseif ($bl_master->operation_id == 3) {
                return redirect()->to('ae_bl/edit/' . $bl_master->id)->with('success', 'Record Created SuccessFully!');
            } elseif ($bl_master->operation_id == 4) {
                return redirect()->to('ai_bl/edit/' . $bl_master->id)->with('success', 'Record Created SuccessFully!');
            }
        } catch (Exception $e) {
            dd($e);

            $logController->createLog(__METHOD__, 'error', $e, auth()->user(), '');

            return redirect()->back()->with('error', 'Something Went Wrong!');
        }
    }

    public function edit(BlMaster $bl_master)
    {
        if ($bl_master->operation_id == 1) {
            $job_master = JobMaster::with(['job_detail', 'job_vessel', 'job_weight', 'job_equipments', 'job_charges_receivable', 'job_charges_receivable.charge', 'job_charges_receivable.customer', 'job_charges_payable', 'job_charges_payable.vendor', 'job_charges_payable.charge', 'job_charges', 'job_routing', 'job_other_info'])->where('operation_id', 1)->where('id', $bl_master->job_master_id)->first();
        } elseif ($bl_master->operation_id == 2) {
            $job_master = JobMaster::with(['job_detail', 'job_vessel', 'job_weight', 'job_equipments', 'job_charges_receivable', 'job_charges_receivable.charge', 'job_charges_receivable.customer', 'job_charges_payable', 'job_charges_payable.vendor', 'job_charges_payable.charge', 'job_charges', 'job_routing', 'job_other_info'])->where('operation_id', 2)->where('id', $bl_master->job_master_id)->first();
        } elseif ($bl_master->operation_id == 3) {
            $job_master = JobMaster::with(['job_detail', 'job_vessel', 'job_weight', 'job_equipments', 'job_charges_receivable', 'job_charges_receivable.charge', 'job_charges_receivable.customer', 'job_charges_payable', 'job_charges_payable.vendor', 'job_charges_payable.charge', 'job_charges', 'job_routing', 'job_other_info'])->where('operation_id', 3)->where('id', $bl_master->job_master_id)->first();
        } elseif ($bl_master->operation_id == 4) {
            $job_master = JobMaster::with(['job_detail', 'job_vessel', 'job_weight', 'job_equipments', 'job_charges_receivable', 'job_charges_receivable.charge', 'job_charges_receivable.customer', 'job_charges_payable', 'job_charges_payable.vendor', 'job_charges_payable.charge', 'job_charges', 'job_routing', 'job_other_info'])->where('operation_id', 4)->where('id', $bl_master->job_master_id)->first();
        }

        $shippers = Party::whereHas('party_type', function ($subQuery) {
            $subQuery->where('type_id', 1);
        })->get();
        $notify_parties = Party::whereHas('party_type', function ($subQuery) {
            $subQuery->where('type_id', 3);
        })->get();
        $consignees = Party::whereHas('party_type', function ($subQuery) {
            $subQuery->where('type_id', 2);
        })->get();
        $vessels = Vessel::where('status', 1)->get();
        $voyages = Voyage::where('status', 1)->get();
        $un_locations = Un_location::where('status', 1)->get();
        $commodities = Commodity::where('status', 1)->get();
        $overseas_agent = Party::whereHas('party_type', function ($subQuery) {
            $subQuery->whereIn('type_id', [7, 13]);
        })->get();
        $shipping_line = Party::whereHas('party_type', function ($subQuery) {
            $subQuery->where('type_id', 12);
        })->get();
        $hsCodes = HsCode::where('status', 1)->get();
        $airline = Party::whereHas('party_type', function ($subQuery) {
            $subQuery->where('type_id', 17);
        })->get();

        return view('sea_export.se_bl.edit', compact('notify_parties', 'airline', 'bl_master', 'voyages', 'vessels', 'job_master', 'shippers', 'consignees', 'un_locations', 'commodities', 'overseas_agent', 'shipping_line', 'hsCodes'));
    }

    public function update(BlMaster $bl_master, Request $request, LogsController $logController)
    {
        try {
            if ($bl_master->operation_id == 1) {
                $job_master = JobMaster::with(['job_detail', 'job_vessel', 'job_weight', 'job_equipments', 'job_charges_receivable', 'job_charges_receivable.charge', 'job_charges_receivable.customer', 'job_charges_payable', 'job_charges_payable.vendor', 'job_charges_payable.charge', 'job_charges', 'job_routing', 'job_other_info'])->where('operation_id', 1)->where('id', $bl_master->job_master_id)->first();
            } elseif ($bl_master->operation_id == 2) {
                $job_master = JobMaster::with(['job_detail', 'job_vessel', 'job_weight', 'job_equipments', 'job_charges_receivable', 'job_charges_receivable.charge', 'job_charges_receivable.customer', 'job_charges_payable', 'job_charges_payable.vendor', 'job_charges_payable.charge', 'job_charges', 'job_routing', 'job_other_info'])->where('operation_id', 2)->where('id', $bl_master->job_master_id)->first();
            } elseif ($bl_master->operation_id == 3) {
                $job_master = JobMaster::with(['job_detail', 'job_vessel', 'job_weight', 'job_equipments', 'job_charges_receivable', 'job_charges_receivable.charge', 'job_charges_receivable.customer', 'job_charges_payable', 'job_charges_payable.vendor', 'job_charges_payable.charge', 'job_charges', 'job_routing', 'job_other_info'])->where('operation_id', 3)->where('id', $bl_master->job_master_id)->first();
            } elseif ($bl_master->operation_id == 4) {
                $job_master = JobMaster::with(['job_detail', 'job_vessel', 'job_weight', 'job_equipments', 'job_charges_receivable', 'job_charges_receivable.charge', 'job_charges_receivable.customer', 'job_charges_payable', 'job_charges_payable.vendor', 'job_charges_payable.charge', 'job_charges', 'job_routing', 'job_other_info'])->where('operation_id', 4)->where('id', $bl_master->job_master_id)->first();
            }
            // dd($job_master->id);
            BlMaster::where('id', $bl_master->id)->update([
                'operation_id' => $job_master->operation_id,
                'job_master_id' => $job_master->id,
                'bl_status' => $request->bl_status,
                'source' => $request->source,
                'bl_template' => $request->bl_template,
                'hbl_no' => $request->hbl_no,
                'hbl_date' => $request->hbl_date,
                'hbl_issue' => $request->hbl_issue,
                'mbl_no' => $request->mbl_no,
                'mbl_date' => $request->mbl_date,
                'shipper_id' => $request->shipper_id,
                'consignee_id' => $request->consignee_id,
                'notify_party_one' => $request->notify_party_one,
                'notify_party_two' => $request->notify_party_two,
                'vessel_id' => $request->vessel_id,
                'airline_id' => $request->airline_id,
                'sailing_date' => $request->sailing_date,
                'arrival_date' => $request->arrival_date,
                'voyage_id' => $request->voyage_id,
            ]);

            $bl_booking_info = BlBookingInfo::where('bl_master_id', $bl_master->id)->update([
                'bl_master_id' => $bl_master->id,
                'port_of_loading_id' => $request->port_of_loading_id,
                'port_of_discharge_id' => $request->port_of_discharge_id,
                'transportation_id' => $request->transportation_id,
                'final_destination_id' => $request->final_destination_id,
                'commodity_id' => $request->commodity_id,
                'reference_no' => $request->reference_no,
                'overseas_agent_id' => $request->overseas_agent_id,
                'shipping_line_id' => $request->shipping_line_id,
                'total_container' => $request->total_container,
                'delivery' => $request->delivery,
            ]);


            if (isset($request['container_size_type']) && count($request['container_size_type']) > 0) {
                BlContainerInfo::where('bl_master_id', $bl_master->id)->delete();
                $loop_index = count($request['container_size_type']);
                // dd($loop_index);
                for ($i = 0; $i < $loop_index; $i++) {
                    if ($request['container_no'][$i] != null) {
                        $bl_container_info = BlContainerInfo::create([
                            'bl_master_id' => $bl_master->id,
                            'container_no' => @$request['container_no'][$i],
                            'container_seal_no' => @$request['container_seal_no'][$i],
                            'container_size_type' => @$request['container_size_type'][$i],
                            'container_rate_group' => @$request['container_rate_group'][$i],
                            'container_gross_wt' => @$request['container_gross_wt'][$i],
                            'container_net_wt' => @$request['container_net_wt'][$i],
                            'container_tare_wt' => @$request['container_tare_wt'][$i],
                            'container_wt_unit' => @$request['container_wt_unit'][$i],
                            'container_cbm' => @$request['container_cbm'][$i],
                            'container_packages' => @$request['container_packages'][$i],
                            'container_unit' => @$request['container_unit'][$i],
                            'container_temperature' => @$request['container_temperature'][$i],
                            'container_load_type' => @$request['container_load_type'][$i],
                            'container_remarks' => @$request['container_remarks'][$i],
                            'container_detention' => @$request['container_detention'][$i],
                            'container_demurrage' => @$request['container_demurrage'][$i],
                            'container_plugin' => @$request['container_plugin'][$i],
                            'container_line_code' => @$request['container_line_code'][$i],
                            'container_part_fcl' => @$request['container_part_fcl'][$i],
                            'container_soc' => @$request['container_soc'][$i],
                            'container_dg_non_dg' => @$request['container_dg_non_dg'][$i],
                            'container_form_number' => @$request['container_form_number'][$i],
                            'container_form_date' => @$request['container_form_date'][$i],
                            'container_oog' => @$request['container_oog'][$i],
                            'container_top' => @$request['container_top'][$i],
                            'container_right' => @$request['container_right'][$i],
                            'container_left' => @$request['container_left'][$i],
                            'container_front' => @$request['container_front'][$i],
                            'container_back' => @$request['container_back'][$i],
                        ]);
                    }
                }
            }

$bl_details = BlDetails::updateOrCreate(
    ['bl_master_id' => $bl_master->id], // condition to check
    [
                // 'bl_master_id' => $bl_master->id,
                'shipper' => $request->shipper,
                'consignee' => $request->consignee,
                'notify_party_one' => $request->detail_notify_party_one,
                'notify_party_two' => $request->detail_notify_party_two,
                'delivery_agent' => $request->delivery_agent,
                'port_of_loading_id' => $request->detail_port_of_loading_id,
                'port_of_discharge_id' => $request->detail_port_of_discharge_id,
                'place_of_delivery_id' => $request->place_of_delivery_id,
                'agent_stamp' => $request->agent_stamp,
                'no_of_original_bl' => $request->no_of_original_bl,
                'freight_type' => $request->freight_type,
                'unit' => $request->unit,
                'manual' => $request->manual,
                'net_wt' => $request->net_wt,
                'gross_wt' => $request->gross_wt,
                'tare_wt' => $request->tare_wt,
                'cbm' => $request->cbm,
                'pkgs' => $request->pkgs,
                'pkg_unit' => $request->pkg_unit,
                'hs_code_id' => $request->hs_code_id,
                'packing_group' => $request->packing_group,
                'hazmat_class' => $request->hazmat_class,
                'uno_code' => $request->uno_code,
                'marks_and_container_no' => $request->marks_and_container_no,
                'no_of_pkgs' => $request->no_of_pkgs,
                'description_of_goods_and_pkgs' => $request->description_of_goods_and_pkgs,
                'gross_weight' => $request->gross_weight,
                'measurement' => $request->measurement,
                'on_board_date' => $request->on_board_date,
                'place' => $request->place,
                'date_of_issue' => $request->date_of_issue,
                'fi_form_no' => $request->fi_form_no,
                'form_date' => $request->form_date,
            ]
);

$bl_ref_no = BlRefNo::updateOrCreate(
    ['bl_master_id' => $bl_master->id], // condition to check
    [
                // 'bl_master_id' => $bl_master->id,
                'invoice_no' => $request->invoice_no,
                'invoice_date' => $request->invoice_date,
                'export_no' => $request->export_no,
                'export_date' => $request->export_date,
                'contract_no' => $request->contract_no,
                'contract_date' => $request->contract_date,
                'lc_no' => $request->lc_no,
                'lc_date' => $request->lc_date,
                'client_ref_no' => $request->client_ref_no,
                'shipping_ref_no' => $request->shipping_ref_no,
                's_bill_no' => $request->s_bill_no,
                's_bill_date' => $request->s_bill_date,
            ]
);

            $job_weight = JobWeight::where('job_master_id', $job_master->id)->update([
                'weight' => $request->totalGrosswt,
                'container' => $request->totalcontainers,
                'pcs' => $request->totalpackages,
            ]);

            $logController->createLog(__METHOD__, 'success', 'SE BL Updated.', auth()->user(), '');

            // return redirect()->back()->with('success', 'Record Updated SuccessFully!');
            if ($bl_master->operation_id == 1) {
                return redirect()->to('se_bl/edit/' . $bl_master->id)->with('success', 'Record Updated SuccessFully!');
            } elseif ($bl_master->operation_id == 2) {
                return redirect()->to('si_bl/edit/' . $bl_master->id)->with('success', 'Record Updated SuccessFully!');
            } elseif ($bl_master->operation_id == 3) {
                return redirect()->to('ae_bl/edit/' . $bl_master->id)->with('success', 'Record Updated SuccessFully!');
            } elseif ($bl_master->operation_id == 4) {
                return redirect()->to('ai_bl/edit/' . $bl_master->id)->with('success', 'Record Updated SuccessFully!');
            }
        } catch (Exception $e) {
            dd($e);

            $logController->createLog(__METHOD__, 'error', $e, auth()->user(), '');

            return redirect()->back()->with('error', 'Something Went Wrong!');
        }
    }

    public function print(Request $request, LogsController $logController, BlMaster $bl_master)
    {
        try {
            // dd($request->all());
            $logController->createLog(__METHOD__, 'success', 'Bl Print.', auth()->user(), '');

            $pageType = $request->blank_preprinted_page;
            $blId = $bl_master->id;
            $noOfOriginal = $request->of_original_copies;
            $of_non_negotiable_copies = $request->of_non_negotiable_copies;

            // $bl_master = BlMaster::where('id', $blId)->first();
            if ($bl_master->operation_id == 1) {
                $job_master = JobMaster::with(['job_detail', 'job_vessel', 'job_weight', 'job_equipments', 'job_charges_receivable', 'job_charges_receivable.charge', 'job_charges_receivable.customer', 'job_charges_payable', 'job_charges_payable.vendor', 'job_charges_payable.charge', 'job_charges', 'job_routing', 'job_other_info'])->where('operation_id', 1)->where('id', $bl_master->job_master_id)->first();
            } elseif ($bl_master->operation_id == 2) {
                $job_master = JobMaster::with(['job_detail', 'job_vessel', 'job_weight', 'job_equipments', 'job_charges_receivable', 'job_charges_receivable.charge', 'job_charges_receivable.customer', 'job_charges_payable', 'job_charges_payable.vendor', 'job_charges_payable.charge', 'job_charges', 'job_routing', 'job_other_info'])->where('operation_id', 2)->where('id', $bl_master->job_master_id)->first();
            } elseif ($bl_master->operation_id == 3) {
                $job_master = JobMaster::with(['job_detail', 'job_vessel', 'job_weight', 'job_equipments', 'job_charges_receivable', 'job_charges_receivable.charge', 'job_charges_receivable.customer', 'job_charges_payable', 'job_charges_payable.vendor', 'job_charges_payable.charge', 'job_charges', 'job_routing', 'job_other_info'])->where('operation_id', 3)->where('id', $bl_master->job_master_id)->first();
            } elseif ($bl_master->operation_id == 4) {
                $job_master = JobMaster::with(['job_detail', 'job_vessel', 'job_weight', 'job_equipments', 'job_charges_receivable', 'job_charges_receivable.charge', 'job_charges_receivable.customer', 'job_charges_payable', 'job_charges_payable.vendor', 'job_charges_payable.charge', 'job_charges', 'job_routing', 'job_other_info'])->where('operation_id', 4)->where('id', $bl_master->job_master_id)->first();
            }


            // dd($bl_master);
            return view('sea_export.se_bl.pdf', compact('pageType', 'noOfOriginal', 'job_master', 'bl_master', 'of_non_negotiable_copies'));
        } catch (Exception $e) {
            $logController->createLog(__METHOD__, 'error', $e, auth()->user(), '');

            return redirect()->back()->with('error', 'Something Went Wrong!');
        }
    }
}
